/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report;

import gov.va.med.fw.cache.CacheStrategy;
import gov.va.med.fw.report.InvalidTemplateException;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportNameResolver;
import gov.va.med.fw.report.ReportTemplate;
import gov.va.med.fw.report.SimpleReportNameResolver;
import gov.va.med.fw.service.AbstractComponent;
import java.util.Map;
import org.apache.commons.lang.Validate;

public abstract class AbstractReportTemplate
extends AbstractComponent
implements ReportTemplate {
    private static final long serialVersionUID = 1034654168494467907L;
    private Map templates = null;
    private CacheStrategy templateCache = null;
    private ReportNameResolver nameResolver = null;
    private boolean preCompiled = false;

    protected AbstractReportTemplate() {
    }

    public boolean isPreCompiled() {
        return this.preCompiled;
    }

    public void setPreCompiled(boolean preCompile) {
        this.preCompiled = preCompile;
    }

    public void setTemplates(Map templates) {
        this.templates = templates;
    }

    public void setNameResolver(ReportNameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    public void setTemplateCache(CacheStrategy cache) {
        this.templateCache = cache;
    }

    public CacheStrategy getTemplateCache() {
        return this.templateCache;
    }

    @Override
    public Object getCompiledTemplate(ReportConfiguration config) throws InvalidTemplateException {
        String name = this.nameResolver.getReportName(config);
        if (!this.isPreCompiled()) {
            this.compileTemplates(this.templates);
        }
        return this.getTemplateCache().getItem(name);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.nameResolver == null) {
            this.nameResolver = new SimpleReportNameResolver();
        }
        Validate.notNull((Object)this.templateCache, (String)"A template cache is required");
        Validate.notEmpty((Map)this.templates, (String)"A map of report templates must be configured");
        if (this.isPreCompiled()) {
            this.compileTemplates(this.templates);
        }
    }

    protected abstract void compileTemplates(Map var1) throws InvalidTemplateException;
}

