/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.model.lookup;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class AbstractLookup
extends AbstractEntity
implements Lookup {
    private static final long serialVersionUID = 8255942734754635021L;
    private String description;
    private BigDecimal identifier = null;
    private String code;
    private Date startDate = null;
    private Date endDate = null;
    private Integer sortOrder = null;

    protected AbstractLookup() {
    }

    public BigDecimal getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(BigDecimal identifier) {
        this.identifier = identifier;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public AbstractCode getCodeObject() {
        String className = this.getClass().getName() + "$Code";
        try {
            Class<?> clazz = Class.forName(className);
            Method m = clazz.getMethod("getByCode", String.class);
            return (AbstractCode)((Object)m.invoke((Object)this, this.code));
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException(className + " is not defined in the concrete lookup class");
        }
        catch (NoSuchMethodException e) {
            throw new InvalidConfigurationException(className + " does not define getByCode(String) method");
        }
        catch (Exception e) {
            throw new InvalidConfigurationException(className + " .getByCode(String) method can not be invoked");
        }
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.identifier).toHashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof AbstractLookup && this.equals((AbstractLookup)o);
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        builder.append("identifier", (Object)this.identifier).append("code", (Object)this.code).append("startDate", (Object)this.startDate).append("endDate", (Object)this.endDate).append("sortOrder", (Object)this.sortOrder).append("description", (Object)this.description);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.setIdentifier(null);
        this.setCode(null);
        this.setStartDate(null);
        this.setEndDate(null);
        this.setSortOrder(null);
        this.setDescription(null);
    }

    private boolean equals(AbstractLookup o) {
        return new EqualsBuilder().append(this.getClass(), o.getClass()).append((Object)this.identifier, (Object)o.identifier).append((Object)this.code, (Object)o.code).isEquals();
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }
}

