/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.model;

import gov.va.med.fw.service.AbstractComponent;
import java.util.Set;

public class ConfigurableModelProperties
extends AbstractComponent {
    private Set inclusions;
    private Set exclusions;
    private ConfigurableModelProperties globalProperties;
    private boolean inheritAncestorsProperties = true;

    public ConfigurableModelProperties() {
    }

    public ConfigurableModelProperties(ConfigurableModelProperties globalProperties) {
        this.setGlobalProperties(globalProperties);
    }

    public void addInclusions(Set in) {
        if (in == null || in.isEmpty()) {
            return;
        }
        if (this.inclusions != null) {
            this.inclusions.addAll(in);
        } else {
            this.inclusions = in;
        }
    }

    public void addExclusions(Set in) {
        if (in == null || in.isEmpty()) {
            return;
        }
        if (this.exclusions != null) {
            this.exclusions.addAll(in);
        } else {
            this.exclusions = in;
        }
    }

    public Set getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(Set exclusions) {
        this.exclusions = exclusions;
    }

    public Set getInclusions() {
        return this.inclusions;
    }

    public void setInclusions(Set inclusions) {
        this.inclusions = inclusions;
    }

    public boolean containsInclusions() {
        return this.inclusions != null && this.inclusions.size() != 0;
    }

    public boolean containsExclusions() {
        return this.exclusions != null && this.exclusions.size() != 0;
    }

    public boolean isPropertySpecified(String propertyName) {
        return this.isPropertySpecifiedForInclusion(propertyName) || this.isPropertySpecifiedForExclusion(propertyName);
    }

    public void allowAllProperties() {
        this.inclusions = null;
        this.exclusions = null;
        this.globalProperties = new ConfigurableModelProperties();
    }

    public void rejectAllProperties() {
        this.inclusions = null;
        this.exclusions = null;
        this.globalProperties = null;
    }

    public boolean isPropertySpecifiedForInclusion(String propertyName) {
        boolean wasSpecified = false;
        if (this.containsInclusions()) {
            wasSpecified = this.inclusions.contains(propertyName);
        }
        return wasSpecified;
    }

    public boolean isPropertySpecifiedForExclusion(String propertyName) {
        boolean wasSpecified = false;
        if (this.containsExclusions()) {
            wasSpecified = this.exclusions.contains(propertyName);
        }
        return wasSpecified;
    }

    public boolean shouldInclude(String propertyName) {
        if (this.containsInclusions() && this.isPropertySpecifiedForInclusion(propertyName)) {
            return true;
        }
        if (this.containsExclusions() && this.isPropertySpecifiedForExclusion(propertyName)) {
            return false;
        }
        if (this.globalProperties == null) {
            return false;
        }
        boolean result = true;
        if (!this.isPropertySpecified(propertyName)) {
            boolean globalDecision;
            result = globalDecision = this.globalProperties.shouldInclude(propertyName);
            if (!globalDecision && !this.globalProperties.isPropertySpecified(propertyName)) {
                result = this.containsInclusions() && !this.isPropertySpecifiedForInclusion(propertyName) ? false : (this.containsExclusions() && !this.isPropertySpecifiedForExclusion(propertyName) ? true : true);
            }
        }
        return result;
    }

    public ConfigurableModelProperties getGlobalProperties() {
        return this.globalProperties;
    }

    public void setGlobalProperties(ConfigurableModelProperties globalProperties) {
        this.globalProperties = globalProperties;
    }

    public boolean isInheritAncestorsProperties() {
        return this.inheritAncestorsProperties;
    }

    public void setInheritAncestorsProperties(boolean inheritAncestorsProperties) {
        this.inheritAncestorsProperties = inheritAncestorsProperties;
    }

    public boolean isInheritAncestorsConfiguration(String propertyName) {
        return this.inheritAncestorsProperties && !this.isPropertySpecified(propertyName);
    }
}

