/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.mail;

import gov.va.med.fw.mail.MailService;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceDescriptor;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerableService;
import java.io.InputStream;
import java.io.Serializable;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.Validate;
import org.springframework.core.io.Resource;
import org.springframework.mail.MailException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class AsynchronousMailService
extends AbstractComponent
implements MailService {
    private static final long serialVersionUID = 6062056321128902438L;
    private TriggerableService triggerService = null;
    private String triggerEventName = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.triggerService, (String)"A trigger service is required");
        if (this.triggerEventName == null) {
            StringBuffer tmp = new StringBuffer(ClassUtils.getShortClassName((String)this.getClass().getName()));
            tmp.append(".").append(ClassUtils.getShortClassName((String)ServiceDescriptor.class.getName()));
            this.triggerEventName = tmp.toString();
        }
    }

    @Override
    public void send(String text, SimpleMailMessage template) throws MailException {
        Object[] params = new Object[]{text, template};
        TriggerEvent event = new TriggerEvent(this.triggerEventName, (Serializable)params);
        try {
            this.triggerService.trigger(event);
        }
        catch (ServiceException e) {
            throw new MailSendException("failed to send a message asynchronously", (Throwable)e);
        }
    }

    @Override
    public void send(String text, String attachment, SimpleMailMessage template) throws MailException {
        Object[] params = new Object[]{text, attachment, template};
        TriggerEvent event = new TriggerEvent(this.triggerEventName, (Serializable)params);
        try {
            this.triggerService.trigger(event);
        }
        catch (ServiceException e) {
            throw new MailSendException("failed to send a message asynchronously", (Throwable)e);
        }
    }

    @Override
    public void send(String text, Resource resource, SimpleMailMessage template) throws MailException {
        Object[] params = new Object[]{text, resource, template};
        TriggerEvent event = new TriggerEvent(this.triggerEventName, (Serializable)params);
        try {
            this.triggerService.trigger(event);
        }
        catch (ServiceException e) {
            throw new MailSendException("failed to send a message asynchronously", (Throwable)e);
        }
    }

    @Override
    public void send(String text, Resource resource, SimpleMailMessage template, String contentType) throws MailException {
        Object[] params = new Object[]{text, resource, template, contentType};
        TriggerEvent event = new TriggerEvent(this.triggerEventName, (Serializable)params);
        try {
            this.triggerService.trigger(event);
        }
        catch (ServiceException e) {
            throw new MailSendException("failed to send a message asynchronously", (Throwable)e);
        }
    }

    public MimeMessage createMimeMessage() {
        return null;
    }

    public MimeMessage createMimeMessage(InputStream arg0) throws MailException {
        return null;
    }

    public void send(MimeMessage mime) throws MailException {
        Object[] params = new Object[]{mime};
        TriggerEvent event = new TriggerEvent(this.triggerEventName, (Serializable)params);
        try {
            this.triggerService.trigger(event);
        }
        catch (ServiceException e) {
            throw new MailSendException("failed to send a message asynchronously", (Throwable)e);
        }
    }

    public void send(MimeMessage[] mimes) throws MailException {
        Object[] params = new Object[]{mimes};
        TriggerEvent event = new TriggerEvent(this.triggerEventName, (Serializable)params);
        try {
            this.triggerService.trigger(event);
        }
        catch (ServiceException e) {
            throw new MailSendException("failed to send a message asynchronously", (Throwable)e);
        }
    }

    public void send(MimeMessagePreparator preparator) throws MailException {
        Object[] params = new Object[]{preparator};
        TriggerEvent event = new TriggerEvent(this.triggerEventName, (Serializable)params);
        try {
            this.triggerService.trigger(event);
        }
        catch (ServiceException e) {
            throw new MailSendException("failed to send a message asynchronously", (Throwable)e);
        }
    }

    public void send(MimeMessagePreparator[] preparators) throws MailException {
        Object[] params = new Object[]{preparators};
        TriggerEvent event = new TriggerEvent(this.triggerEventName, (Serializable)params);
        try {
            this.triggerService.trigger(event);
        }
        catch (ServiceException e) {
            throw new MailSendException("failed to send a message asynchronously", (Throwable)e);
        }
    }

    public void send(SimpleMailMessage simple) throws MailException {
        Object[] params = new Object[]{simple};
        TriggerEvent event = new TriggerEvent(this.triggerEventName, (Serializable)params);
        try {
            this.triggerService.trigger(event);
        }
        catch (ServiceException e) {
            throw new MailSendException("failed to send a message asynchronously", (Throwable)e);
        }
    }

    public void send(SimpleMailMessage[] simple) throws MailException {
        Object[] params = new Object[]{simple};
        TriggerEvent event = new TriggerEvent(this.triggerEventName, (Serializable)params);
        try {
            this.triggerService.trigger(event);
        }
        catch (ServiceException e) {
            throw new MailSendException("failed to send a message asynchronously", (Throwable)e);
        }
    }

    public void setTriggerEventName(String triggerEventName) {
        this.triggerEventName = triggerEventName;
    }

    public void setTriggerService(TriggerableService triggerService) {
        this.triggerService = triggerService;
    }
}

