/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.hl7.builder;

import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.builder.HL7MetaData;
import gov.va.med.fw.hl7.builder.JMSMetaData;
import gov.va.med.fw.util.Reflector;
import gov.va.med.fw.util.builder.AbstractBuilder;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MessageBuilder
extends AbstractBuilder {
    private static final long serialVersionUID = 2385097269686572241L;
    public static final String MESSAGE_TYPE = "Message_Type";
    private static final String ORUZ07 = "ORUZ07";
    private static final String ORFZ07 = "ORFZ07";
    private static final String PID = "PID^";
    private static final String PD1 = "PD1";
    private Map messages = null;
    private ArrayList builders = null;
    private Class messageClass = null;

    public ArrayList getBuilders() {
        return this.builders;
    }

    public void setBuilders(ArrayList builders) {
        this.builders = builders;
    }

    public Class getMessageClass() {
        return this.messageClass;
    }

    public void setMessageClass(Class messageClass) {
        this.messageClass = messageClass;
    }

    public Map getMessages() {
        return this.messages;
    }

    public void setMessages(Map messages) {
        this.messages = messages;
    }

    public Object build(JMSMetaData data) throws BuilderException {
        Object output = null;
        try {
            String text = data.getTextMessage();
            if (text != null) {
                String type = this.getMessageType(data.getJMSMessage());
                if (type.equals(ORUZ07) || type.equals(ORFZ07)) {
                    text = this.mergePIDLineBreak(text);
                }
                String msg = (String)this.getMessages().get(type);
                output = Reflector.instantiate(msg, new Object[]{text, type});
            }
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Input data");
                this.logger.debug((Object)ToStringBuilder.reflectionToString((Object)data));
            }
            throw new BuilderException("Failed to build an inbound message", e);
        }
        return output;
    }

    private String mergePIDLineBreak(String txt) {
        boolean beforePID = true;
        boolean afterPID = false;
        StringBuffer str = new StringBuffer();
        String[] lines = txt.split("\r");
        for (int i = 0; i < lines.length; ++i) {
            if (beforePID) {
                if (lines[i].startsWith(PID)) {
                    beforePID = false;
                    if (lines[i + 1].startsWith(PD1)) {
                        return txt;
                    }
                    str.append(lines[i]);
                    continue;
                }
                str.append(lines[i]).append("\r");
                continue;
            }
            if (afterPID) {
                str.append(lines[i]).append("\r");
                continue;
            }
            if (lines[i].startsWith(PD1)) {
                afterPID = true;
                str.append("\r").append(lines[i]).append("\r");
                continue;
            }
            str.append(lines[i]);
        }
        return str.toString();
    }

    public Object build(HL7MetaData data) throws BuilderException {
        ArrayList builders = this.getBuilders();
        if (builders == null || builders.isEmpty()) {
            throw new BuilderException("A list of segment builders must be configured prior to this call");
        }
        Class msgClass = this.getMessageClass();
        if (msgClass == null) {
            throw new BuilderException("A message class [messageClass] must be configured prior to this call");
        }
        Message message = null;
        try {
            message = (Message)msgClass.newInstance();
            ArrayList segments = new ArrayList();
            for (int i = 0; i < builders.size(); ++i) {
                Builder builder;
                Object output;
                Object item = builders.get(i);
                if (!(item instanceof Builder) || !((output = (builder = (Builder)item).build(data)) instanceof List)) continue;
                segments.addAll((List)output);
            }
            message.setSegments(segments);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("MessageBuilder complete for message:" + message));
            }
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Input data");
                this.logger.debug((Object)ToStringBuilder.reflectionToString((Object)data));
            }
            throw new BuilderException("Failed to build an outbound message", e);
        }
        return message;
    }

    protected String getMessageType(javax.jms.Message msg) throws InvalidMessageException {
        String type = null;
        try {
            type = msg.getStringProperty(MESSAGE_TYPE);
        }
        catch (JMSException e) {
            throw new InvalidMessageException("Failed to get a message type from a message", e);
        }
        return type;
    }
}

