/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.hl7.builder;

import gov.va.med.fw.hl7.builder.AbstractMetaData;
import javax.jms.JMSException;
import javax.jms.Message;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter102;

public class JMSMetaData
extends AbstractMetaData {
    private static final long serialVersionUID = 6239636410042628897L;
    private MessageConverter converter = null;

    public JMSMetaData(Message data) {
        this(data, (MessageConverter)new SimpleMessageConverter102());
    }

    public JMSMetaData(Message data, MessageConverter converter) {
        super(data);
        this.converter = converter;
    }

    public Object getJMSMessageBody() throws JMSException {
        return this.converter.fromMessage(this.getJMSMessage());
    }

    public Message getJMSMessage() {
        return (Message)this.getData();
    }

    public String getTextMessage() throws JMSException {
        return this.getMessageBody(this.getJMSMessage());
    }

    protected String getMessageBody(Message message) throws JMSException {
        String text = null;
        Object body = this.getJMSMessageBody();
        if (body instanceof byte[]) {
            text = new String((byte[])body);
        } else if (body instanceof String) {
            text = (String)body;
        } else {
            throw new MessageConversionException("Invalid message body to convert to a string");
        }
        return text;
    }
}

