/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.hl7;

import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.SegmentFactory;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.SystemUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageParser {
    public static final String INDENT_CHARS = "    ";
    public static final String MESSAGE_LINE_SEPARATOR = "\r";
    private static Log logger = LogFactory.getLog(MessageParser.class);

    public static String parseElements(String name, String delimiter, List list) {
        if (name == null || delimiter == null || list == null) {
            throw new IllegalArgumentException("Invalid parameter to parse elements.");
        }
        StringBuffer message = new StringBuffer(name);
        for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            if (element != null && element.equals("")) {
                element = "\"\"";
            }
            if ((name.equals("BHS") || name.equals("MSH")) && i == 0) continue;
            message.append(delimiter);
            if (element == null) continue;
            message.append(element);
        }
        return message.toString();
    }

    public static List parseElements(String name, String delimiter, String data) {
        if (name == null || delimiter == null || data == null || data.length() == 0) {
            throw new IllegalArgumentException("Invalid parameter to parse elements.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Building:" + name));
        }
        ArrayList<String> elements = null;
        StringTokenizer tokens = new StringTokenizer(data, delimiter, true);
        if (tokens.hasMoreTokens()) {
            elements = new ArrayList<String>();
            String current = tokens.nextToken();
            if (name.equals("BHS") || name.equals("MSH")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding:" + delimiter));
                }
                elements.add(delimiter);
            }
            String prev = current;
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (token.equals(prev) && token.equals(delimiter)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding:" + null));
                    }
                    elements.add(null);
                } else if (!token.equals(delimiter)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding:" + (token.equals("\"\"") ? "" : token)));
                    }
                    elements.add(token.equals("\"\"") ? "" : token);
                }
                prev = token;
            }
        }
        return elements;
    }

    public static String[] parseElement(String data, String delimiter) {
        String[] values = null;
        if (data != null && data.indexOf(delimiter) != -1) {
            values = data.split(delimiter);
        }
        return values;
    }

    public static String parseSegments(List list) {
        return MessageParser.parseSegments(list, false);
    }

    public static String parseSegments(List list, boolean wrapSegmentData) {
        StringBuffer message = new StringBuffer();
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Invalid list of message segments.");
        }
        for (Object obj : list) {
            if (!(obj instanceof Segment)) {
                throw new IllegalArgumentException("Invalid list of message segments");
            }
            StringBuffer segmentData = new StringBuffer().append(((Segment)obj).getName()).append(((Segment)obj).getElementData());
            if (wrapSegmentData) {
                segmentData = MessageParser.getWrappedSegmentData(segmentData);
            }
            message.append(segmentData.append(MESSAGE_LINE_SEPARATOR));
        }
        return message.toString();
    }

    private static StringBuffer getWrappedSegmentData(StringBuffer segmentData) {
        if (segmentData.length() > 244) {
            int numberOfLines = segmentData.length() / 244;
            for (int j = 1; j <= numberOfLines; ++j) {
                segmentData.insert(243 * j, MESSAGE_LINE_SEPARATOR);
            }
        }
        return segmentData;
    }

    public static List parseSegments(String delimiter, String[] encoders, String data) throws InvalidMessageException {
        ArrayList<Segment> segments = null;
        if (data == null || data.length() == 0 || delimiter == null || encoders == null) {
            throw new IllegalArgumentException("Invalid parameters to parse a list of segments");
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(data));
            String currentLine = null;
            segments = new ArrayList<Segment>();
            SegmentFactory factory = SegmentFactory.getInstance();
            List<String> segmentsList = Arrays.asList(SegmentConstants.HL7_SEGMENTS_LIST);
            boolean isSegmentStarted = false;
            String workingSegment = null;
            while ((currentLine = reader.readLine()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Segment: " + currentLine));
                }
                if (StringUtils.trim((String)currentLine).length() >= 3 && segmentsList.contains(currentLine.subSequence(0, 3)) && !isSegmentStarted) {
                    isSegmentStarted = true;
                    workingSegment = currentLine;
                    continue;
                }
                if (StringUtils.trim((String)currentLine).length() >= 3 && segmentsList.contains(currentLine.subSequence(0, 3)) && isSegmentStarted) {
                    segments.add(factory.createSegment(encoders, delimiter, workingSegment));
                    isSegmentStarted = true;
                    workingSegment = currentLine;
                    continue;
                }
                if (StringUtils.trim((String)currentLine).length() >= 3 && (segmentsList.contains(currentLine.subSequence(0, 3)) || !isSegmentStarted)) continue;
                workingSegment = workingSegment + currentLine;
            }
            segments.add(factory.createSegment(encoders, delimiter, workingSegment));
        }
        catch (Exception e) {
            throw new InvalidMessageException("Invalid message data to parse:  " + data + " " + e.getMessage(), e);
        }
        return segments;
    }

    public static String getDelimiterCharacter(String data) throws InvalidMessageException {
        if (data == null) {
            throw new IllegalArgumentException("Missing a message data string");
        }
        String delimiter = null;
        if (data.startsWith("BHS") || data.startsWith("MSH")) {
            delimiter = String.valueOf(data.substring(3).charAt(0));
        }
        if (delimiter == null) {
            throw new InvalidMessageException("Invalid message format.");
        }
        return delimiter;
    }

    public static String[] getEncodingCharacters(String data) throws InvalidMessageException {
        if (data == null) {
            throw new IllegalArgumentException("Missing a message data string");
        }
        String delimiter = MessageParser.getDelimiterCharacter(data);
        String[] encoders = null;
        try {
            int delimiterPos = data.indexOf(delimiter);
            encoders = new String[]{String.valueOf(data.charAt(++delimiterPos)), String.valueOf(data.charAt(++delimiterPos)), String.valueOf(data.charAt(++delimiterPos)), String.valueOf(data.charAt(++delimiterPos))};
        }
        catch (Exception e) {
            throw new InvalidMessageException("Failed to parse encoding characters");
        }
        return encoders;
    }

    public static String getFormattedRawMessage(String data, int maxCharsPerLine) throws InvalidMessageException {
        if (StringUtils.isEmpty((String)data) || maxCharsPerLine <= 0) {
            return "";
        }
        String delimiter = MessageParser.getDelimiterCharacter(data);
        String[] encodingChars = MessageParser.getEncodingCharacters(data);
        ArrayList<String> separators = new ArrayList<String>(Arrays.asList(encodingChars));
        separators.add(delimiter);
        List segments = MessageParser.parseSegments(delimiter, encodingChars, data);
        if (segments == null || segments.isEmpty()) {
            throw new InvalidMessageException("Invalid list of message segments.");
        }
        StringBuffer messageBuffer = new StringBuffer();
        Iterator i = segments.iterator();
        while (i.hasNext()) {
            Object segmentObject = i.next();
            if (!(segmentObject instanceof Segment)) {
                throw new InvalidMessageException("Invalid list of message segments");
            }
            Segment segment = (Segment)segmentObject;
            StringBuffer segmentBuffer = new StringBuffer().append(segment.getName()).append(segment.getElementData());
            StringBuffer dataLeftBuffer = new StringBuffer(segmentBuffer.toString());
            StringBuffer formattedSegmentBuffer = new StringBuffer();
            int index = 0;
            while (index >= 0) {
                index = MessageParser.getIndexToInsertReturn(dataLeftBuffer, separators, maxCharsPerLine);
                if (index == -1) {
                    formattedSegmentBuffer.append(dataLeftBuffer);
                    continue;
                }
                formattedSegmentBuffer.append(dataLeftBuffer.substring(0, index + 1));
                dataLeftBuffer.delete(0, index + 1);
                if (dataLeftBuffer.length() > 0) {
                    formattedSegmentBuffer.append(SystemUtils.LINE_SEPARATOR).append(INDENT_CHARS);
                    continue;
                }
                index = -1;
            }
            messageBuffer.append(formattedSegmentBuffer);
            if (!i.hasNext()) continue;
            messageBuffer.append(SystemUtils.LINE_SEPARATOR);
        }
        return messageBuffer.toString();
    }

    private static int getIndexToInsertReturn(StringBuffer buffer, List separators, int maxCharsPerLine) {
        if (buffer.length() <= maxCharsPerLine) {
            return -1;
        }
        for (int index = maxCharsPerLine - 1; index >= 0; --index) {
            String currentChar = String.valueOf(buffer.charAt(index));
            if (!separators.contains(currentChar)) continue;
            return index;
        }
        return maxCharsPerLine - 1;
    }

    public static Date getTransmissionDate(Message message) throws ParseException, InvalidMessageException {
        if (message == null) {
            throw new IllegalArgumentException("Missing a message");
        }
        Segment header = message.getSegment("MSH");
        if (header == null) {
            throw new InvalidMessageException("Invalid message. A message must have a header segment");
        }
        List elements = header.getElements();
        Object date = null;
        if (elements != null && elements.size() >= 7) {
            date = elements.get(6);
        }
        return date == null ? null : new SimpleDateFormat("yyyyMMddHHmmssZ").parse(date.toString());
    }
}

