/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.DataFileProcessStatistics;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CampLejeuneImportProcessStatistics
extends DataFileProcessStatistics {
    private static final long serialVersionUID = -668691275608266023L;
    private StringBuffer summary = new StringBuffer("ICN|FirstName|LastName|SSN|DOB|Gender|");
    private StringBuffer detailSuccess = new StringBuffer("ICN|FirstName|LastName|SSN|DOB|Gender|").append("OldPriorityGroup").append("|").append("NewPriorityGroup").append("\n");
    private StringBuffer detailUnsuccess = new StringBuffer("ICN|FirstName|LastName|SSN|DOB|Gender|").append("ErrorReason").append("\n");
    public static final String REPORT_HEADER = "ICN|FirstName|LastName|SSN|DOB|Gender|";
    public static final String LINE_BREAK = "\n";
    public static final String DELIMITER = "|";
    public static final String REASON_FAILED = "ReasonFailed";

    @Override
    public Map statsMap() throws Exception {
        Map data = BeanUtils.describe((Object)this);
        data.remove("detailSuccess");
        data.remove("detailUnsuccess");
        this.formatDateField(data, "processingStartDate", this.getProcessingStartDate());
        this.formatDateField(data, "processingEndDate", this.getProcessingEndDate());
        data.remove("class");
        return data;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("Counts of Successful Processed: ", this.getNumberOfSuccessfulRecords());
        builder.append("Counts of Unsuccessful Processed: ", this.getNumberOfErrorRecords());
        builder.append("Counts of Total Processed: ", this.getNumberOfTotalRecords());
    }

    public String getDetailSuccess() {
        return this.detailSuccess.toString();
    }

    public String getDetailUnsuccess() {
        return this.detailUnsuccess.toString();
    }

    public synchronized void addDetailSuccess(String idData, String oldPriGrp, String newPriGrp) {
        this.detailSuccess.append(idData).append(DELIMITER).append(oldPriGrp).append(DELIMITER).append(newPriGrp).append(LINE_BREAK);
    }

    public synchronized void addDetailUnsuccess(String idData, String errReason) {
        this.detailUnsuccess.append(idData).append(DELIMITER).append(StringUtils.remove((String)errReason, (String)LINE_BREAK)).append(LINE_BREAK);
    }
}

