/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.BatchProcessService;
import gov.va.med.fw.batchprocess.JobResultData;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.batchprocess.model.JobConfig;
import gov.va.med.fw.batchprocess.model.JobResult;
import gov.va.med.fw.batchprocess.model.JobStatus;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.scheduling.AuditableScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.scheduling.ScheduledProcessTriggerEvent;
import gov.va.med.fw.scheduling.SchedulingService;
import gov.va.med.fw.security.LoginManager;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.Reflector;
import gov.va.med.fw.util.SystemUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.JobDetailBean;

public class BatchProcessServiceImpl
extends AbstractComponent
implements BatchProcessService {
    private static String NAMED_QUERY_GET_JOB_RESULTS_BY_STATUS = "jobResultQuery_GetByStatus";
    private static String NAMED_QUERY_GET_JOB_RESULTS_BY_JOB_NAME_AND_STATUS = "jobResultQuery_GetFinishedByJobNameAndStatus";
    private static String NAMED_QUERY_GET_JOB_RESULTS_BY_JOB_NAME_AND_JOB_GROUP_AND_STATUS = "jobResultQuery_GetFinishedByJobNameAndJobGroupAndStatus";
    private static String NAMED_QUERY_GET_JOB_CONFIG_BY_JOB_NAME = "jobConfigQuery_GetByJobName";
    private static String NAMED_QUERY_GET_JOB_CONFIG_BY_JOB_NAME_AND_JOB_GROUP = "jobConfigQuery_GetByJobNameAndJobGroup";
    private static String PARAM_STATUS = "status";
    private static String PARAM_JOB_NAME = "jobName";
    private static String PARAM_JOB_GROUP = "jobGroup";
    private DAOOperations dao;
    private LoginManager loginManager;
    private SchedulingService schedulingService;

    @Override
    public void saveJobResult(JobResult jr) throws ServiceException {
        try {
            this.dao.saveObject(jr);
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to save JobResult", e);
        }
    }

    @Override
    public JobResult getJobResult(EntityKey key) throws ServiceException {
        try {
            return (JobResult)this.dao.getByKey(key);
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to get JobResult", e);
        }
    }

    @Override
    public JobResultData saveAndOverlayJobResult(EntityKey jobResultKey, ProcessStatistics stats, int totalDataCount) throws ServiceException {
        JobResult jr = this.getAndLockJobResult(jobResultKey);
        ProcessStatistics updatedStats = null;
        try {
            updatedStats = (ProcessStatistics)stats.getClass().newInstance();
            updatedStats.importFromCSV(jr.getStatistics());
            updatedStats.overlayStats(stats);
            if (updatedStats.getNumberOfTotalRecords() >= totalDataCount) {
                updatedStats.setProcessingEndDate(new Date());
                jr.setEndDate(updatedStats.getProcessingEndDate());
                if (updatedStats.getNumberOfErrorRecords() > 0) {
                    jr.setStatus(JobStatus.COMPLETE_WITH_ERROR);
                } else {
                    jr.setStatus(JobStatus.COMPLETE);
                }
            }
            jr.setStatistics(updatedStats.exportAsCSV());
            this.saveJobResult(jr);
        }
        catch (Exception e) {
            throw new ServiceException("Unable to saveAndOverlayJobResult", e);
        }
        return new JobResultData(jr, updatedStats);
    }

    private JobResult getAndLockJobResult(EntityKey key) throws ServiceException {
        try {
            HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
            contextData.put("entityKey", key);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                @Override
                public Object execute(Session session) {
                    EntityKey key = (EntityKey)this.getContextData().get("entityKey");
                    return session.load(JobResult.class, key.getKeyValue(), LockMode.UPGRADE);
                }
            };
            return (JobResult)this.dao.execute(callback);
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to getAndLockJobResult for key=" + key, e);
        }
    }

    @Override
    public void saveJobConfig(JobConfig jc) throws ServiceException {
        try {
            this.dao.saveObject(jc);
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to save JobConfig", e);
        }
    }

    @Override
    public JobConfig getJobConfig(String jobName, String jobGroup) throws ServiceException {
        try {
            List data = null;
            data = jobGroup == null ? this.dao.findByNamedQueryAndNamedParam(NAMED_QUERY_GET_JOB_CONFIG_BY_JOB_NAME, PARAM_JOB_NAME, jobName) : this.dao.findByNamedQueryAndNamedParam(NAMED_QUERY_GET_JOB_CONFIG_BY_JOB_NAME_AND_JOB_GROUP, new String[]{PARAM_JOB_NAME, PARAM_JOB_GROUP}, new Object[]{jobName, jobGroup});
            return data != null && !data.isEmpty() ? (JobConfig)data.get(0) : null;
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to get JobConfig for jobName: " + jobName, e);
        }
    }

    @Override
    public List getJobResults(JobStatus status) throws ServiceException {
        try {
            return this.dao.findByNamedQueryAndNamedParam(NAMED_QUERY_GET_JOB_RESULTS_BY_STATUS, PARAM_STATUS, status.getCode());
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to getJobResults with status: " + status, e);
        }
    }

    @Override
    public List getFinishedJobResults(String jobName, String jobGroup) throws ServiceException {
        try {
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("jobName", jobName);
            if (jobGroup != null) {
                contextData.put("jobGroup", jobGroup);
            }
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                @Override
                public Object execute(Session session) {
                    Query query = null;
                    if (!this.getContextData().containsKey("jobGroup")) {
                        query = session.getNamedQuery(NAMED_QUERY_GET_JOB_RESULTS_BY_JOB_NAME_AND_STATUS);
                    } else {
                        query = session.getNamedQuery(NAMED_QUERY_GET_JOB_RESULTS_BY_JOB_NAME_AND_JOB_GROUP_AND_STATUS);
                        query.setString(PARAM_JOB_GROUP, (String)this.getContextData().get("jobGroup"));
                    }
                    query.setString(PARAM_JOB_NAME, (String)this.getContextData().get("jobName"));
                    query.setMaxResults(25);
                    return query.list();
                }
            };
            return this.dao.executeFind(callback);
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to getFinishedJobResults for jobName: " + jobName, e);
        }
    }

    @Override
    public void executeJob(ScheduledProcessTriggerEvent triggerEvent) throws ServiceException {
        this.executeJob((ScheduledProcessInvocationContext)triggerEvent.getPayload());
    }

    @Override
    public void executeJob(ScheduledProcessInvocationContext invocationContext) throws ServiceException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Executing job/process [" + invocationContext.getJobName() + "] for executionContext/user [" + invocationContext.getExecutionContext() + "]"));
        }
        String auditInfo = null;
        long beforeUsedMemory = SystemUtils.getUsedMemory();
        try {
            String serviceName = null;
            String methodName = null;
            if (invocationContext.getJobDetailBeanName() != null) {
                JobDetailBean job = (JobDetailBean)this.getApplicationContext().getBean(invocationContext.getJobDetailBeanName(), JobDetailBean.class);
                serviceName = (String)job.getJobDataMap().get((Object)"serviceName");
                methodName = (String)job.getJobDataMap().get((Object)"methodName");
            } else {
                serviceName = invocationContext.getServiceName();
                methodName = invocationContext.getMethodName();
            }
            Object service = this.getApplicationContext().getBean(serviceName);
            auditInfo = service instanceof AuditableScheduledProcess ? ((AuditableScheduledProcess)service).getAuditInfo(invocationContext) : serviceName + "." + methodName;
            this.getLoginManager().loginAnonymous(auditInfo);
            Object[] args = new Object[]{invocationContext};
            try {
                Reflector.findMethod(service, methodName, args);
            }
            catch (NoSuchMethodException e) {
                Object[] objectArray;
                Object obj = invocationContext.getInvocationArguments();
                if (obj instanceof Object[]) {
                    objectArray = (Object[])obj;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = obj;
                }
                args = objectArray;
            }
            Reflector.invoke(service, methodName, args);
            this.getLoginManager().logout();
        }
        catch (Throwable e) {
            try {
                throw new ServiceException("Unable to execute job with ScheduledProcessInvocationContext: " + invocationContext, e);
            }
            catch (Throwable throwable) {
                this.getLoginManager().logout();
                SystemUtils.logMemory(true);
                SystemUtils.logMemoryDelta(auditInfo, beforeUsedMemory);
                throw throwable;
            }
        }
        SystemUtils.logMemory(true);
        SystemUtils.logMemoryDelta(auditInfo, beforeUsedMemory);
    }

    public DAOOperations getDao() {
        return this.dao;
    }

    public void setDao(DAOOperations dao) {
        this.dao = dao;
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.dao, (String)"A dao is required");
        Validate.notNull((Object)this.loginManager, (String)"A loginManager is required");
        Validate.notNull((Object)this.schedulingService, (String)"A schedulingService is required");
    }

    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @Override
    public void cancelActiveJob(EntityKey key) throws ServiceException {
        JobResult jobResult = this.getJobResult(key);
        if (JobStatus.IN_PROCESS.getCode().equals(jobResult.getStatus().getCode())) {
            jobResult.setStatus(JobStatus.CANCELLED);
            this.saveJobResult(jobResult);
            try {
                this.schedulingService.interrupt(jobResult.getJobName(), jobResult.getJobGroup());
            }
            catch (SchedulerException e) {
                throw new ServiceException("Unable to interrupt the job during cancel", e);
            }
        }
    }

    @Override
    public void errActiveJob(EntityKey key) throws ServiceException {
        JobResult jobResult = this.getJobResult(key);
        if (JobStatus.IN_PROCESS.getCode().equals(jobResult.getStatus().getCode())) {
            jobResult.setStatus(JobStatus.ERROR);
            this.saveJobResult(jobResult);
        }
    }

    public SchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public void setSchedulingService(SchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }
}

