/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryDetail;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDataQueriesProcess
extends AbstractDataQueryIncrementalProcess {
    private List dataQueries;

    @Override
    protected final void executeProcess(DataProcessExecutionContext context) throws Exception {
        List acquiredData = null;
        DataQueryProcessExecutionContext queryContext = (DataQueryProcessExecutionContext)context;
        Iterator itr = this.dataQueries.iterator();
        DataQueryDetail query = null;
        block0: while (itr.hasNext()) {
            query = (DataQueryDetail)((Object)itr.next());
            queryContext.setCurrentDataQuery(query);
            queryContext.setCurrentRecord(0);
            this.prepareDataQueryDetail(queryContext, query);
            while (!this.isInterrupted(context)) {
                if (query.isIncremental()) {
                    acquiredData = this.acquireData(queryContext);
                    if (acquiredData == null || acquiredData.isEmpty()) continue block0;
                    this.processQueryData(queryContext, query, acquiredData);
                    continue;
                }
                acquiredData = this.executeQuery(queryContext);
                this.processQueryData(queryContext, query, acquiredData);
                continue block0;
            }
        }
        if (!this.isHandleEachFetchSeparately()) {
            this.handleDataProcessCompleted(context);
        }
    }

    protected void prepareDataQueryDetail(DataQueryProcessExecutionContext context, DataQueryDetail query) {
    }

    private void processQueryData(DataQueryProcessExecutionContext context, DataQueryDetail query, List acquiredData) throws Exception {
        if (query.getProcessor() != null) {
            query.getProcessor().processAcquiredData(context, acquiredData);
        } else {
            this.processData(context, acquiredData);
        }
        if (this.isHandleEachFetchSeparately()) {
            this.handleDataProcessCompleted(context);
        }
    }

    @Override
    protected void validateQuery() {
        if (this.dataQueries == null || this.dataQueries.isEmpty()) {
            throw new InvalidConfigurationException("dataQueries must contain at least one query");
        }
    }

    public List getDataQueries() {
        return this.dataQueries;
    }

    public void setDataQueries(List dataQueries) {
        this.dataQueries = dataQueries;
    }
}

