/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.BatchProcessService;
import gov.va.med.fw.batchprocess.DataProcessWorkerInput;
import gov.va.med.fw.batchprocess.JobResultData;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatisticsHandler;
import gov.va.med.fw.batchprocess.model.JobConfig;
import gov.va.med.fw.batchprocess.model.JobResult;
import gov.va.med.fw.batchprocess.model.JobStatus;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.service.AbstractComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public abstract class AbstractDataProcessWorker
extends AbstractComponent {
    private ProcessStatisticsHandler processStatisticsHandler;
    private BatchProcessService batchProcessService;

    public final void process(DataProcessWorkerInput in) {
        block5: {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Processing data for process: " + in.getProcessName() + " with a payload count of: " + in.getPayloadCount() + " and a total count of: " + in.getTotalCount()));
            }
            try {
                JobResult jobResult;
                EntityKey jobResultKey = null;
                if (in.getId() != null) {
                    jobResultKey = EntityKeyFactory.createEntityKey(in.getId().toString(), JobResult.class);
                }
                if (this.shouldProcessData(in, jobResult = this.batchProcessService.getJobResult(jobResultKey))) {
                    ProcessStatistics workerStats = this.processData(in.getPayload());
                    workerStats.setProcessName(in.getProcessName());
                    JobResultData data = this.batchProcessService.saveAndOverlayJobResult(jobResultKey, workerStats, in.getTotalCount());
                    this.processStatistics(data);
                }
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block5;
                this.logger.error((Object)"Failed processing data", (Throwable)e);
            }
        }
    }

    protected final void processStatistics(JobResultData data) throws Exception {
        ProcessStatistics jobStats = data.getProcessStatistics();
        JobResult jobResult = data.getJobResult();
        if (JobStatus.CANCELLED.equals(jobResult.getStatus())) {
            jobStats.setWasInterrupted(true);
        }
        if (!JobStatus.IN_PROCESS.equals(jobResult.getStatus())) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("ProcessStatistics [" + jobStats + "]"));
            }
            if (this.processStatisticsHandler != null) {
                JobConfig config = this.batchProcessService.getJobConfig(jobResult.getJobName(), jobResult.getJobGroup());
                if (config != null && StringUtils.isNotBlank((String)config.getEmailDistributionList())) {
                    this.processStatisticsHandler.processStatisticsWithDynamicRecipients(jobStats, config.getEmailsAsList());
                } else {
                    this.processStatisticsHandler.processStatistics(jobStats);
                }
            }
        }
    }

    protected boolean shouldProcessData(DataProcessWorkerInput in, JobResult currentJobResult) {
        return JobStatus.IN_PROCESS.getCode().equals(currentJobResult.getStatus().getCode());
    }

    public abstract ProcessStatistics processData(Object var1) throws Exception;

    public ProcessStatisticsHandler getProcessStatisticsHandler() {
        return this.processStatisticsHandler;
    }

    public void setProcessStatisticsHandler(ProcessStatisticsHandler processStatisticsHandler) {
        this.processStatisticsHandler = processStatisticsHandler;
    }

    public BatchProcessService getBatchProcessService() {
        return this.batchProcessService;
    }

    public void setBatchProcessService(BatchProcessService batchProcessService) {
        this.batchProcessService = batchProcessService;
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.batchProcessService, (String)"batchProcessService is required");
    }
}

