/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.util;

import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class StringAndCollectionTools {
    public static final int getListSize(List aList) {
        if (aList != null) {
            return aList.size();
        }
        return 0;
    }

    public static final int getSetSize(Set aSet) {
        if (aSet != null) {
            return aSet.size();
        }
        return 0;
    }

    public static final Object getListElement(List aList, int anIndex) {
        if (aList != null && aList.size() > anIndex && anIndex >= 0) {
            return aList.get(anIndex);
        }
        return null;
    }

    public static String getNonNullString(String aString) {
        if (aString == null) {
            aString = "";
        }
        return aString;
    }

    public static String getTrimmedString(String aString) {
        aString = aString == null ? "" : aString.trim();
        return aString;
    }

    public static String[] split(String src, String delim) {
        return StringAndCollectionTools.list2Array(src, delim);
    }

    public static String[] splitIncludeNulls(String src, String delim) {
        return StringAndCollectionTools.list2Array(src, delim, true);
    }

    public static String substitute(String src, String toReplace, String replaceWith) {
        if (!toReplace.equals(replaceWith) && toReplace.length() != 0) {
            int pos = 0;
            int loc = 0;
            int len = replaceWith.length();
            while ((pos = src.indexOf(toReplace, loc)) >= 0) {
                src = String.valueOf(src.substring(0, pos)) + replaceWith + src.substring(pos + toReplace.length());
                loc = pos + len;
            }
        }
        return src;
    }

    public static String substituteOnce(String src, String toReplace, String replaceWith) {
        int pos = 0;
        if (!toReplace.equals(replaceWith)) {
            while ((pos = src.indexOf(toReplace, pos)) >= 0) {
                src = String.valueOf(src.substring(0, pos)) + replaceWith + src.substring(pos + toReplace.length());
                pos += replaceWith.length();
            }
        }
        return src;
    }

    public static String substituteIgnoreCase(String src, String replaceThis, String replaceWith) {
        String replaceThisLowerCase = replaceThis.toLowerCase();
        String srcLowerCase = src.toLowerCase();
        if (replaceThis.length() != 0) {
            int pos = 0;
            int loc = 0;
            int len = replaceWith.length();
            while ((pos = srcLowerCase.indexOf(replaceThisLowerCase, loc)) >= 0) {
                src = String.valueOf(src.substring(0, pos)) + replaceWith + src.substring(pos + replaceThis.length());
                srcLowerCase = String.valueOf(srcLowerCase.substring(0, pos)) + replaceWith + srcLowerCase.substring(pos + replaceThis.length());
                loc = pos + len;
            }
        }
        return src;
    }

    public static String insert(String src, String toInsert, int pos) {
        src = pos > 0 ? (pos >= src.length() ? String.valueOf(src) + toInsert : String.valueOf(src.substring(0, pos)) + toInsert + src.substring(pos)) : String.valueOf(toInsert) + src;
        return src;
    }

    public static String insertBetween(String src, String toInsertBetween, String toInsert) {
        if (!toInsertBetween.equals(toInsert)) {
            int pos;
            while ((pos = src.indexOf(String.valueOf(toInsertBetween) + toInsertBetween)) >= 0) {
                src = StringAndCollectionTools.insert(src, toInsert, pos + toInsertBetween.length());
            }
        }
        return src;
    }

    public static String subtract(String toProcess, String chars) {
        StringBuffer sb = new StringBuffer(512);
        StringTokenizer st = new StringTokenizer(toProcess, chars);
        while (st.hasMoreElements()) {
            sb.append(st.nextToken());
        }
        return sb.toString();
    }

    public static String subtractMask(String toProcess, String mask, String maskChars) {
        String rc = null;
        if (toProcess != null) {
            rc = new String(toProcess);
            if (mask != null && maskChars != null && (mask = StringAndCollectionTools.subtract(mask, maskChars)) != null && (toProcess = StringAndCollectionTools.subtract(toProcess, mask)) != null) {
                rc = toProcess;
            }
        }
        return rc;
    }

    public static String[] list2Array(String list, String delim) {
        return StringAndCollectionTools.list2Array(list, delim, false);
    }

    public static String[] list2Array(String list, String delim, boolean includeNulls) {
        String[] array = null;
        int startPos = 0;
        int endPos = 0;
        int len = delim.length();
        int ndx = 0;
        if (list == null) {
            return null;
        }
        while ((endPos = list.indexOf(delim, startPos)) >= 0) {
            ++ndx;
            if (!includeNulls && endPos == startPos) {
                --ndx;
            }
            startPos = endPos + len;
        }
        if (list.length() > 0) {
            if (list.substring(list.length() - 1).equals(delim)) {
                if (includeNulls) {
                    ++ndx;
                }
            } else if (startPos < list.length()) {
                ++ndx;
            }
        }
        if (ndx <= 0) {
            array = new String[]{list};
            return array;
        }
        array = new String[ndx];
        startPos = 0;
        endPos = 0;
        ndx = 0;
        while ((endPos = list.indexOf(delim, startPos)) >= 0) {
            if (endPos == startPos) {
                if (includeNulls) {
                    array[ndx++] = list.substring(startPos, endPos);
                }
            } else {
                array[ndx++] = list.substring(startPos, endPos);
            }
            startPos = endPos + len;
        }
        if (startPos == list.length()) {
            if (includeNulls) {
                array[ndx] = "";
            }
        } else if (startPos < list.length()) {
            array[ndx++] = list.substring(startPos, list.length());
        }
        return array;
    }

    public static String array2DelimitedList(String[] array, String delim) {
        StringBuffer rc = null;
        if (array.length == 0) {
            return null;
        }
        if (array.length > 0) {
            rc = new StringBuffer("");
            int i = 0;
            while (i < array.length) {
                if (i > 0) {
                    rc.append(delim);
                }
                rc.append(array[i]);
                ++i;
            }
        }
        return rc.toString();
    }

    public static final boolean containedInArray(String srch, String[] array) {
        int i = 0;
        while (i < array.length) {
            if (srch.equals(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final String containedInArrayStart(String srch, String[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i].toLowerCase().startsWith(srch.toLowerCase())) {
                return array[i];
            }
            ++i;
        }
        return null;
    }

    public static final String padFront(String in, String pad, int len) {
        if (in.length() > len) {
            return in.substring(in.length() - len);
        }
        int padLen = len - in.length();
        StringBuffer sbout = new StringBuffer(len);
        int ndx = 0;
        while (ndx < padLen) {
            sbout = sbout.append(pad);
            ++ndx;
        }
        sbout.append(in);
        return sbout.toString();
    }

    public static final String padBack(String in, String pad, int len) {
        if (in.length() > len) {
            return in.substring(0, len);
        }
        StringBuffer sbout = new StringBuffer(in);
        while (sbout.length() < len) {
            sbout = sbout.append(pad);
        }
        String out = sbout.toString();
        return out.substring(0, len);
    }

    public static final boolean isNumeric(String value) {
        if (value.length() < 1) {
            return false;
        }
        char[] array = value.toCharArray();
        int i = array.length - 1;
        while (i > -1) {
            if (!Character.isDigit(array[i]) || array[i] == ' ') {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean isEmpty(String value) {
        boolean empty = false;
        if (value == null || value.trim().length() == 0) {
            empty = true;
        }
        return empty;
    }

    public static String trimEnd(String toProcess) {
        int pos = -1;
        char[] car = toProcess.toCharArray();
        pos = car.length - 1;
        while (pos >= 0) {
            if (car[pos] != ' ' && car[pos] != '\t' && car[pos] != '\n') break;
            --pos;
        }
        if (pos >= 0) {
            toProcess = toProcess.substring(0, pos + 1);
        }
        return toProcess;
    }

    public static String removeNewLines(String s, boolean insertSpace) {
        String[] lines;
        if (s.length() > 0 && (lines = StringAndCollectionTools.splitIncludeNulls(s, "\n")).length >= 2) {
            String t = "";
            int i = 0;
            while (i < lines.length) {
                t = lines[i].length() < 1 ? t.concat("\n\n") : (insertSpace ? t.concat(String.valueOf(lines[i]) + " ") : t.concat(lines[i]));
                ++i;
            }
            s = t;
        }
        return s;
    }

    public static boolean containsAny(String src, String chars) {
        char[] c = chars.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (src.indexOf(c[i]) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int stringToInt(String stringValue, int defaultValue) {
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int stringToInt(String stringValue) {
        return StringAndCollectionTools.stringToInt(stringValue, 0);
    }

    public static long stringToLong(String stringValue, long defaultValue) {
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(stringValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long stringToLong(String stringValue) {
        return StringAndCollectionTools.stringToLong(stringValue, 0L);
    }
}

