/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.util;

import gov.va.med.person.idmgmt.IPersonIdentity;
import gov.va.med.person.idmgmt.common.IPersonName;
import gov.va.med.person.idmgmt.common.ISSN;
import gov.va.med.person.idmgmt.util.NameStandardization;
import gov.va.med.term.access.NameType;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class PersonNameUtil
implements Serializable {
    private static final Logger logger = Logger.getLogger(PersonNameUtil.class);
    private static final long serialVersionUID = 1L;
    private String firstName;
    private String lastName;
    private String middleName;
    private String prefix;
    private String suffix;
    private String nameTypeString;
    private NameType nameTypeObject;
    private IPersonIdentity personIdentity;
    private int nameIndex;
    private IPersonName personName;
    private ISSN ssn = null;

    public PersonNameUtil() {
    }

    public PersonNameUtil(IPersonIdentity personIdentity, int nameIndex) {
        this.personIdentity = personIdentity;
        this.nameIndex = nameIndex;
        this.standardize();
    }

    public PersonNameUtil(IPersonName personName) {
        this.personName = personName;
        this.standardize();
    }

    public String getFirstName() {
        if (this.firstName == null) {
            if (this.personIdentity != null) {
                this.firstName = this.personIdentity.getFirstName(this.nameIndex);
            } else if (this.personName != null) {
                this.firstName = this.personName.getFirstName();
            }
        }
        return this.firstName;
    }

    public void setFirstName(String aFirstName) {
        this.firstName = aFirstName;
    }

    public String getLastName() {
        if (this.lastName == null) {
            if (this.personIdentity != null) {
                this.lastName = this.personIdentity.getLastName(this.nameIndex);
            } else if (this.personName != null) {
                this.lastName = this.personName.getLastName();
            }
        }
        return this.lastName;
    }

    public void setLastName(String aLastName) {
        this.lastName = aLastName;
    }

    public String getMiddleName() {
        if (this.middleName == null) {
            if (this.personIdentity != null) {
                this.middleName = this.personIdentity.getMiddleName(this.nameIndex);
            } else if (this.personName != null) {
                this.middleName = this.personName.getMiddleName();
            }
        }
        return this.middleName;
    }

    public void setMiddleName(String aMiddleName) {
        this.middleName = aMiddleName;
    }

    public String getPrefix() {
        if (this.prefix == null) {
            if (this.personIdentity != null) {
                this.prefix = this.personIdentity.getPrefix(this.nameIndex);
            } else if (this.personName != null) {
                this.prefix = this.personName.getNamePrefix();
            }
        }
        return this.prefix;
    }

    public void setPrefix(String aPrefix) {
        this.prefix = aPrefix;
    }

    public String getSuffix() {
        if (this.suffix == null) {
            if (this.personIdentity != null) {
                this.suffix = this.personIdentity.getSuffix(this.nameIndex);
            } else if (this.personName != null) {
                this.suffix = this.personName.getNameSuffix();
            }
        }
        return this.suffix;
    }

    public void setSuffix(String aSuffix) {
        this.suffix = aSuffix;
    }

    public NameType getNameTypeObject() {
        if (this.nameTypeObject == null) {
            if (this.personIdentity != null) {
                this.nameTypeObject = this.getNameType(this.personIdentity.getNameType(this.nameIndex));
            } else if (this.personName != null) {
                this.nameTypeObject = this.personName.getNameType();
            }
        }
        if (this.nameTypeObject == null && this.nameTypeString != null) {
            this.nameTypeObject = NameType.factory.obtainByCode(this.nameTypeString);
        }
        return this.nameTypeObject;
    }

    public void setNameTypeObject(NameType nameTypeObject) {
        this.nameTypeObject = nameTypeObject;
    }

    public String getNameTypeString() {
        if (this.nameTypeString == null) {
            if (this.personIdentity != null) {
                this.nameTypeString = this.personIdentity.getNameType(this.nameIndex);
            } else if (this.personName != null) {
                this.nameTypeString = this.personName.getNameType().getCode();
            }
        }
        if (this.nameTypeString == null && this.getNameTypeObject() != null) {
            this.nameTypeString = this.nameTypeObject.getCode();
        }
        return this.nameTypeString;
    }

    public void setNameTypeString(String aNameType) {
        this.nameTypeString = aNameType;
    }

    public IPersonIdentity getEventPersonID() {
        return this.personIdentity;
    }

    public Timestamp getEventTimestamp() {
        if (this.personIdentity != null) {
            return this.personIdentity.getAuditEventTimestamp();
        }
        return null;
    }

    public void standardize() {
        NameStandardization stdName = new NameStandardization(this.getLastName(), this.getFirstName(), this.getMiddleName(), this.getSuffix());
        this.lastName = stdName.getLastName();
        this.firstName = stdName.getGivenName();
        this.middleName = stdName.getMidName();
        this.suffix = stdName.getSuffix();
    }

    private NameType getNameType(String nameTypeCode) {
        if (nameTypeCode == null) {
            return null;
        }
        return NameType.factory.obtainByCode(nameTypeCode);
    }

    public IPersonName getPersonName() {
        return this.personName;
    }

    public ISSN getAliasSSN() {
        return this.ssn;
    }

    public void setAliasSSN(ISSN ssn) {
        this.ssn = ssn;
    }

    public boolean equals(Object o) {
        if (o instanceof IPersonName) {
            IPersonName otherName = (IPersonName)o;
            if (this.isEqual(this.getLastName(), otherName.getLastName()) && this.isEqual(this.getFirstName(), otherName.getFirstName()) && this.isEqual(this.getMiddleName(), otherName.getMiddleName()) && this.isEqual(this.getPrefix(), otherName.getNamePrefix()) && this.isEqual(this.getSuffix(), otherName.getNameSuffix()) && this.isEqual(this.getNameTypeString(), otherName.getNameType() == null ? null : otherName.getNameType().getCode())) {
                return true;
            }
        } else if (o instanceof PersonNameUtil) {
            PersonNameUtil otherName = (PersonNameUtil)o;
            if (this.isEqual(this.getLastName(), otherName.getLastName()) && this.isEqual(this.getFirstName(), otherName.getFirstName()) && this.isEqual(this.getMiddleName(), otherName.getMiddleName()) && this.isEqual(this.getPrefix(), otherName.getPrefix()) && this.isEqual(this.getSuffix(), otherName.getSuffix()) && this.isEqual(this.getNameTypeString(), otherName.getNameTypeString())) {
                return true;
            }
        } else {
            logger.debug((Object)"Object passed must be of type PersonName or PersonNameUtil for comparison with PersonNameUtil");
            logger.debug((Object)("Object was type: " + (o == null ? "null" : o.getClass().getName())));
        }
        return false;
    }

    private boolean isEqual(Object a, Object b) {
        if (this.isNull(a) || this.isNull(b)) {
            if (this.isNull(a) && ("\"\"".equals(b) || "NOTSENT".equals(b))) {
                return true;
            }
            if (a != b) {
                return false;
            }
        } else if (!a.equals(b)) {
            return false;
        }
        return true;
    }

    private boolean isNull(Object o) {
        return o == null;
    }
}

