/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class PSIMSettings {
    private static Logger logger = Logger.getLogger(PSIMSettings.class);
    private static PSIMSettings instance;
    private HashMap lookupMap;
    private static final String PROPERTY_SEPARATOR = "/";
    private Properties properties;
    public static final String DEFAULT_PROP_FILENAME = "/PSIM.properties";
    public static final String DEFAULT_IDHUB_PROP_FILENAME = "/idhub.properties";
    private String loadDateTime;
    private String loadDateTimeHistory = "";
    private String configFileLocation = "";

    public static synchronized PSIMSettings getInstance() {
        if (instance == null) {
            instance = new PSIMSettings();
        }
        return instance;
    }

    public void forceReload() {
        this.loadPropertyInformation();
    }

    public PSIMSettings() {
        this.loadPropertyInformation();
    }

    public String getLoadDateTime() {
        return this.loadDateTime;
    }

    public String getLoadDateTimeHistory() {
        return this.loadDateTimeHistory;
    }

    public String getConfigFileLocation() {
        return this.configFileLocation;
    }

    public Properties getPropertiesObject() {
        return this.properties;
    }

    public String getMyCaipConfigLocation() {
        return System.getProperty("myCaipConfig.xml", "Can't location myCaipConfig.xml setting location");
    }

    public Properties getMyCaipConfigProperties() {
        Properties caipProp = new Properties();
        try {
            String caipLocation = System.getProperty("myCaipConfig.xml", "Can't location myCaipConfig.xml setting location");
            InputStream propertyStream = this.getClass().getResourceAsStream(caipLocation);
            if (propertyStream != null) {
                caipProp.load(propertyStream);
            } else {
                logger.debug((Object)("COULD NOT FIND " + this.configFileLocation));
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return caipProp;
    }

    private void loadPropertyInformation() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.loadDateTime = sdf.format(new Date());
        this.loadDateTimeHistory = String.valueOf(this.loadDateTimeHistory) + ", " + this.loadDateTime;
        System.out.println("Loading PSIM Settings...  " + this.loadDateTimeHistory);
        String[] propertyFiles = new String[]{System.getProperty("psim.configuration", DEFAULT_PROP_FILENAME), System.getProperty("idhub.configuration", DEFAULT_IDHUB_PROP_FILENAME)};
        this.properties = new Properties();
        int i = 0;
        while (i < propertyFiles.length) {
            String configFileLocation = propertyFiles[i];
            this.configFileLocation = String.valueOf(this.configFileLocation) + ", " + configFileLocation;
            logger.debug((Object)("[PSIM EXCEPTIONS] ConfigFile: " + configFileLocation));
            try {
                this.properties.load(new FileInputStream(configFileLocation));
            }
            catch (IOException ioe) {
                try {
                    InputStream propertyStream = this.getClass().getResourceAsStream(configFileLocation);
                    if (propertyStream != null) {
                        this.properties.load(propertyStream);
                    } else {
                        logger.debug((Object)("COULD NOT FIND " + configFileLocation));
                    }
                }
                catch (IOException dioe) {
                    dioe.printStackTrace();
                }
            }
            ++i;
        }
        this.loadLookupMap(this.properties);
    }

    public Properties getPropertiesFor(Class nameSpace) {
        Properties classProperties = new Properties();
        Iterator keys = this.lookupMap.keySet().iterator();
        String suffixKey = "";
        String fullKey = "";
        int ipos = 0;
        while (keys.hasNext()) {
            fullKey = (String)keys.next();
            if (!fullKey.startsWith(nameSpace.getName())) continue;
            ipos = fullKey.indexOf(PROPERTY_SEPARATOR);
            suffixKey = fullKey.substring(ipos + 1);
            classProperties.put(suffixKey, this.lookupMap.get(fullKey));
        }
        return classProperties;
    }

    private void loadLookupMap(Properties prop) {
        if (this.lookupMap == null) {
            this.lookupMap = new HashMap();
        }
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.lookupMap.put(key, prop.getProperty(key));
        }
    }

    public String getValue(Class nameSpace, String key) {
        return this.getValue(nameSpace, key, null);
    }

    public String getValue(Class nameSpace, String key, String defaultValue) {
        return this.getValue(String.valueOf(nameSpace.getName()) + PROPERTY_SEPARATOR + key, defaultValue);
    }

    public String getValue(String propKey, String defaultValue) {
        if (this.lookupMap != null && this.lookupMap.containsKey(propKey)) {
            return (String)this.lookupMap.get(propKey);
        }
        return defaultValue;
    }

    public HashMap getPropertyMap() {
        return this.lookupMap;
    }

    public void setProperty(String propKey, String propVal) {
        try {
            this.lookupMap.put(propKey, propVal);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public boolean isLocationExcludedFromHub(String assigningLocation) {
        String excludeList = PSIMSettings.getInstance().getValue(PSIMSettings.class, "locationExcludeList");
        return excludeList != null && excludeList.indexOf(assigningLocation) != -1;
    }
}

