/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.util;

import gov.va.med.person.demographics.common.type.IAddressChangeSrcType;
import gov.va.med.person.demographics.common.type.IAddressInvalidType;
import gov.va.med.person.demographics.common.type.IBenefitsCoordinationType;
import gov.va.med.person.demographics.common.type.IConfidentialAddrType;
import gov.va.med.person.demographics.common.type.IDeathNotificationSrcType;
import gov.va.med.person.demographics.common.type.IElectronicPlanType;
import gov.va.med.person.demographics.common.type.IEmailChangeSourceType;
import gov.va.med.person.demographics.common.type.IEmailType;
import gov.va.med.person.demographics.common.type.IEmploymentStatusType;
import gov.va.med.person.demographics.common.type.IInsuranceHolderType;
import gov.va.med.person.demographics.common.type.IMethodCollType;
import gov.va.med.person.demographics.common.type.IPersonContactType;
import gov.va.med.person.demographics.common.type.IPhoneChangeSourceType;
import gov.va.med.person.demographics.common.type.IPhoneType;
import gov.va.med.person.demographics.common.type.IPlanCategoryType;
import gov.va.med.person.idmgmt.common.IChangeType;
import gov.va.med.person.idmgmt.db.hb.ChangeType;
import gov.va.med.person.idmgmt.db.hb.VerificationLevel;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.term.access.AddressType;
import gov.va.med.term.access.Country;
import gov.va.med.term.access.County;
import gov.va.med.term.access.Ethnicity;
import gov.va.med.term.access.Gender;
import gov.va.med.term.access.InsurancePlanType;
import gov.va.med.term.access.InsuranceReportSource;
import gov.va.med.term.access.MaritalStatus;
import gov.va.med.term.access.PersonClass;
import gov.va.med.term.access.ProgramOfStudy;
import gov.va.med.term.access.Race;
import gov.va.med.term.access.RelationshipToVeteranInsurance;
import gov.va.med.term.access.Religion;
import gov.va.med.term.access.SSAVerificationCode;
import gov.va.med.term.access.SSNChangeSource;
import gov.va.med.term.access.SSNVerificationStatus;
import gov.va.med.term.access.ServiceBranch;
import gov.va.med.term.access.State;
import gov.va.med.term.access.criteria.Criteria;
import org.apache.log4j.Logger;

public final class ObtainUtil {
    private static final Logger logger = Logger.getLogger(ObtainUtil.class);
    private static final String NAME_TXT = "name";
    private static final Country COUNTRY_USA;

    static {
        Country country = null;
        COUNTRY_USA = country = Country.factory.obtainByAlpha3Code("USA");
    }

    private ObtainUtil() {
    }

    public static Country obtainCountry(String country) {
        if (country == null) {
            return null;
        }
        Country cntry = null;
        if (country.equalsIgnoreCase("USA")) {
            cntry = COUNTRY_USA;
        }
        if (cntry == null) {
            cntry = ObtainUtil.obtainCountryByAlpha3(country);
        }
        if (cntry == null) {
            cntry = ObtainUtil.obtainCountryByName(country);
        }
        if (cntry == null) {
            try {
                cntry = Country.factory.obtainFromKeyString(country);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.ObtainCountry (by key String) Exception: ", (Throwable)ne);
            }
        }
        return cntry;
    }

    public static Country obtainCountryUSA() {
        return COUNTRY_USA;
    }

    public static Country obtainCountryByName(String countryName) {
        Criteria.EqualIgnoreCase criteria;
        Country[] countries;
        Country country = null;
        if (countryName != null && (countries = Country.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase(NAME_TXT, countryName)))).length != 0) {
            country = countries[0];
            if (countries.length > 1) {
                logger.warn((Object)("Multiple SDS Country objects returned for '" + countryName + "'"));
            }
        }
        return country;
    }

    public static Country obtainCountryByAlpha3(String countryAlpha3) {
        Country country = null;
        if (countryAlpha3 != null) {
            country = Country.factory.obtainByAlpha3Code(countryAlpha3);
        }
        return country;
    }

    public static County obtainCounty(String country, String state, String county) {
        Country c = ObtainUtil.obtainCountry(country);
        State s = ObtainUtil.obtainState(c, state);
        return ObtainUtil.obtainCounty(s, county);
    }

    public static County obtainCounty(String state, String county) {
        State st = ObtainUtil.obtainStateByPostalNameOnly(state);
        if (st == null) {
            st = ObtainUtil.obtainState("USA", state);
        }
        return ObtainUtil.obtainCounty(st, county);
    }

    public static County obtainCounty(State state, String county) {
        if (county == null || state == null) {
            return null;
        }
        County cnty = null;
        try {
            cnty = ObtainUtil.obtainCountyByName(state, county);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.ObtainCounty (by Name) Exception: ", (Throwable)e);
        }
        if (cnty == null) {
            try {
                cnty = County.factory.obtainFromKeyString(county);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.ObtainCounty (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return cnty;
    }

    public static County obtainCountyByName(State state, String countyName) {
        if (countyName == null || state == null) {
            return null;
        }
        return County.factory.obtainByName(state, countyName);
    }

    public static Gender obtainGender(String gender) {
        if (gender == null) {
            return null;
        }
        Gender gndr = null;
        try {
            gndr = ObtainUtil.obtainGenderByCode(gender);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainGender (by Code) Exception: ", (Throwable)e);
        }
        if (gndr == null) {
            try {
                gndr = ObtainUtil.obtainGenderByName(gender);
            }
            catch (Exception e) {
                logger.error((Object)" ObtainUtil.obtainGender (by Name) Exception: ", (Throwable)e);
            }
        }
        if (gndr == null) {
            try {
                gndr = Gender.factory.obtainFromKeyString(gender);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainGender (by KeyString) Exception: ", (Throwable)ne);
            }
            catch (Exception e) {
                logger.error((Object)" ObtainUtil.obtainGender (by KeyString) Exception: ", (Throwable)e);
            }
        }
        return gndr;
    }

    public static Gender obtainGenderByCode(String genderCode) {
        Gender gender = null;
        if (genderCode != null) {
            gender = Gender.factory.obtainByCode(genderCode);
        }
        return gender;
    }

    public static Gender obtainGenderByName(String genderName) {
        Criteria.EqualIgnoreCase criteria;
        Gender[] genders;
        Gender gender = null;
        if (genderName != null && (genders = Gender.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase(NAME_TXT, genderName)))).length != 0) {
            gender = genders[0];
            if (genders.length > 1) {
                logger.warn((Object)("Multiple SDS Genders objects returned for '" + genderName + "'"));
            }
        }
        return gender;
    }

    public static InsurancePlanType obtainInsurancePlanType(String planType) {
        if (planType == null) {
            return null;
        }
        InsurancePlanType ipt = null;
        try {
            ipt = ObtainUtil.obtainInsurancePlanTypeByName(planType);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainInsurancePlanType (by Name) Exception: ", (Throwable)e);
        }
        if (ipt == null) {
            try {
                ipt = InsurancePlanType.factory.obtainFromKeyString(planType);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainInsurancePlanType (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return ipt;
    }

    public static InsurancePlanType obtainInsurancePlanTypeByName(String planTypeName) {
        Criteria.EqualIgnoreCase criteria;
        InsurancePlanType[] types;
        InsurancePlanType ipt = null;
        if (planTypeName != null && (types = InsurancePlanType.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase(NAME_TXT, planTypeName)))).length != 0) {
            ipt = types[0];
            if (types.length > 1) {
                logger.warn((Object)("Multiple SDS InsurancePlanType objects returned for '" + planTypeName + "'"));
            }
        }
        return ipt;
    }

    public static RelationshipToVeteranInsurance obtainRelationshipToVeteran(String rel) {
        if (rel == null) {
            return null;
        }
        RelationshipToVeteranInsurance relToVet = null;
        try {
            relToVet = ObtainUtil.obtainRelationshipToVeteranByName(rel);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainRelationshipToVeteran (by Name) Exception: ", (Throwable)e);
        }
        if (relToVet == null) {
            try {
                relToVet = RelationshipToVeteranInsurance.factory.obtainFromKeyString(rel);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainRelationshipToVeteran (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return relToVet;
    }

    public static RelationshipToVeteranInsurance obtainRelationshipToVeteranByName(String relName) {
        Criteria.EqualIgnoreCase criteria;
        RelationshipToVeteranInsurance[] rels;
        RelationshipToVeteranInsurance rvi = null;
        if (relName != null && (rels = RelationshipToVeteranInsurance.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase(NAME_TXT, relName)))).length != 0) {
            rvi = rels[0];
            if (rels.length > 1) {
                logger.warn((Object)("Multiple SDS RelationshipToVeteranInsurance objects returned for '" + relName + "'"));
            }
        }
        return rvi;
    }

    public static InsuranceReportSource obtainInsuranceReportSource(String source) {
        if (source == null) {
            return null;
        }
        InsuranceReportSource irs = null;
        try {
            irs = ObtainUtil.obtainInsuranceReportSourceByName(source);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainInsuranceReportSource (by Name) Exception: ", (Throwable)e);
        }
        if (irs == null) {
            try {
                irs = InsuranceReportSource.factory.obtainFromKeyString(source);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainInsuranceReportSource (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return irs;
    }

    public static InsuranceReportSource obtainInsuranceReportSourceByName(String srcName) {
        Criteria.EqualIgnoreCase criteria;
        InsuranceReportSource[] rels;
        InsuranceReportSource irs = null;
        if (srcName != null && (rels = InsuranceReportSource.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase(NAME_TXT, srcName)))).length != 0) {
            irs = rels[0];
            if (rels.length > 1) {
                logger.warn((Object)("Multiple SDS InsuranceReportSource objects returned for '" + srcName + "'"));
            }
        }
        return irs;
    }

    public static ServiceBranch obtainServiceBranch(String branch) {
        if (branch == null) {
            return null;
        }
        ServiceBranch servBr = null;
        try {
            servBr = ObtainUtil.obtainServiceBranchByName(branch);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainServiceBranch (by Name) Exception: ", (Throwable)e);
        }
        if (servBr == null) {
            try {
                servBr = ServiceBranch.factory.obtainFromKeyString(branch);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainServiceBranch (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return servBr;
    }

    public static ServiceBranch obtainServiceBranchByName(String branchName) {
        Criteria.EqualIgnoreCase criteria;
        ServiceBranch[] branches;
        ServiceBranch servBr = null;
        if (branchName != null && (branches = ServiceBranch.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase(NAME_TXT, branchName)))).length != 0) {
            servBr = branches[0];
            if (branches.length > 1) {
                logger.warn((Object)("Multiple SDS ServiceBranch objects returned for '" + branchName + "'"));
            }
        }
        return servBr;
    }

    public static State obtainState(String country, String state) {
        Country cr = ObtainUtil.obtainCountry(country);
        return ObtainUtil.obtainState(cr, state);
    }

    public static State obtainState(Country country, String state) {
        if (state == null) {
            return null;
        }
        if (country == null) {
            country = COUNTRY_USA;
        }
        State st = null;
        try {
            st = ObtainUtil.obtainStateByPostalName(country, state);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.ObtainState (by postalName) Exception: ", (Throwable)e);
        }
        if (st == null) {
            try {
                st = ObtainUtil.obtainStateByName(country, state);
            }
            catch (Exception e) {
                logger.error((Object)" ObtainUtil.ObtainState (byName) Exception: ", (Throwable)e);
            }
        }
        if (st == null) {
            try {
                st = State.factory.obtainFromKeyString(state);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.ObtainState (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return st;
    }

    public static State obtainStateByPostalName(Country country, String postalName) {
        State state = null;
        if (postalName != null) {
            if (country == null) {
                country = COUNTRY_USA;
            }
            state = State.factory.obtainByPostalName(country, postalName);
        }
        return state;
    }

    public static State obtainStateByPostalName(String country, String postalName) {
        Country cr = ObtainUtil.obtainCountry(country);
        return ObtainUtil.obtainStateByPostalName(cr, postalName);
    }

    public static State obtainStateByName(Country country, String name) {
        State state = null;
        if (name != null) {
            if (country == null) {
                country = COUNTRY_USA;
            }
            state = State.factory.obtainByName(country, name);
        }
        return state;
    }

    public static State obtainStateByName(String country, String name) {
        Country cr = ObtainUtil.obtainCountry(country);
        return ObtainUtil.obtainStateByName(cr, name);
    }

    public static State obtainStateByPostalNameOnly(String postalName) {
        Criteria.EqualIgnoreCase criteria;
        State[] states;
        State st = null;
        if (postalName != null && (states = State.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase("postalName", postalName)))).length != 0) {
            st = states[0];
            if (states.length > 1) {
                logger.warn((Object)("Multiple SDS State objects returned for '" + postalName + "'"));
            }
        }
        return st;
    }

    public static ProgramOfStudy obtainProgramOfStudy(String programOfStudy) {
        if (programOfStudy == null) {
            return null;
        }
        ProgramOfStudy pos = null;
        try {
            pos = ObtainUtil.obtainProgramOfStudyByCode(programOfStudy);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainProgramOfStudy (by code) Exception: ", (Throwable)e);
        }
        if (pos == null) {
            try {
                pos = ObtainUtil.obtainProgramOfStudyByName(programOfStudy);
            }
            catch (Exception e) {
                logger.error((Object)" ObtainUtil.obtainProgramOfStudy (by name) Exception: ", (Throwable)e);
            }
        }
        if (pos == null) {
            try {
                pos = ProgramOfStudy.factory.obtainFromKeyString(programOfStudy);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainProgramOfStudy (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return pos;
    }

    public static ProgramOfStudy obtainProgramOfStudyByName(String programName) {
        ProgramOfStudy program = null;
        if (programName != null) {
            program = ProgramOfStudy.factory.obtainByName(programName);
        }
        return program;
    }

    public static ProgramOfStudy obtainProgramOfStudyByCode(String programCode) {
        ProgramOfStudy program = null;
        if (programCode != null) {
            program = ProgramOfStudy.factory.obtainByCode(programCode);
        }
        return program;
    }

    public static MaritalStatus obtainMaritalStatus(String maritalStatus) {
        if (maritalStatus == null) {
            return null;
        }
        MaritalStatus ms = null;
        try {
            ms = ObtainUtil.obtainMaritalStatusByCode(maritalStatus);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainMaritalStatus (by code) Exception: ", (Throwable)e);
        }
        if (ms == null) {
            try {
                ms = ObtainUtil.obtainMaritalStatusByName(maritalStatus);
            }
            catch (Exception e) {
                logger.error((Object)" ObtainUtil.obtainMaritalStatus (by Name) Exception: ", (Throwable)e);
            }
        }
        if (ms == null) {
            try {
                ms = MaritalStatus.factory.obtainFromKeyString(maritalStatus);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainMaritalStatus (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return ms;
    }

    public static MaritalStatus obtainMaritalStatusByCode(String maritalStatusCode) {
        MaritalStatus status = null;
        if (maritalStatusCode != null) {
            status = MaritalStatus.factory.obtainByCode(maritalStatusCode);
        }
        return status;
    }

    public static MaritalStatus obtainMaritalStatusByName(String maritalStatusName) {
        Criteria.EqualIgnoreCase criteria;
        MaritalStatus[] statuses;
        MaritalStatus status = null;
        if (maritalStatusName != null && (statuses = MaritalStatus.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase(NAME_TXT, maritalStatusName)))).length != 0) {
            status = statuses[0];
            if (statuses.length > 1) {
                logger.warn((Object)("Multiple SDS MaritalStatus objects returned for '" + maritalStatusName + "'"));
            }
        }
        return status;
    }

    public static AddressType obtainAddressType(String addrType) {
        if (addrType == null) {
            return null;
        }
        AddressType ms = null;
        try {
            ms = ObtainUtil.obtainAddressTypeByCode(addrType);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainAddressType (by code) Exception: ", (Throwable)e);
        }
        if (ms == null) {
            try {
                ms = ObtainUtil.obtainAddressTypeByName(addrType);
            }
            catch (Exception e) {
                logger.error((Object)" ObtainUtil.obtainAddressType (by Name) Exception: ", (Throwable)e);
            }
        }
        if (ms == null) {
            try {
                ms = AddressType.factory.obtainFromKeyString(addrType);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainAddressType (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return ms;
    }

    public static AddressType obtainAddressTypeByCode(String addrTypeCode) {
        AddressType type = null;
        if (addrTypeCode != null) {
            type = AddressType.factory.obtainByCode(addrTypeCode);
        }
        return type;
    }

    public static AddressType obtainAddressTypeByName(String addrTypeName) {
        Criteria.EqualIgnoreCase criteria;
        AddressType[] statuses;
        AddressType type = null;
        if (addrTypeName != null && (statuses = AddressType.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase(NAME_TXT, addrTypeName)))).length != 0) {
            type = statuses[0];
            if (statuses.length > 1) {
                logger.warn((Object)("Multiple SDS AddressType objects returned for '" + addrTypeName + "'"));
            }
        }
        return type;
    }

    public static Religion obtainReligion(String religion) {
        if (religion == null) {
            return null;
        }
        Religion rel = null;
        try {
            rel = ObtainUtil.obtainReligionByCode(religion);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainReligion (by Code) Exception: ", (Throwable)e);
        }
        if (rel == null) {
            try {
                rel = ObtainUtil.obtainReligionByName(religion);
            }
            catch (Exception e) {
                logger.error((Object)" ObtainUtil.obtainReligion (by Name) Exception: ", (Throwable)e);
            }
        }
        if (rel == null) {
            try {
                rel = Religion.factory.obtainFromKeyString(religion);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainReligion (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return rel;
    }

    public static Religion obtainReligionByCode(String religionCode) {
        Religion religion = null;
        if (religionCode != null) {
            religion = Religion.factory.obtainByCode(religionCode);
        }
        return religion;
    }

    public static Religion obtainReligionByName(String religionName) {
        Criteria.EqualIgnoreCase criteria;
        Religion[] religions;
        Religion religion = null;
        if (religionName != null && (religions = Religion.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase(NAME_TXT, religionName)))).length != 0) {
            religion = religions[0];
            if (religions.length > 1) {
                logger.warn((Object)("Multiple SDS Religion objects returned for '" + religionName + "'"));
            }
        }
        return religion;
    }

    public static PersonClass obtainPersonClass(String personClass) {
        if (personClass == null) {
            return null;
        }
        PersonClass pc = null;
        try {
            pc = ObtainUtil.obtainPersonClassByVaCode(personClass);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainPersonClass (by VACode) Exception: ", (Throwable)e);
        }
        if (pc == null) {
            try {
                pc = ObtainUtil.obtainPersonClassByAreaOfSpecialization(personClass);
            }
            catch (Exception e) {
                logger.error((Object)" ObtainUtil.obtainPersonClass (by name) Exception: ", (Throwable)e);
            }
        }
        if (pc == null) {
            try {
                pc = PersonClass.factory.obtainFromKeyString(personClass);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainPersonClass (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return pc;
    }

    public static PersonClass obtainPersonClassByVaCode(String pcVaCode) {
        PersonClass personClass = null;
        if (pcVaCode != null) {
            personClass = PersonClass.factory.obtainByVaCode(pcVaCode);
        }
        return personClass;
    }

    public static PersonClass obtainPersonClassByAreaOfSpecialization(String personClassName) {
        Criteria.EqualIgnoreCase criteria;
        PersonClass[] classes;
        PersonClass personClass = null;
        if (personClassName != null && (classes = PersonClass.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase("areaOfSpecialization", personClassName)))).length != 0) {
            personClass = classes[0];
            if (classes.length > 1) {
                logger.warn((Object)("Multiple SDS PersonClass objects returned for '" + personClassName + "'"));
            }
        }
        return personClass;
    }

    public static Ethnicity obtainEthnicity(String ethnicity) {
        if (ethnicity == null) {
            return null;
        }
        Ethnicity ethnit = null;
        try {
            ethnit = ObtainUtil.obtainEthnicityByAbbreviation(ethnicity);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainEthnicity (by abbreviation) Exception: ", (Throwable)e);
        }
        if (ethnit == null) {
            try {
                ethnit = ObtainUtil.obtainEthnicityByName(ethnicity);
            }
            catch (Exception e) {
                logger.error((Object)" ObtainUtil.obtainEthnicity (by abbreviation) Exception: ", (Throwable)e);
            }
        }
        if (ethnit == null) {
            try {
                ethnit = Ethnicity.factory.obtainFromKeyString(ethnicity);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainEthnicity (by Key String) Exception: ", (Throwable)ne);
            }
        }
        return ethnit;
    }

    public static Ethnicity obtainEthnicityByAbbreviation(String abbreviation) {
        Ethnicity ethnicity = null;
        if (abbreviation != null) {
            ethnicity = Ethnicity.factory.obtainByAbbreviation(abbreviation);
        }
        return ethnicity;
    }

    public static Ethnicity obtainEthnicityByName(String ethnicityName) {
        Criteria.EqualIgnoreCase criteria;
        Ethnicity[] ethnicities;
        Ethnicity ethnicity = null;
        if (ethnicityName != null && (ethnicities = Ethnicity.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase(NAME_TXT, ethnicityName)))).length != 0) {
            ethnicity = ethnicities[0];
            if (ethnicities.length > 1) {
                logger.warn((Object)("Multiple SDS Ethnicity objects returned for '" + ethnicityName + "'"));
            }
        }
        return ethnicity;
    }

    public static Race obtainRace(String race) {
        if (race == null) {
            return null;
        }
        Race rc = null;
        try {
            rc = ObtainUtil.obtainRaceByHL7Code(race);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainRace (by HL7code) Exception: ", (Throwable)e);
        }
        if (rc == null) {
            try {
                rc = ObtainUtil.obtainRaceByName(race);
            }
            catch (Exception e) {
                logger.error((Object)" ObtainUtil.obtainRace (by name) Exception: ", (Throwable)e);
            }
        }
        if (rc == null) {
            try {
                rc = Race.factory.obtainFromKeyString(race);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainRace (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return rc;
    }

    public static Race obtainRaceByHL7Code(String raceHL7code) {
        Race race = null;
        if (raceHL7code != null) {
            race = Race.factory.obtainByHl7Code(raceHL7code);
        }
        return race;
    }

    public static Race obtainRaceByName(String raceName) {
        Criteria.EqualIgnoreCase criteria;
        Race[] races;
        Race race = null;
        if (raceName != null && (races = Race.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase(NAME_TXT, raceName)))).length != 0) {
            race = races[0];
            if (races.length > 1) {
                logger.warn((Object)("Multiple SDS Race objects returned for '" + raceName + "'"));
            }
        }
        return race;
    }

    public static IAddressChangeSrcType obtainAddressChangeSrcType(String value) {
        if (value == null) {
            return null;
        }
        return IAddressChangeSrcType.factory.obtainByCode(value);
    }

    public static IAddressInvalidType obtainAddressInvalidType(String value) {
        if (value == null) {
            return null;
        }
        return IAddressInvalidType.factory.obtainByCode(value);
    }

    public static IMethodCollType obtainMethodCollType(String value) {
        if (value == null) {
            return null;
        }
        return IMethodCollType.factory.obtainByDescription(value);
    }

    public static IBenefitsCoordinationType obtainBenefitsCoordType(String value) {
        if (value == null) {
            return null;
        }
        return IBenefitsCoordinationType.factory.obtainByDescription(value);
    }

    public static IElectronicPlanType obtainElectronicPlanType(String value) {
        if (value == null) {
            return null;
        }
        return IElectronicPlanType.factory.obtainByDescription(value);
    }

    public static IInsuranceHolderType obtainInsuranceHolderType(String value) {
        if (value == null) {
            return null;
        }
        return IInsuranceHolderType.factory.obtainByDescription(value);
    }

    public static IPlanCategoryType obtainPlanCategoryType(String value) {
        if (value == null) {
            return null;
        }
        return IPlanCategoryType.factory.obtainByDescription(value);
    }

    public static IConfidentialAddrType obtainConfidentialAddrType(String value) {
        if (value == null) {
            return null;
        }
        return IConfidentialAddrType.factory.obtainByDescription(value);
    }

    public static IDeathNotificationSrcType obtainDeathNotificationSrcType(String value) {
        if (value == null) {
            return null;
        }
        return IDeathNotificationSrcType.factory.obtainByDescription(value);
    }

    public static IEmailType obtainEmailType(String value) {
        if (value == null) {
            return null;
        }
        return IEmailType.factory.obtainByDescription(value);
    }

    public static IEmailChangeSourceType obtainEmailChangeSourceType(String value) {
        if (value == null) {
            return null;
        }
        return IEmailChangeSourceType.factory.obtainByDescription(value);
    }

    public static IEmploymentStatusType obtainEmploymentStatusType(String value) {
        if (value == null) {
            return null;
        }
        return IEmploymentStatusType.factory.obtainByDescription(value);
    }

    public static IPersonContactType obtainPersonContactType(String value) {
        if (value == null) {
            return null;
        }
        return IPersonContactType.factory.obtainByDescription(value);
    }

    public static IPhoneChangeSourceType obtainPhoneChangeSourceType(String value) {
        if (value == null) {
            return null;
        }
        return IPhoneChangeSourceType.factory.obtainByDescription(value);
    }

    public static IPhoneType obtainPhoneType(String value) {
        if (value == null) {
            return null;
        }
        return IPhoneType.factory.obtainByDescription(value);
    }

    private static Integer getInteger(String value) {
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                logger.error((Object)(" ObtainUtil.getInteger() Value is not numeric: " + value), (Throwable)e);
            }
        }
        return null;
    }

    public static SSAVerificationCode obtainSSAVerificationCode(String verificationCode) {
        if (verificationCode == null) {
            return null;
        }
        SSAVerificationCode verifyCode = null;
        try {
            verifyCode = ObtainUtil.obtainSSAVerificationCodeByCode(verificationCode);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainSSAVerificationCode (by Code) Exception: ", (Throwable)e);
        }
        return verifyCode;
    }

    public static SSAVerificationCode obtainSSAVerificationCodeByCode(String code) {
        SSAVerificationCode verifyCode = null;
        if (code != null) {
            verifyCode = SSAVerificationCode.factory.obtainByCode(code);
        }
        return verifyCode;
    }

    public static SSNChangeSource obtainSSNChangeSource(String changeSource) {
        if (changeSource == null) {
            return null;
        }
        SSNChangeSource chgSource = null;
        try {
            chgSource = ObtainUtil.obtainSSNChangeSourceByCode(changeSource);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainSSNChangeSource (by Code) Exception: ", (Throwable)e);
        }
        return chgSource;
    }

    public static SSNChangeSource obtainSSNChangeSourceByCode(String changeSource) {
        SSNChangeSource chgSource = null;
        if (changeSource != null) {
            chgSource = SSNChangeSource.factory.obtainByCode(changeSource);
        }
        return chgSource;
    }

    public static SSNVerificationStatus obtainSSNVerificationStatus(String verStatus) {
        if (verStatus == null) {
            return null;
        }
        SSNVerificationStatus status = null;
        try {
            status = ObtainUtil.obtainSSNVerificationStatusByCode(verStatus);
        }
        catch (Exception e) {
            logger.error((Object)" ObtainUtil.obtainSSNVerificationStatus (by Code) Exception: ", (Throwable)e);
        }
        if (status == null) {
            try {
                status = ObtainUtil.obtainSSNVerificationStatusByName(verStatus);
            }
            catch (Exception e) {
                logger.error((Object)" ObtainUtil.obtainSSNVerificationStatus (by Name) Exception: ", (Throwable)e);
            }
        }
        if (status == null) {
            try {
                status = SSNVerificationStatus.factory.obtainFromKeyString(verStatus);
            }
            catch (NumberFormatException ne) {
                logger.error((Object)" ObtainUtil.obtainSSNVerificationStatus (by KeyString) Exception: ", (Throwable)ne);
            }
        }
        return status;
    }

    public static SSNVerificationStatus obtainSSNVerificationStatusByCode(String statusCode) {
        SSNVerificationStatus status = null;
        if (statusCode != null) {
            status = SSNVerificationStatus.factory.obtainByCode(ObtainUtil.getInteger(statusCode));
        }
        return status;
    }

    public static SSNVerificationStatus obtainSSNVerificationStatusByName(String statusName) {
        Criteria.EqualIgnoreCase criteria;
        SSNVerificationStatus[] statuses;
        SSNVerificationStatus status = null;
        if (statusName != null && (statuses = SSNVerificationStatus.factory.obtain((Criteria)(criteria = new Criteria.EqualIgnoreCase(NAME_TXT, statusName)))).length != 0) {
            status = statuses[0];
            if (statuses.length > 1) {
                logger.warn((Object)("Multiple SDS SSNVerificationStatus objects returned for '" + statusName + "'"));
            }
        }
        return status;
    }

    public static IChangeType obtainChangeTypeByName(String name) {
        ChangeType type = null;
        try {
            type = ChangeType.obtainByName(name);
        }
        catch (DataAccessException e) {
            logger.error((Object)"DataAccessException caught!", (Throwable)e);
        }
        return type;
    }

    public static VerificationLevel obtainVerificationLevelByName(String name) {
        VerificationLevel level = null;
        try {
            level = VerificationLevel.obtainByName(name);
        }
        catch (DataAccessException e) {
            logger.error((Object)"HibernateException caught!", (Throwable)e);
        }
        return level;
    }
}

