/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.util;

import gov.va.med.person.idmgmt.util.PSIMSettings;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class NameStandardization {
    private static final int UPPERCASE_Z = 90;
    private static final int UPPERCASE_A = 65;
    private String lastName;
    private String givenName;
    private String midName;
    private String suffix;
    private static int lengthOfName = 50;
    private static int maxFirstNameLength;
    private static int maxMiddleNameLength;
    private static int maxLastNameLength;
    private static int maxSuffixLength;
    private static final char[] SEP;
    private static final char[] PARENTHESIS;
    private static final char[] REMAINCHARS;
    private static final Pattern UPPERCASE_PATTERN;
    private static final Pattern nmiPresentPattern;
    private static final Pattern nmiSurroundedPattern;
    private static final String[] DOUBLECHARS;
    private static final String[] CHARS;
    private static final String[] NUMERIC_POST;
    private static final String[] ROMAN_NUMERAL;
    private static final String[] NM;
    private static final String[] DRS;
    private static final String DR = " DR";

    static {
        SEP = new char[]{' ', ','};
        PARENTHESIS = new char[]{'{', '}', '[', ']', '(', ')'};
        REMAINCHARS = new char[]{'\'', ',', '-', ' '};
        UPPERCASE_PATTERN = Pattern.compile("[A-Z]+");
        nmiPresentPattern = Pattern.compile("(?i)nm[in]");
        nmiSurroundedPattern = Pattern.compile("(?i)([a-z]+nm[in])|(nm[in][a-z]+)");
        DOUBLECHARS = new String[]{"`", "  ", "--", "''", ", ", ",-", ",'", " ,", "-,", "',", " -", "- ", " '", "' ", "-'", "'-"};
        CHARS = new String[]{"'", " ", "-", "'", ",", ",", ",", ",", ",", ",", " ", " ", " ", " ", "-", "-"};
        NUMERIC_POST = new String[]{"1ST", "2ND", "3RD", "4TH", "5TH", "6TH", "7TH", "8TH", "9TH", "10TH"};
        ROMAN_NUMERAL = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        NM = new String[]{"NMI", "NMN"};
        DRS = new String[]{",DR ", ",DR."};
        PSIMSettings settings = PSIMSettings.getInstance();
        maxFirstNameLength = Integer.parseInt(settings.getValue(NameStandardization.class, "maxFirstNameLength"));
        maxMiddleNameLength = Integer.parseInt(settings.getValue(NameStandardization.class, "maxMiddleNameLength"));
        maxLastNameLength = Integer.parseInt(settings.getValue(NameStandardization.class, "maxLastNameLength"));
        maxSuffixLength = Integer.parseInt(settings.getValue(NameStandardization.class, "maxSuffixLength"));
    }

    public NameStandardization(String aLastName, String aGivenName, String aMidName, String aSuffix) {
        try {
            this.lastName = this.getStdName(aLastName, maxLastNameLength);
            this.givenName = this.getStdName(aGivenName, maxFirstNameLength);
            this.midName = NameStandardization.getStdMidName(aMidName, maxMiddleNameLength);
            this.suffix = this.getStdName(aSuffix, maxSuffixLength);
        }
        catch (RuntimeException e) {
            Logger.getLogger(this.getClass()).error((Object)("Failed to process name! lastName='" + this.lastName + "', givenName='" + this.givenName + "', midName='" + this.midName + "', suffix='" + this.suffix + "'"), (Throwable)e);
            throw e;
        }
    }

    public NameStandardization() {
    }

    public void setLength(int len) {
        lengthOfName = len;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getMidName() {
        return this.midName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public static String getName(String name) {
        String nme = name;
        if (name != null && name.length() > 0) {
            nme = NameStandardization.getStdName(name).toString();
        }
        return nme;
    }

    public static String getMidName(String name) {
        String nme = name;
        if (name != null && name.length() > 0) {
            nme = NameStandardization.getStdMidName(name).toString();
        }
        return nme;
    }

    public String getName() {
        String mid = this.midName;
        String last = this.lastName;
        String given = this.givenName;
        String suf = this.suffix;
        int length = last.length() + given.length() + mid.length() + suf.length() + 3;
        if (length > lengthOfName) {
            mid = NameStandardization.truncateName(mid, length);
        }
        if ((length = last.length() + given.length() + mid.length() + suf.length() + 3) > lengthOfName) {
            given = NameStandardization.truncateName(given, length);
        }
        if ((length = last.length() + given.length() + mid.length() + suf.length() + 3) > lengthOfName) {
            suf = null;
        }
        int sufLength = suf == null ? 0 : suf.length();
        length = last.length() + given.length() + mid.length() + sufLength + 3;
        if (length > lengthOfName) {
            last = NameStandardization.truncateName(last, length);
        }
        if (last.length() < 1) {
            return null;
        }
        StringBuffer resultName = new StringBuffer(last).append(',').append(given).append(' ').append(mid).append(' ').append(suf);
        NameStandardization.trimNonAlphaChars(resultName);
        this.moveDrToEnd(resultName);
        return resultName.toString();
    }

    private static String truncateName(String name, int len) {
        int endPos = name.length() - len + lengthOfName;
        endPos = endPos > 0 ? endPos : 1;
        StringBuffer nameBuff = new StringBuffer(name.substring(0, endPos));
        NameStandardization.trimNonAlphaChars(nameBuff);
        return nameBuff.toString();
    }

    private static void truncate(StringBuffer name, int len) {
        int endPos = name.length();
        int n = endPos = endPos > 0 ? endPos : 1;
        if (endPos > len) {
            name.delete(len, endPos);
        }
    }

    private static String getStdMidName(String text, int len) {
        if (text == null || text.length() < 1) {
            return text;
        }
        StringBuffer name = NameStandardization.getStdMidName(text);
        NameStandardization.truncate(name, len);
        return name.toString();
    }

    private static StringBuffer getStdMidName(String text) {
        StringBuffer name = new StringBuffer(text.toUpperCase());
        NameStandardization.trimNonAlphaChars(name);
        NameStandardization.removeNMI(name);
        if (name.length() > 0) {
            return NameStandardization.getStdName(name.toString());
        }
        return name;
    }

    private String getStdName(String text, int componentLength) {
        if (text == null || text.length() < 1) {
            return text;
        }
        StringBuffer name = NameStandardization.getStdName(text);
        NameStandardization.truncate(name, componentLength);
        return name.toString();
    }

    private static StringBuffer getStdName(String text) {
        StringBuffer name = new StringBuffer(text.toUpperCase());
        if (!UPPERCASE_PATTERN.matcher(text).matches()) {
            NameStandardization.removeParenttheticalText(name);
            NameStandardization.transformBirthPostion(name);
            NameStandardization.tranformDoubleChars(name);
            NameStandardization.removeNonUppercase(name);
            NameStandardization.trimNonAlphaChars(name);
        }
        return name;
    }

    private void moveDrToEnd(StringBuffer text) {
        int pos = 0;
        boolean pass = false;
        int i = 0;
        while (i < DRS.length) {
            pos = text.indexOf(DRS[i]);
            while (pos >= 0) {
                text.delete(pos + 1, pos + DRS[i].length());
                pass = true;
                pos = text.indexOf(DRS[i]);
            }
            ++i;
        }
        if (pass) {
            text.append(DR);
        }
    }

    private static boolean isAllUpperCase(String theName) {
        Matcher matcher = UPPERCASE_PATTERN.matcher(theName);
        boolean isUpper = matcher.matches();
        return isUpper;
    }

    private static boolean isNMIStringPresent(String theName) {
        Matcher matcher = nmiPresentPattern.matcher(theName);
        boolean isPresent = matcher.find();
        return isPresent;
    }

    private static boolean isNMISurroundedByChars(String theName) {
        Matcher matcher = nmiSurroundedPattern.matcher(theName);
        boolean isSurround = matcher.find();
        return isSurround;
    }

    private static void removeNMI(StringBuffer text) {
        String _midName = text.toString();
        if (!NameStandardization.isNMIStringPresent(_midName)) {
            return;
        }
        if (NameStandardization.isNMISurroundedByChars(_midName)) {
            return;
        }
        if (NameStandardization.isAllUpperCase(_midName)) {
            text.delete(0, text.length());
            return;
        }
        NameStandardization.removeNMIFromInvalidChars(text);
    }

    private static void removeNMIFromInvalidChars(StringBuffer text) {
        int pos = 0;
        boolean pass = false;
        boolean testAgain = true;
        int count = 0;
        String _midName = text.toString();
        while (testAgain && count < 25) {
            testAgain = false;
            ++count;
            if (_midName.equalsIgnoreCase(NM[0]) || _midName.equalsIgnoreCase(NM[1])) {
                text.delete(0, 3);
                _midName = text.toString();
                return;
            }
            pos = text.indexOf(NM[0]);
            if (pos == -1) {
                pos = text.indexOf(NM[1]);
            }
            if (pos > 0 && text.length() > 3) {
                char leadChar = text.charAt(pos - 1);
                if (NameStandardization.isUpperCase(leadChar) || NameStandardization.isExtendedChar(leadChar)) {
                    return;
                }
                if (leadChar != ' ' && leadChar != ',') {
                    text.delete(pos - 1, pos);
                    _midName = text.toString();
                    testAgain = true;
                    continue;
                }
            }
            if (text.length() <= pos + 3) continue;
            char trailChar = text.charAt(pos + 3);
            if (NameStandardization.isUpperCase(trailChar) || NameStandardization.isExtendedChar(trailChar)) {
                return;
            }
            if (trailChar == ' ' || trailChar == ',') continue;
            text.delete(pos + 3, pos + 4);
            _midName = text.toString();
            testAgain = true;
        }
        int i = 0;
        while (i < NM.length) {
            pos = text.indexOf(NM[i]);
            pass = false;
            block2: while (pos >= 0) {
                int j = 0;
                while (j < SEP.length) {
                    if (pass) continue block2;
                    if (pos == 0 || text.charAt(pos - 1) == SEP[j]) {
                        int k = 0;
                        while (k < SEP.length) {
                            if (pos + NM[i].length() >= text.length() || pos + NM[i].length() < text.length() && text.charAt(pos + NM[i].length()) == SEP[k]) {
                                pass = true;
                                break;
                            }
                            ++k;
                        }
                    }
                    if (pass) {
                        text.delete(pos, pos + NM[i].length());
                        _midName = text.toString();
                    }
                    pos = text.indexOf(NM[i]);
                    ++j;
                }
            }
            ++i;
        }
    }

    private static void removeParenttheticalText(StringBuffer text) {
        int p = 0;
        while (p < PARENTHESIS.length) {
            int openParenNdx = NameStandardization.indexOf(text, PARENTHESIS[p], 0);
            while (openParenNdx != -1) {
                int closeParenNdx = NameStandardization.indexOf(text, PARENTHESIS[p + 1], openParenNdx + 1);
                if (closeParenNdx != -1) {
                    text.delete(openParenNdx, closeParenNdx + 1);
                    openParenNdx = NameStandardization.indexOf(text, PARENTHESIS[p], openParenNdx);
                    continue;
                }
                openParenNdx = NameStandardization.indexOf(text, PARENTHESIS[p], openParenNdx + 1);
            }
            p += 2;
        }
    }

    private static int indexOf(StringBuffer text, char c, int start) {
        int i = start;
        while (i < text.length()) {
            if (text.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static void trimNonAlphaChars(StringBuffer text) {
        if (text.length() > 1) {
            while (!NameStandardization.isUpperCase(text.charAt(0)) && !NameStandardization.isExtendedChar(text.charAt(0)) && text.length() > 1) {
                text.deleteCharAt(0);
            }
        }
        if (text.length() > 1) {
            while (!NameStandardization.isUpperCase(text.charAt(text.length() - 1)) && !NameStandardization.isExtendedChar(text.charAt(text.length() - 1)) && text.length() > 1) {
                text.deleteCharAt(text.length() - 1);
            }
        }
        if (text.length() == 1 && !NameStandardization.isUpperCase(text.charAt(0)) && !NameStandardization.isExtendedChar(text.charAt(0))) {
            text.deleteCharAt(0);
        }
    }

    private static void removeNonUppercase(StringBuffer text) {
        int i = text.length() - 1;
        while (i >= 0) {
            if (!NameStandardization.isValid(text.charAt(i))) {
                text.deleteCharAt(i);
            }
            --i;
        }
    }

    private static boolean isValid(char c) {
        return NameStandardization.isUpperCase(c) || NameStandardization.isValidSpecialChar(c) || NameStandardization.isExtendedChar(c);
    }

    private static boolean isValidSpecialChar(char c) {
        int i = 0;
        while (i < REMAINCHARS.length) {
            if (c == REMAINCHARS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isExtendedChar(char c) {
        return c == '\u00c7' || c == '\u00c4' || c == '\u00c5' || c == '\u00c9' || c == '\u00d6' || c == '\u00dc' || c == '\u00d1' || c == '\u00d4';
    }

    private static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static void tranformDoubleChars(StringBuffer text) {
        int pos = 0;
        int i = 0;
        while (i < DOUBLECHARS.length) {
            pos = text.indexOf(DOUBLECHARS[i]);
            while (pos >= 0) {
                text.replace(pos, pos + DOUBLECHARS[i].length(), CHARS[i]);
                pos = text.indexOf(DOUBLECHARS[i]);
            }
            ++i;
        }
    }

    public static String getJoinedCharacterString(String target, String inclusionCharacters) {
        if (target == null || inclusionCharacters == null) {
            return target;
        }
        StringBuffer temp = new StringBuffer();
        temp.append(inclusionCharacters);
        HashSet<Character> inclusionCharSet = new HashSet<Character>();
        int i = 0;
        while (i < temp.length()) {
            inclusionCharSet.add(new Character(temp.charAt(i)));
            ++i;
        }
        StringBuffer sbBefore = new StringBuffer(target);
        StringBuffer joinedString = new StringBuffer();
        int i2 = 0;
        while (i2 < sbBefore.length()) {
            Character c = new Character(sbBefore.charAt(i2));
            if (inclusionCharSet.contains(c)) {
                joinedString.append(c);
            }
            ++i2;
        }
        return joinedString.toString();
    }

    private static void transformBirthPostion(StringBuffer text) {
        int pos = 0;
        int i = 0;
        while (i < NUMERIC_POST.length) {
            boolean pass = false;
            pos = text.indexOf(NUMERIC_POST[i]);
            while (pos >= 0) {
                int j = 0;
                while (j < SEP.length) {
                    if (pass) break;
                    if (pos == 0 || text.charAt(pos - 1) == SEP[j]) {
                        int k = 0;
                        while (k < SEP.length) {
                            if (pos + NUMERIC_POST[i].length() >= text.length() || pos + NUMERIC_POST[i].length() < text.length() && text.charAt(pos + NUMERIC_POST[i].length()) == SEP[k]) {
                                pass = true;
                                break;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                if (pass) {
                    text.replace(pos, pos + NUMERIC_POST[i].length(), ROMAN_NUMERAL[i]);
                }
                pos = text.indexOf(NUMERIC_POST[i], pos + NUMERIC_POST[i].length() - 1);
            }
            ++i;
        }
    }
}

