/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.util;

import java.lang.reflect.Array;

public final class ArrayToString {
    public static final String START_CHAR = "[";
    public static final String END_CHAR = "]";
    public static final String SEPARATOR = ", ";
    public static final String NULL_REPLACEMENT = "null";

    public static String get(Object aArray, String separator, String startString, String endString, String nullReplaceString) {
        if (aArray == null) {
            return nullReplaceString;
        }
        ArrayToString.checkObjectIsArray(aArray);
        StringBuffer result = new StringBuffer(startString);
        int length = Array.getLength(aArray);
        int idx = 0;
        while (idx < length) {
            Object item = Array.get(aArray, idx);
            if (ArrayToString.isNonNullArray(item)) {
                result.append(ArrayToString.get(item));
            } else {
                result.append(item);
            }
            if (!ArrayToString.isLastItem(idx, length)) {
                result.append(separator);
            }
            ++idx;
        }
        result.append(endString);
        return result.toString();
    }

    public static String get(Object aArray) {
        return ArrayToString.get(aArray, SEPARATOR, START_CHAR, END_CHAR, NULL_REPLACEMENT);
    }

    public static String get(Object aArray, String separator) {
        return ArrayToString.get(aArray, separator, START_CHAR, END_CHAR, NULL_REPLACEMENT);
    }

    public static String get(Object aArray, String separator, String startString, String endString) {
        return ArrayToString.get(aArray, separator, startString, endString, NULL_REPLACEMENT);
    }

    private static void checkObjectIsArray(Object aArray) {
        if (!aArray.getClass().isArray()) {
            throw new IllegalArgumentException("Object is not an array.");
        }
    }

    private static boolean isNonNullArray(Object aItem) {
        return aItem != null && aItem.getClass().isArray();
    }

    private static boolean isLastItem(int aIdx, int aLength) {
        return aIdx == aLength - 1;
    }

    public static void main(String[] args) {
    }
}

