/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.types;

import gov.va.med.term.access.util.Is;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class ImpreciseDate
implements Cloneable,
Serializable {
    private final String date_;
    private static final String YEAR_FORMAT = "yyyy";
    private static final String YEAR_MO_FORMAT = "yyyyMM";
    private static final String YEAR_MO_DAY_FORMAT = "yyyyMMdd";

    public ImpreciseDate(String date) {
        String newDate = this.truncate(date);
        if (!ImpreciseDate.isValid(newDate)) {
            throw new IllegalArgumentException("Date format must be YYYY[MM[DD]]: " + date);
        }
        this.date_ = newDate;
    }

    public String getDate() {
        return this.date_;
    }

    public int getYear() {
        return Integer.parseInt(this.date_.substring(0, 4));
    }

    public int getMonth() {
        return this.date_.length() > 4 ? Integer.parseInt(this.date_.substring(4, 6)) : 0;
    }

    public int getDay() {
        return this.date_.length() > 6 ? Integer.parseInt(this.date_.substring(6, 8)) : 0;
    }

    public static boolean isValid(String date) {
        boolean okay = false;
        if ("\"\"".equals(date) || "NOTSENT".equals(date)) {
            return true;
        }
        try {
            if (date != null) {
                String dateFormat = "";
                if (date.length() == 4) {
                    dateFormat = YEAR_FORMAT;
                } else if (date.length() == 6) {
                    dateFormat = YEAR_MO_FORMAT;
                } else if (date.length() == 8) {
                    dateFormat = YEAR_MO_DAY_FORMAT;
                }
                SimpleDateFormat format = new SimpleDateFormat(dateFormat);
                format.setLenient(false);
                if (format.parse(date) != null) {
                    okay = true;
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return okay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImpreciseDate other = (ImpreciseDate)o;
        return Is.equal((Object)this.getDate(), (Object)other.getDate());
    }

    public int hashCode() {
        return this.date_.hashCode();
    }

    public Object clone() {
        try {
            ImpreciseDate result = (ImpreciseDate)super.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.date_;
    }

    private String truncate(String date) {
        int dateLen;
        String newDate = date;
        if (date != null && (dateLen = date.length()) > 4) {
            if (dateLen > 8) {
                newDate = newDate.substring(0, 8);
            }
            int newDateLen = newDate.length();
            while (newDateLen > 4 && newDateLen % 2 == 0) {
                dateLen = newDate.length();
                if (!"00".equals(newDate.substring(dateLen - 2, dateLen))) break;
                newDate = newDate.substring(0, dateLen - 2);
                newDateLen = newDate.length();
            }
        }
        return newDate;
    }

    public static ImpreciseDate valueOf(String date) {
        return new ImpreciseDate(date);
    }
}

