/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.sds;

import gov.va.med.person.idmgmt.sds.IdmAssigningAuthority;
import gov.va.med.person.idmgmt.sds.IdmInstitution;
import gov.va.med.term.access.AssigningAuthority;
import gov.va.med.term.access.Country;
import gov.va.med.term.access.Gender;
import gov.va.med.term.access.Institution;
import gov.va.med.term.access.NameType;
import gov.va.med.term.access.PseudoSSNReason;
import gov.va.med.term.access.SSAVerificationCode;
import gov.va.med.term.access.SSNChangeSource;
import gov.va.med.term.access.SSNType;
import gov.va.med.term.access.SSNVerificationStatus;
import gov.va.med.term.access.State;
import gov.va.med.term.access.criteria.Criteria;

public class SDSDelegate {
    public static IdmAssigningAuthority getAssigningAuthorityByKeyValue(Long aaKey) {
        return SDSDelegate.adapt(AssigningAuthority.factory.obtainFromKeyValue(aaKey));
    }

    public static IdmAssigningAuthority getAssigningAuthorityByCode(String code) {
        return SDSDelegate.adapt(AssigningAuthority.factory.obtainByCode(code));
    }

    public static IdmInstitution getInstitutionByKeyValue(Long keyValue) {
        Institution institution = Institution.factory.obtainFromKeyValue(keyValue);
        return SDSDelegate.adapt(institution);
    }

    public static IdmInstitution getInstitutionByStationNumber(String stationNumber) {
        Institution institution = Institution.factory.obtainByStationNumber(stationNumber);
        return SDSDelegate.adapt(institution);
    }

    public static IdmInstitution getInstitutionByName(String institutionName) {
        IdmInstitution inst = null;
        String NAME_TXT = "name";
        if (institutionName != null) {
            Criteria.EqualIgnoreCase criteria = new Criteria.EqualIgnoreCase("name", institutionName);
            Institution[] institutions = Institution.factory.obtain((Criteria)criteria);
            if (institutions.length == 1) {
                inst = SDSDelegate.adapt(institutions[0]);
            } else {
                int cfr_ignored_0 = institutions.length;
            }
        }
        return inst;
    }

    public static IdmInstitution getInstitutionByKeyString(String keystring) {
        Institution institution = Institution.factory.obtainFromKeyString(keystring);
        return SDSDelegate.adapt(institution);
    }

    public static IdmAssigningAuthority adapt(AssigningAuthority assigningAuthority) {
        IdmAssigningAuthority idmAa = null;
        if (assigningAuthority != null) {
            idmAa = new IdmAssigningAuthority(assigningAuthority.getCode());
            idmAa.setCodeSource("SDS");
            idmAa.setCountry(null);
            idmAa.setDescription(assigningAuthority.getDescription());
            idmAa.setId(assigningAuthority.getId());
        }
        return idmAa;
    }

    public static IdmInstitution adapt(Institution institution) {
        IdmInstitution idmInst = null;
        if (institution != null) {
            idmInst = new IdmInstitution();
            idmInst.setId(institution.getId());
            idmInst.setName(institution.getName());
            idmInst.setStationNumber(institution.getStationNumber());
            idmInst.setKeyString(institution.getKeyString());
            idmInst.setMedicalTreating(institution.isMedicalTreating());
            idmInst.setFacilityTypeCode(institution.getFacilityType().getCode());
        }
        return idmInst;
    }

    public static Long getNameTypeId(String nameCode) {
        Long id = null;
        NameType sdsObj = NameType.factory.obtainByCode(nameCode);
        if (sdsObj != null) {
            id = sdsObj.getId();
        }
        return id;
    }

    public static Long getSSNTypeId(String ssnCode) {
        Long id = null;
        SSNType sdsObj = SSNType.factory.obtainByCode(ssnCode);
        if (sdsObj != null) {
            id = sdsObj.getId();
        }
        return id;
    }

    public static Long getSSNVerificationStatusId(String code) {
        try {
            Integer ssnVerCode = Integer.valueOf(code);
            return SDSDelegate.getSSNVerificationStatusId(ssnVerCode);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Long getSSNVerificationStatusId(Integer code) {
        Long id = null;
        SSNVerificationStatus sdsObj = SSNVerificationStatus.factory.obtainByCode(code);
        if (sdsObj != null) {
            id = sdsObj.getId();
        }
        return id;
    }

    public static String getPseudoSSNReasonCode(Long id) {
        String code = null;
        PseudoSSNReason sdsObj = PseudoSSNReason.factory.obtainFromKeyValue(id);
        if (sdsObj != null) {
            code = sdsObj.getCode();
        }
        return code;
    }

    public static Long getPseudoSSNReasonId(String code) {
        Long id = null;
        PseudoSSNReason sdsObj = PseudoSSNReason.factory.obtainByCode(code);
        if (sdsObj != null) {
            id = sdsObj.getId();
        }
        return id;
    }

    public static Long getSSAVerificationCodeId(String code) {
        Long id = null;
        SSAVerificationCode sdsObj = SSAVerificationCode.factory.obtainByCode(code);
        if (sdsObj != null) {
            id = sdsObj.getId();
        }
        return id;
    }

    public static String getSSAVerificationCode(Long id) {
        String code = null;
        SSAVerificationCode sdsObj = SSAVerificationCode.factory.obtainFromKeyValue(id);
        if (sdsObj != null) {
            code = sdsObj.getCode();
        }
        return code;
    }

    public static Long getSSNChangeSourceId(String code) {
        Long id = null;
        SSNChangeSource sdsObj = SSNChangeSource.factory.obtainByCode(code);
        if (sdsObj != null) {
            id = sdsObj.getId();
        }
        return id;
    }

    public static Long getGenderId(String code) {
        Long id = null;
        Gender sdsObj = Gender.factory.obtainByCode(code);
        if (sdsObj != null) {
            id = sdsObj.getId();
        }
        return id;
    }

    public static Long getStateId(String code) {
        Long id = null;
        State state = SDSDelegate.getState(code);
        if (state != null) {
            id = state.getId();
        }
        return id;
    }

    private static State getState(String code) {
        State[] states;
        State state = null;
        Criteria.Equal criteria = new Criteria.Equal("postalName", (Object)code);
        if (criteria != null && (states = State.factory.obtain((Criteria)criteria)).length == 1) {
            state = states[0];
        }
        return state;
    }

    public static Long getCountryId(String stateCode) {
        Country country;
        Long id = null;
        State state = SDSDelegate.getState(stateCode);
        if (state != null && (country = state.getCountry()) != null) {
            id = country.getId();
        }
        return id;
    }
}

