/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.maint.util;

import gov.va.med.person.idmgmt.maint.util.UserText;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class UserErrors {
    private final UserErrors body_;
    private static final Object[] noMessageValues_ = new Object[0];
    private static final CatalogNameModifier nullCatalogNameModifier = new CatalogNameModifier(){

        @Override
        public String modifyName(String name) {
            return name;
        }
    };

    public UserErrors() {
        this.body_ = new Core();
    }

    UserErrors(boolean fromCore) {
        this.body_ = null;
    }

    protected UserErrors(UserErrors adapted) {
        this.body_ = adapted;
    }

    public Enumeration fieldErrorMessages() {
        return this.body_.fieldErrorMessages();
    }

    public Enumeration fieldErrorMessages(Locale locale, CatalogNameModifier catalogNameModifier) {
        return this.body_.fieldErrorMessages(locale, catalogNameModifier);
    }

    public Enumeration allErrorMessages() {
        return this.body_.allErrorMessages();
    }

    public Enumeration allErrorMessages(Locale locale, CatalogNameModifier catalogNameModifier) {
        return this.body_.allErrorMessages(locale, catalogNameModifier);
    }

    public Enumeration fieldErrors() {
        return this.body_.fieldErrors();
    }

    public boolean hasFieldErrors() {
        return this.body_.hasFieldErrors();
    }

    public FieldError fieldError(String name) {
        return this.body_.fieldError(name);
    }

    public String get(String name) {
        return this.body_.get(name);
    }

    public Object get(Object name) {
        return this.body_.get(name);
    }

    public boolean isEmpty() {
        return this.body_.isEmpty();
    }

    public Enumeration generalErrors() {
        return this.body_.generalErrors();
    }

    public Enumeration generalErrorMessages() {
        return this.body_.generalErrorMessages();
    }

    public Enumeration generalErrorMessages(Locale locale, CatalogNameModifier catalogNameModifier) {
        return this.body_.generalErrorMessages(locale, catalogNameModifier);
    }

    public boolean hasGeneralErrors() {
        return this.body_.hasGeneralErrors();
    }

    public void put(String message) {
        this.body_.put(message);
    }

    public void put(Object value, String name, String label, String message) {
        this.body_.put(value, name, label, message);
    }

    public void put(Object value, String name, String message) {
        this.body_.put(value, name, message);
    }

    public static Object[] makeMessageValues() {
        return noMessageValues_;
    }

    public static Object[] noMessageValues() {
        return noMessageValues_;
    }

    public static Object[] makeMessageValues(Object arg1) {
        return new Object[]{arg1};
    }

    public static Object[] makeMessageValues(Object arg1, Object arg2) {
        return new Object[]{arg1, arg2};
    }

    public static Object[] makeMessageValues(Object arg1, Object arg2, Object arg3) {
        return new Object[]{arg1, arg2, arg3};
    }

    public static Object[] makeMessageValues(Object arg1, Object arg2, Object arg3, Object arg4) {
        return new Object[]{arg1, arg2, arg3, arg4};
    }

    public static Object[] makeMessageValues(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Object[]{arg1, arg2, arg3, arg4, arg5};
    }

    public static Object[] makeMessageValues(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        return new Object[]{arg1, arg2, arg3, arg4, arg5, arg6};
    }

    public void put(String messageCatalog, String messageKey, Object[] messageValues, String defaultMessage) {
        this.body_.put(messageCatalog, messageKey, messageValues, defaultMessage);
    }

    public void put(Object value, String name, String label, String messageCatalog, String messageKey, Object[] messageValues, String defaultMessage) {
        this.body_.put(value, name, label, messageCatalog, messageKey, messageValues, defaultMessage);
    }

    public void put(Object value, String name, String messageCatalog, String messageKey, Object[] messageValues, String defaultMessage) {
        this.body_.put(value, name, messageCatalog, messageKey, messageValues, defaultMessage);
    }

    public int size() {
        return this.body_.size();
    }

    public void clear() {
        this.body_.clear();
    }

    public String toString() {
        Enumeration e;
        StringBuffer buf = new StringBuffer(255);
        if (this.hasGeneralErrors()) {
            buf.append("General error messages:\n");
            e = this.generalErrors();
            while (e.hasMoreElements()) {
                buf.append('\t');
                buf.append(e.nextElement().toString());
                buf.append('\n');
            }
        }
        if (this.hasFieldErrors()) {
            buf.append("Field error messages:\n");
            e = this.fieldErrors();
            while (e.hasMoreElements()) {
                buf.append('\t');
                buf.append(e.nextElement().toString());
                buf.append('\n');
            }
        }
        if (this.isEmpty()) {
            buf.append("no errors");
        }
        return buf.toString();
    }

    public UserErrors adaptWith(FieldNameModifier value) {
        return new ModifierDecorator(this, value);
    }

    public UserErrors adaptWith(Locale locale) {
        return new CatalogDecorator(this, locale, nullCatalogNameModifier);
    }

    public UserErrors adaptWith(CatalogNameModifier catalogNameModifier) {
        return new CatalogDecorator(this, Locale.getDefault(), catalogNameModifier);
    }

    private static class CatalogDecorator
    extends UserErrors {
        CatalogNameModifier catalogNameModifier_;
        Locale locale_;

        public CatalogDecorator(UserErrors adapted, Locale locale, CatalogNameModifier catalogNameModifier) {
            super(adapted);
            this.locale_ = locale;
            this.catalogNameModifier_ = catalogNameModifier;
        }

        @Override
        public String get(String name) {
            FieldError error = super.fieldError(name);
            return error == null ? null : error.message(this.locale_, this.catalogNameModifier_);
        }

        @Override
        public Object get(Object name) {
            FieldError error = super.fieldError(name.toString());
            return error == null ? null : error.message(this.locale_, this.catalogNameModifier_);
        }

        @Override
        public Enumeration fieldErrorMessages() {
            return this.fieldErrorMessages(this.locale_, this.catalogNameModifier_);
        }

        @Override
        public Enumeration generalErrorMessages() {
            return this.generalErrorMessages(this.locale_, this.catalogNameModifier_);
        }

        @Override
        public Enumeration allErrorMessages() {
            return this.allErrorMessages(this.locale_, this.catalogNameModifier_);
        }
    }

    public static interface CatalogNameModifier {
        public String modifyName(String var1);
    }

    private static class Core
    extends UserErrors {
        protected final Vector fieldErrors_ = new Vector();
        protected final Vector generalErrors_ = new Vector();
        private static final Object[] noMessageValues_ = new Object[0];

        public Core() {
            super(false);
        }

        private FieldError find_(Object name) {
            FieldError tmp = null;
            int i = this.fieldErrors_.size();
            while (--i >= 0) {
                tmp = (FieldError)this.fieldErrors_.elementAt(i);
                if (!tmp.name().equals(name)) continue;
                return tmp;
            }
            return null;
        }

        public Enumeration elements() {
            return this.allErrorMessages();
        }

        @Override
        public Enumeration allErrorMessages() {
            return new Enumeration(){
                private final Enumeration eg_;
                private final Enumeration ef_;
                {
                    this.eg_ = Core.this.generalErrorMessages();
                    this.ef_ = Core.this.fieldErrorMessages();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.ef_.hasMoreElements() || this.eg_.hasMoreElements();
                }

                public Object nextElement() {
                    if (this.eg_.hasMoreElements()) {
                        return this.eg_.nextElement();
                    }
                    return this.ef_.nextElement();
                }
            };
        }

        @Override
        public Enumeration allErrorMessages(Locale locale, CatalogNameModifier catalogNameModifier) {
            return new Enumeration(locale, catalogNameModifier){
                private final Enumeration eg_;
                private final Enumeration ef_;
                {
                    this.eg_ = Core.this.generalErrorMessages(locale, catalogNameModifier);
                    this.ef_ = Core.this.fieldErrorMessages(locale, catalogNameModifier);
                }

                @Override
                public boolean hasMoreElements() {
                    return this.ef_.hasMoreElements() || this.eg_.hasMoreElements();
                }

                public Object nextElement() {
                    if (this.eg_.hasMoreElements()) {
                        return this.eg_.nextElement();
                    }
                    return this.ef_.nextElement();
                }
            };
        }

        @Override
        public Enumeration fieldErrors() {
            return this.fieldErrors_.elements();
        }

        @Override
        public Enumeration fieldErrorMessages() {
            return new Enumeration(){
                private final Enumeration e_;
                {
                    this.e_ = Core.this.fieldErrors_.elements();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.e_.hasMoreElements();
                }

                public Object nextElement() {
                    return this.e_.nextElement().toString();
                }
            };
        }

        @Override
        public Enumeration fieldErrorMessages(final Locale locale, final CatalogNameModifier catalogNameModifier) {
            return new Enumeration(){
                private final Enumeration e_;
                {
                    this.e_ = Core.this.fieldErrors_.elements();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.e_.hasMoreElements();
                }

                public Object nextElement() {
                    return ((FieldError)this.e_.nextElement()).toString(locale, catalogNameModifier);
                }
            };
        }

        @Override
        public boolean hasFieldErrors() {
            return !this.fieldErrors_.isEmpty();
        }

        @Override
        public FieldError fieldError(String name) {
            return this.find_(name);
        }

        @Override
        public String get(String name) {
            FieldError error = this.find_(name);
            return error == null ? null : error.message();
        }

        @Override
        public Object get(Object name) {
            FieldError error = this.find_(name);
            return error == null ? null : error.message();
        }

        @Override
        public boolean isEmpty() {
            return this.fieldErrors_.isEmpty() && this.generalErrors_.isEmpty();
        }

        public Enumeration messages() {
            return this.generalErrors();
        }

        @Override
        public Enumeration generalErrors() {
            return this.generalErrors_.elements();
        }

        @Override
        public Enumeration generalErrorMessages() {
            return new Enumeration(){
                private final Enumeration e_;
                {
                    this.e_ = Core.this.generalErrors_.elements();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.e_.hasMoreElements();
                }

                public Object nextElement() {
                    return this.e_.nextElement().toString();
                }
            };
        }

        @Override
        public Enumeration generalErrorMessages(final Locale locale, final CatalogNameModifier catalogNameModifier) {
            return new Enumeration(){
                private final Enumeration e_;
                {
                    this.e_ = Core.this.generalErrors_.elements();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.e_.hasMoreElements();
                }

                public Object nextElement() {
                    return ((GeneralError)this.e_.nextElement()).message(locale, catalogNameModifier);
                }
            };
        }

        @Override
        public boolean hasGeneralErrors() {
            return !this.generalErrors_.isEmpty();
        }

        @Override
        public void put(String message) {
            this.generalErrors_.addElement(new GeneralError(message));
        }

        @Override
        public void put(Object value, String name, String label, String message) {
            if (name == null) {
                throw new IllegalArgumentException("UserErrors.put: name argument must not be null");
            }
            if (this.find_(name) == null) {
                this.fieldErrors_.addElement(new FieldError(value, name, label, message));
            }
        }

        @Override
        public void put(Object value, String name, String message) {
            if (name == null) {
                throw new IllegalArgumentException("UserErrors.put: name argument must not be null");
            }
            if (this.find_(name) == null) {
                this.fieldErrors_.addElement(new FieldError(value, name, name, message));
            }
        }

        @Override
        public void put(String messageCatalog, String messageKey, Object[] messageValues, String defaultMessage) {
            this.generalErrors_.addElement(new GeneralError(defaultMessage, messageCatalog, messageKey, messageValues));
        }

        @Override
        public void put(Object value, String name, String label, String messageCatalog, String messageKey, Object[] messageValues, String defaultMessage) {
            if (name == null) {
                throw new IllegalArgumentException("UserErrors.put: name argument must not be null");
            }
            if (messageValues == null) {
                messageValues = noMessageValues_;
            }
            if (this.find_(name) == null) {
                this.fieldErrors_.addElement(new FieldError(value, name, label, defaultMessage, messageCatalog, messageKey, messageValues));
            }
        }

        @Override
        public void put(Object value, String name, String messageCatalog, String messageKey, Object[] messageValues, String defaultMessage) {
            this.put(value, name, name, messageCatalog, messageKey, messageValues, defaultMessage);
        }

        @Override
        public int size() {
            return this.fieldErrors_.size() + this.generalErrors_.size();
        }

        @Override
        public void clear() {
            this.fieldErrors_.removeAllElements();
            this.generalErrors_.removeAllElements();
        }
    }

    public static final class FieldError {
        private final String name_;
        private final String label_;
        private final Object value_;
        private final String message_;
        private final String messageCatalog_;
        private final String messageKey_;
        private final Object[] messageValues_;

        public String name() {
            return this.name_;
        }

        public String label() {
            return this.label_;
        }

        public Object value() {
            return this.value_;
        }

        public String message() {
            return this.messageKey_ == null ? this.message_ : UserText.get(this.messageCatalog_, this.messageKey_, this.messageValues_, this.message_);
        }

        public String message(Locale locale, CatalogNameModifier catalogNameModifier) {
            return this.messageKey_ == null ? this.message_ : UserText.get(locale, catalogNameModifier.modifyName(this.messageCatalog_), this.messageKey_, this.messageValues_, this.message_);
        }

        public String messageCatalog() {
            return this.messageCatalog_;
        }

        public String messageKey() {
            return this.messageKey_;
        }

        public Object[] messageValues() {
            return this.messageValues_;
        }

        FieldError(Object value, String name, String label, String message) {
            this.value_ = value;
            this.name_ = name;
            this.label_ = label;
            this.message_ = message;
            this.messageCatalog_ = null;
            this.messageKey_ = null;
            this.messageValues_ = null;
        }

        FieldError(Object value, String name, String label, String message, String messageCatalog, String messageKey, Object[] messageValues) {
            this.value_ = value;
            this.name_ = name;
            this.label_ = label;
            this.messageCatalog_ = messageCatalog;
            this.message_ = message;
            this.messageKey_ = messageKey;
            this.messageValues_ = messageValues;
        }

        public String toString() {
            if (this.value_ == null) {
                return String.valueOf(this.label_) + ": " + this.message();
            }
            return String.valueOf(this.label_) + " ('" + this.value_ + "'): " + this.message();
        }

        public String toString(Locale locale, CatalogNameModifier catalogNameModifier) {
            if (this.value_ == null) {
                return String.valueOf(this.label_) + ": " + this.message(locale, catalogNameModifier);
            }
            return String.valueOf(this.label_) + " ('" + this.value_ + "'): " + this.message(locale, catalogNameModifier);
        }
    }

    public static interface FieldNameModifier {
        public String modifyName(String var1);

        public String modifyLabel(String var1);
    }

    public static final class GeneralError {
        private final String message_;
        private final String messageCatalog_;
        private final String messageKey_;
        private final Object[] messageValues_;

        public GeneralError(String message) {
            this.message_ = message;
            this.messageCatalog_ = null;
            this.messageKey_ = null;
            this.messageValues_ = null;
        }

        public GeneralError(String message, String messageCatalog, String messageKey, Object[] messageValues) {
            this.message_ = message;
            this.messageCatalog_ = messageCatalog;
            this.messageKey_ = messageKey;
            this.messageValues_ = messageValues;
        }

        public String message() {
            return this.messageKey_ == null ? this.message_ : UserText.get(this.messageCatalog_, this.messageKey_, this.messageValues_, this.message_);
        }

        public String message(Locale locale, CatalogNameModifier catalogNameModifier) {
            return this.messageKey_ == null ? this.message_ : UserText.get(locale, catalogNameModifier.modifyName(this.messageCatalog_), this.messageKey_, this.messageValues_, this.message_);
        }

        public String messageCatalog() {
            return this.messageCatalog_;
        }

        public String messageKey() {
            return this.messageKey_;
        }

        public Object[] messageValues() {
            return this.messageValues_;
        }

        public String toString() {
            return this.message();
        }
    }

    private static class ModifierDecorator
    extends UserErrors {
        FieldNameModifier modifier_;

        public ModifierDecorator(UserErrors adapted, FieldNameModifier modifier) {
            super(adapted);
            this.modifier_ = modifier;
        }

        @Override
        public FieldError fieldError(String name) {
            return super.fieldError(this.modifier_.modifyName(name));
        }

        @Override
        public String get(String name) {
            return super.get(this.modifier_.modifyName(name));
        }

        @Override
        public Object get(Object name) {
            return super.get(this.modifier_.modifyName(name.toString()));
        }

        @Override
        public void put(Object value, String name, String label, String message) {
            super.put(value, this.modifier_.modifyName(name), this.modifier_.modifyLabel(label), message);
        }

        @Override
        public void put(Object value, String name, String message) {
            super.put(value, this.modifier_.modifyName(name), this.modifier_.modifyLabel(name), message);
        }

        @Override
        public void put(Object value, String name, String label, String messageKey, Object[] messageValues, String defaultMessage) {
            super.put(value, this.modifier_.modifyName(name), this.modifier_.modifyLabel(label), messageKey, messageValues, defaultMessage);
        }

        public void put(Object value, String name, String messageKey, Object[] messageValues, String defaultMessage) {
            super.put(value, this.modifier_.modifyName(name), this.modifier_.modifyLabel(name), messageKey, messageValues, defaultMessage);
        }
    }
}

