/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.maint.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface Task {
    public void start();

    public void stop();

    public Status getStatus();

    public int getPendingCount();

    public long getProcessedCount();

    public String getStackTrace();

    public Throwable getException();

    public static class Status
    implements Serializable {
        public final transient int ordinal;
        public final String name;
        public static final Status stopped = new Status("stopped", 0);
        public static final Status scheduled = new Status("scheduled", 1);
        public static final Status running = new Status("running", 2);
        public static final List VALUES = Collections.unmodifiableList(Arrays.asList(stopped, scheduled, running));

        protected Status(String n, int o) {
            this.name = n;
            this.ordinal = o;
        }

        public List family() {
            return VALUES;
        }

        public final boolean equals(Object o) {
            return this == o;
        }

        public final int hashCode() {
            return this.ordinal;
        }

        public String toString() {
            return this.name;
        }

        public final int compareTo(Status o) {
            return this.ordinal - o.ordinal;
        }

        protected final Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException("enums cannot be cloned.");
        }

        protected final Object readResolve() throws ObjectStreamException {
            return Status.valueOf(this.name);
        }

        public static Status valueOf(String name) {
            int i = 0;
            while (i < VALUES.size()) {
                Status state = (Status)VALUES.get(i);
                if (state.name.equals(name)) {
                    return state;
                }
                ++i;
            }
            throw new IllegalArgumentException("No constant with the specified name: " + name);
        }
    }
}

