/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.maint.util;

import gov.va.med.person.idmgmt.maint.util.FieldAccessor;
import gov.va.med.person.idmgmt.util.PSIMSettings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;

public class ObjectFormatter {
    protected int maxRecursion_ = 20;
    protected int maxRows_ = 20;
    protected int indent_ = 3;
    protected char[] spaces_;
    protected boolean suppressNulls = false;
    private final Formatter[] formatters_ = new Formatter[]{new ClassFormatter(), new StringFormatter(), new TimeFormatter(), new PrimitiveTypeFormatter(), new PrimitiveArrayFormatter(), new ObjectArrayFormatter(), new CollectionFormatter(), new MapFormatter(), new InstanceFormatter()};
    private static ObjectFormatter formatter_ = new ObjectFormatter();

    public ObjectFormatter() {
        this.spaces_ = new char[this.maxRecursion_ * this.indent_];
        Arrays.fill(this.spaces_, ' ');
    }

    public String format(Object value) {
        StringWriter writer = new StringWriter();
        Vector visited = new Vector();
        this.applyFormatters(value, new PrintWriter(writer), 1, visited);
        return writer.toString();
    }

    public void format(Object value, PrintWriter writer) {
        Vector visited = new Vector();
        this.applyFormatters(value, writer, 1, visited);
    }

    protected void applyFormatters(Object value, PrintWriter writer, int level, Vector visited) {
        if (level > this.maxRecursion_) {
            writer.println("...");
        } else if (value == null) {
            writer.println(value);
        } else if (visited.contains(value)) {
            writer.println(ObjectFormatter.uniqueIdentifier(value));
        } else {
            boolean processed = false;
            int i = 0;
            while (i < this.formatters_.length && !processed) {
                Formatter formatter = this.formatters_[i];
                processed = formatter.format(value, writer, level, visited);
                ++i;
            }
            if (!processed) {
                writer.println("****" + value + "****");
            }
        }
    }

    public static String uniqueIdentifier(Object value) {
        StringBuffer buffer = new StringBuffer();
        Class<?> type = value.getClass();
        if (type.isArray()) {
            int dimensions;
            String name = type.getName();
            String typeCode = name.substring(dimensions = name.lastIndexOf(91) - name.indexOf(91) + 1, dimensions + 1);
            if ("B".equals(typeCode)) {
                buffer.append("byte");
            } else if ("C".equals(typeCode)) {
                buffer.append("char");
            } else if ("D".equals(typeCode)) {
                buffer.append("double");
            } else if ("F".equals(typeCode)) {
                buffer.append("float");
            } else if ("I".equals(typeCode)) {
                buffer.append("int");
            } else if ("J".equals(typeCode)) {
                buffer.append("long");
            } else if ("L".equals(typeCode)) {
                buffer.append(name.substring(dimensions + 1, name.length() - 1));
            } else if ("S".equals(typeCode)) {
                buffer.append("short");
            } else if ("Z".equals(typeCode)) {
                buffer.append("boolean");
            }
            int i = 0;
            while (i < dimensions) {
                if (i == 0) {
                    buffer.append('[');
                    buffer.append(Array.getLength(value));
                    buffer.append(']');
                } else {
                    buffer.append("[]");
                }
                ++i;
            }
        } else {
            buffer.append(type.getName());
        }
        buffer.append('@');
        buffer.append(Integer.toHexString(System.identityHashCode(value)));
        return buffer.toString();
    }

    public static synchronized ObjectFormatter instance() {
        return formatter_;
    }

    public static synchronized void instance(ObjectFormatter formatter) {
        formatter_ = formatter;
    }

    private class ClassFormatter
    implements Formatter {
        private ClassFormatter() {
        }

        @Override
        public boolean format(Object value, PrintWriter writer, int level, Vector visited) {
            boolean processed = false;
            if (value instanceof Class) {
                writer.println(((Class)value).getName());
                processed = true;
            }
            return processed;
        }
    }

    private class CollectionFormatter
    implements Formatter {
        private CollectionFormatter() {
        }

        @Override
        public boolean format(Object value, PrintWriter writer, int level, Vector visited) {
            boolean processed = false;
            if (value instanceof Collection) {
                visited.add(value);
                Collection values = (Collection)value;
                writer.print(ObjectFormatter.uniqueIdentifier(values));
                writer.print("{size=");
                writer.print(values.size());
                writer.println("}");
                int max = Math.min(values.size(), ObjectFormatter.this.maxRows_);
                int index = 0;
                Iterator i = values.iterator();
                while (i.hasNext() && index < max) {
                    Object v = i.next();
                    if (v == null && ObjectFormatter.this.suppressNulls) continue;
                    writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                    writer.print("[");
                    writer.print(index++);
                    writer.print("]=");
                    ObjectFormatter.this.applyFormatters(v, writer, level + 1, visited);
                }
                if (values.size() > ObjectFormatter.this.maxRows_) {
                    writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                    writer.print("[");
                    writer.print(ObjectFormatter.this.maxRows_);
                    writer.println("]: ...");
                }
                processed = true;
            }
            return processed;
        }
    }

    public static interface Formatter {
        public boolean format(Object var1, PrintWriter var2, int var3, Vector var4);
    }

    private class InstanceFormatter
    implements Formatter {
        private final List rules_ = new Vector();
        private final Map fields_ = new HashMap();

        public InstanceFormatter() {
            Properties defaults = new Properties();
            defaults.setProperty("java.lang.reflect.Method", "clazz,name");
            defaults.setProperty("java.text.SimpleDateFormat", "pattern");
            defaults.setProperty("org.apache.log4j.Logger", "-*");
            defaults.setProperty("java.util.regex.Pattern", "pattern,flags");
            defaults.setProperty("ca.uhn.hl7v2.parser.GenericParser", "-*");
            defaults.setProperty("gov.va.med.term.access.maint.messaging.hl7.*Action", "ordinal,name");
            defaults.setProperty("gov.va.med.term.access.maint.messaging.hl7.Encoding", "ordinal,name");
            defaults.setProperty("gov.va.med.term.access.maint.messaging.Application", "-topics_");
            defaults.setProperty("gov.va.med.term.access.maint.messaging.Topic", "-applications_");
            defaults.setProperty("gov.va.med.term.access.maint.validation.ObjectValidator", "-*");
            Properties overrides = PSIMSettings.getInstance().getPropertiesFor(ObjectFormatter.class);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)defaults);
            properties.putAll((Map<?, ?>)overrides);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.rules_.add(Rule.parse(key, value));
            }
        }

        private synchronized Field[] getFields(Class type) {
            String typeName = type.getName();
            Field[] fields = (Field[])this.fields_.get(typeName);
            if (fields == null) {
                Rule rule = null;
                for (Rule candidateRule : this.rules_) {
                    if (!candidateRule.matchesClass(typeName)) continue;
                    rule = candidateRule;
                    break;
                }
                Vector<Field> filteredFields = new Vector<Field>();
                Class current = type;
                while (current != null) {
                    Field[] declaredFields = current.getDeclaredFields();
                    int i = 0;
                    while (i < declaredFields.length) {
                        Field field = declaredFields[i];
                        if (rule == null || rule.matchesField(field.getName())) {
                            filteredFields.add(field);
                        }
                        ++i;
                    }
                    current = current.getSuperclass();
                }
                fields = filteredFields.toArray(new Field[filteredFields.size()]);
                this.fields_.put(type, fields);
            }
            return fields;
        }

        @Override
        public boolean format(Object value, PrintWriter writer, int level, Vector visited) {
            boolean processed = false;
            if (value instanceof Object) {
                visited.add(value);
                writer.println(ObjectFormatter.uniqueIdentifier(value));
                Class<?> type = value.getClass();
                Field[] fields = this.getFields(type);
                int i = 0;
                while (i < fields.length) {
                    Field field = fields[i];
                    writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                    writer.print(field.getName());
                    writer.print("=");
                    Class<?> fieldType = field.getType();
                    try {
                        if (fieldType == Boolean.TYPE) {
                            writer.println(FieldAccessor.getBoolean(value, field.getName()));
                        } else if (fieldType == Character.TYPE) {
                            writer.println(FieldAccessor.getChar(value, field.getName()));
                        } else if (fieldType == Byte.TYPE) {
                            writer.println(FieldAccessor.getByte(value, field.getName()));
                        } else if (fieldType == Short.TYPE) {
                            writer.println(FieldAccessor.getShort(value, field.getName()));
                        } else if (fieldType == Integer.TYPE) {
                            writer.println(FieldAccessor.getInt(value, field.getName()));
                        } else if (fieldType == Long.TYPE) {
                            writer.println(FieldAccessor.getLong(value, field.getName()));
                        } else if (fieldType == Float.TYPE) {
                            writer.println(FieldAccessor.getFloat(value, field.getName()));
                        } else if (fieldType == Double.TYPE) {
                            writer.println(FieldAccessor.getDouble(value, field.getName()));
                        } else {
                            Object fieldValue = FieldAccessor.get(value, field.getName());
                            ObjectFormatter.this.applyFormatters(fieldValue, writer, level + 1, visited);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(writer);
                    }
                    ++i;
                }
                processed = true;
            }
            return processed;
        }
    }

    private class MapFormatter
    implements Formatter {
        private MapFormatter() {
        }

        @Override
        public boolean format(Object value, PrintWriter writer, int level, Vector visited) {
            boolean processed = false;
            if (value instanceof Map) {
                visited.add(value);
                Map values = (Map)value;
                writer.print(ObjectFormatter.uniqueIdentifier(values));
                writer.print("{size=");
                writer.print(values.size());
                writer.println("}");
                int max = Math.min(values.size(), ObjectFormatter.this.maxRows_);
                int index = 0;
                Iterator i = values.entrySet().iterator();
                while (i.hasNext() && index < max) {
                    Map.Entry entry = i.next();
                    writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                    writer.print("key[");
                    writer.print(index);
                    writer.print("]: ");
                    ObjectFormatter.this.applyFormatters(entry.getKey(), writer, level + 1, visited);
                    writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                    writer.print("value[");
                    writer.print(index);
                    writer.print("]: ");
                    ObjectFormatter.this.applyFormatters(entry.getValue(), writer, level + 1, visited);
                    ++index;
                }
                if (values.size() > ObjectFormatter.this.maxRows_) {
                    writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                    writer.print("[");
                    writer.print(ObjectFormatter.this.maxRows_);
                    writer.println("]: ...");
                }
                processed = true;
            }
            return processed;
        }
    }

    private class ObjectArrayFormatter
    implements Formatter {
        private ObjectArrayFormatter() {
        }

        @Override
        public boolean format(Object value, PrintWriter writer, int level, Vector visited) {
            boolean processed = false;
            if (value != null && value.getClass().isArray() && !value.getClass().getComponentType().isPrimitive()) {
                visited.add(value);
                int length = Array.getLength(value);
                writer.println(ObjectFormatter.uniqueIdentifier(value));
                int max = Math.min(length, ObjectFormatter.this.maxRows_);
                int i = 0;
                while (i < max) {
                    Object element = Array.get(value, i);
                    if (element != null || !ObjectFormatter.this.suppressNulls) {
                        writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                        writer.print("[");
                        writer.print(i);
                        writer.print("]=");
                        ObjectFormatter.this.applyFormatters(Array.get(value, i), writer, level + 1, visited);
                    }
                    ++i;
                }
                if (length > ObjectFormatter.this.maxRows_) {
                    writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                    writer.print("[");
                    writer.print(ObjectFormatter.this.maxRows_);
                    writer.println("]: ...");
                }
                processed = true;
            }
            return processed;
        }
    }

    private class PrimitiveArrayFormatter
    implements Formatter {
        private PrimitiveArrayFormatter() {
        }

        @Override
        public boolean format(Object value, PrintWriter writer, int level, Vector visited) {
            boolean processed = false;
            if (value != null && value.getClass().isArray() && value.getClass().getComponentType().isPrimitive()) {
                visited.add(value);
                Class<?> componentType = value.getClass().getComponentType();
                int length = Array.getLength(value);
                writer.println(ObjectFormatter.uniqueIdentifier(value));
                int max = Math.min(length, ObjectFormatter.this.maxRows_);
                if (componentType == Boolean.TYPE) {
                    int i = 0;
                    while (i < max) {
                        writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                        writer.print("[");
                        writer.print(i);
                        writer.print("]=");
                        writer.println(Array.getBoolean(value, i));
                        ++i;
                    }
                } else if (componentType == Character.TYPE) {
                    int i = 0;
                    while (i < max) {
                        writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                        writer.print("[");
                        writer.print(i);
                        writer.print("]=");
                        writer.println(Array.getChar(value, i));
                        ++i;
                    }
                } else if (componentType == Byte.TYPE) {
                    int i = 0;
                    while (i < max) {
                        writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                        writer.print("[");
                        writer.print(i);
                        writer.print("]=");
                        writer.println(Array.getByte(value, i));
                        ++i;
                    }
                } else if (componentType == Short.TYPE) {
                    int i = 0;
                    while (i < max) {
                        writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                        writer.print("[");
                        writer.print(i);
                        writer.print("]=");
                        writer.println(Array.getShort(value, i));
                        ++i;
                    }
                } else if (componentType == Integer.TYPE) {
                    int i = 0;
                    while (i < max) {
                        writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                        writer.print("[");
                        writer.print(i);
                        writer.print("]=");
                        writer.println(Array.getInt(value, i));
                        ++i;
                    }
                } else if (componentType == Long.TYPE) {
                    int i = 0;
                    while (i < max) {
                        writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                        writer.print("[");
                        writer.print(i);
                        writer.print("]=");
                        writer.println(Array.getLong(value, i));
                        ++i;
                    }
                } else if (componentType == Float.TYPE) {
                    int i = 0;
                    while (i < max) {
                        writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                        writer.print("[");
                        writer.print(i);
                        writer.print("]=");
                        writer.println(Array.getFloat(value, i));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < max) {
                        writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                        writer.print("[");
                        writer.print(i);
                        writer.print("]=");
                        writer.println(Array.getDouble(value, i));
                        ++i;
                    }
                }
                if (length > ObjectFormatter.this.maxRows_) {
                    writer.write(ObjectFormatter.this.spaces_, 0, level * ObjectFormatter.this.indent_);
                    writer.print("[");
                    writer.print(ObjectFormatter.this.maxRows_);
                    writer.println("]: ...");
                }
                processed = true;
            }
            return processed;
        }
    }

    private class PrimitiveTypeFormatter
    implements Formatter {
        private PrimitiveTypeFormatter() {
        }

        @Override
        public boolean format(Object value, PrintWriter writer, int level, Vector visited) {
            boolean processed = false;
            if (value instanceof Boolean || value instanceof Character || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
                writer.print(ObjectFormatter.uniqueIdentifier(value));
                writer.print("{value=");
                writer.print(value);
                writer.println("}");
                processed = true;
            }
            return processed;
        }
    }

    private static class Rule {
        private static String classNamePattern_;
        private static String[] fieldNamePatterns_;
        private static boolean include_;
        private static final Pattern wildcardPattern;

        static {
            wildcardPattern = Pattern.compile("[a-zA-Z0-9_$.*]+");
        }

        Rule(String classNamePattern, String[] fieldNamePatterns, boolean include) {
            classNamePattern_ = classNamePattern;
            fieldNamePatterns_ = fieldNamePatterns;
            include_ = include;
        }

        public boolean matchesClass(String classname) {
            return Pattern.matches(classNamePattern_, classname);
        }

        public boolean matchesField(String fieldName) {
            int i = 0;
            while (i < fieldNamePatterns_.length) {
                if (Pattern.matches(fieldNamePatterns_[i], fieldName)) {
                    return include_;
                }
                ++i;
            }
            return !include_;
        }

        public static Rule parse(String lhs, String rhs) {
            if (wildcardPattern.matcher(lhs).matches()) {
                lhs = lhs.replaceAll("\\.", "\\\\.");
                lhs = lhs.replaceAll("\\$", "\\\\\\$");
                lhs = lhs.replaceAll("\\*", "(.+)");
            }
            boolean include = true;
            if (rhs.charAt(0) == '-') {
                include = false;
                rhs = rhs.substring(1);
            }
            String[] parts = rhs.split(",");
            int i = 0;
            while (i < parts.length) {
                String pattern = parts[i];
                if (wildcardPattern.matcher(pattern).matches()) {
                    pattern = pattern.replaceAll("\\.", "\\\\.");
                    pattern = pattern.replaceAll("\\$", "\\\\\\$");
                    parts[i] = pattern = pattern.replaceAll("\\*", "(.+)");
                }
                ++i;
            }
            return new Rule(lhs, parts, include);
        }

        public static Rule find(String classname, List rules) {
            for (Rule rule : rules) {
                if (!rule.matchesClass(classname)) continue;
                return rule;
            }
            return null;
        }
    }

    private class StringFormatter
    implements Formatter {
        private StringFormatter() {
        }

        @Override
        public boolean format(Object value, PrintWriter writer, int level, Vector visited) {
            boolean processed = false;
            if (value instanceof String) {
                writer.print("\"");
                writer.print(value);
                writer.println("\"");
                processed = true;
            }
            return processed;
        }
    }

    private class TimeFormatter
    implements Formatter {
        private TimeFormatter() {
        }

        @Override
        public boolean format(Object value, PrintWriter writer, int level, Vector visited) {
            boolean processed = false;
            if (value instanceof java.util.Date || value instanceof Date || value instanceof Time || value instanceof Timestamp) {
                writer.print(ObjectFormatter.uniqueIdentifier(value));
                writer.print("{toString=");
                writer.print(value);
                writer.println("}");
                processed = true;
            }
            return processed;
        }
    }
}

