/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.maint.util;

import gov.va.med.person.idmgmt.db.PSDaoFactory;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import gov.va.med.person.idmgmt.maint.util.Transaction;
import net.sf.hibernate.HibernateException;
import org.apache.log4j.Logger;

public class HbTransaction
implements Transaction {
    private static final Logger logger = Logger.getLogger(HbTransaction.class);

    public HbTransaction() {
        try {
            PSDaoFactory.instance();
            HBSessionFactory.beginTransaction();
        }
        catch (HibernateException e) {
            logger.error((Object)"HibernateException caught!", (Throwable)e);
            throw new RuntimeException("Failed to begin transaction!", e);
        }
    }

    @Override
    public void commit() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"commit() - start");
        }
        try {
            HBSessionFactory.commitTransaction();
            HBSessionFactory.closeSession();
        }
        catch (HibernateException e) {
            logger.error((Object)"HibernateException caught!", (Throwable)e);
            throw new RuntimeException("commit failed!", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"commit() - end");
        }
    }

    @Override
    public void rollback() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"rollback() - start");
        }
        HBSessionFactory.rollbackAndClose();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"rollback() - end");
        }
    }

    @Override
    public boolean wasRolledBack() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"wasRolledBack() - start");
        }
        try {
            boolean returnboolean = HBSessionFactory.wasRolledBack();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"wasRolledBack() - end");
            }
            return returnboolean;
        }
        catch (HibernateException e) {
            logger.error((Object)"HibernateException caught!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean wasCommitted() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"wasCommitted() - start");
        }
        try {
            boolean returnboolean = HBSessionFactory.wasCommitted();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"wasCommitted() - end");
            }
            return returnboolean;
        }
        catch (HibernateException e) {
            logger.error((Object)"HibernateException caught!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static class Factory
    implements Transaction.Factory {
        private static final Logger logger = Logger.getLogger(Factory.class);

        @Override
        public Transaction create() {
            logger.warn((Object)"This class should not be used for production!");
            return new HbTransaction();
        }
    }
}

