/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.maint.messaging.hl7.factory;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.GenericParser;
import gov.va.med.person.idmgmt.maint.conversion.StringConverter;
import gov.va.med.person.idmgmt.maint.messaging.hl7.Encoding;
import gov.va.med.person.idmgmt.maint.messaging.hl7.MediaType;
import gov.va.med.person.idmgmt.maint.messaging.hl7.MessageDispatcher;
import gov.va.med.person.idmgmt.util.PSIMSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;

public class BusinessWareMessageDispatcher
implements MessageDispatcher {
    private static final Logger logger_ = Logger.getLogger(BusinessWareMessageDispatcher.class);
    protected static final Logger hl7OutboundLogger = Logger.getLogger((String)"hl7out");
    private static final URL url_ = BusinessWareMessageDispatcher.initializeURL();
    private static final Encoding encoding_ = Encoding.valueOf(PSIMSettings.getInstance().getValue(BusinessWareMessageDispatcher.class, "encoding"));
    private static final GenericParser parser_ = new GenericParser();

    private static URL initializeURL() {
        try {
            return (URL)StringConverter.fromString(PSIMSettings.getInstance().getValue(BusinessWareMessageDispatcher.class, "url"), URL.class);
        }
        catch (StringConverter.FormatException e) {
            String msg = "Error initializing URL.";
            logger_.error((Object)"Error initializing URL.", (Throwable)e);
            throw new RuntimeException("Error initializing URL.", e);
        }
    }

    @Override
    public void send(Message message) {
        HttpURLConnection connection = null;
        try {
            try {
                if (hl7OutboundLogger.isDebugEnabled()) {
                    hl7OutboundLogger.debug((Object)"Requesting HTTP connection.");
                }
                connection = (HttpURLConnection)url_.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                connection.setRequestProperty("Content-Type", String.valueOf(encoding_ == Encoding.xml ? MediaType.xml.name : MediaType.er7.name) + "; charset=UTF-8");
                String encodedMessage = parser_.encode(message, encoding_.toString());
                OutputStreamWriter output = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
                output.write(11);
                output.write(encodedMessage);
                if (hl7OutboundLogger.isDebugEnabled()) {
                    hl7OutboundLogger.debug((Object)"Message put into outpout stream.");
                }
                output.write(28);
                output.write(13);
                output.close();
                if (hl7OutboundLogger.isDebugEnabled()) {
                    hl7OutboundLogger.debug((Object)("Message sent: " + encodedMessage));
                }
                if (connection.getResponseCode() != 200) {
                    String error = this.inputStreamToString(connection.getErrorStream());
                    String msg = "Error sending message (" + connection.getResponseCode() + "): message (" + connection.getResponseMessage() + "), error stream (" + error + ")";
                    hl7OutboundLogger.error((Object)("Unsuccessful Outbound message Error: " + error + "  Message: " + encodedMessage));
                    logger_.error((Object)msg);
                    throw new RuntimeException(msg);
                }
                hl7OutboundLogger.warn((Object)("Successful Outbound message: " + encodedMessage));
            }
            catch (Exception e) {
                String msg = "Error sending message.";
                hl7OutboundLogger.error((Object)"Unsuccessful Outbound message ", (Throwable)e);
                logger_.error((Object)"Error sending message.", (Throwable)e);
                throw new RuntimeException("Error sending message.", e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                if (hl7OutboundLogger.isDebugEnabled()) {
                    hl7OutboundLogger.debug((Object)"Connection closed");
                }
            }
        }
    }

    private String inputStreamToString(InputStream stream) throws IOException {
        String line;
        if (stream == null) {
            return "";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
        writer.close();
        buffer.close();
        reader.close();
        return buffer.toString();
    }
}

