/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.maint.event;

import gov.va.med.person.idmgmt.db.PSDaoFactory;
import gov.va.med.person.idmgmt.db.hb.AuditInfo;
import gov.va.med.person.idmgmt.maint.event.Queue;
import gov.va.med.person.idmgmt.util.IConstants;
import gov.va.med.term.access.util.Is;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class Event
implements Serializable,
Comparable {
    private static final long serialVersionUID = 8506080790069993086L;
    private static final Logger logger = Logger.getLogger(Event.class);
    private AuditInfo auditInfo;
    private Serializable data;
    private Integer id;
    private Byte pending = IConstants.ONE;
    private Queue queue;
    private Integer version;

    public static Event obtain(Integer id) {
        return PSDaoFactory.instance().getEventDAO().obtainById(id);
    }

    public static Event[] obtain(Queue queue, int max, String fromPKId) {
        return PSDaoFactory.instance().getEventDAO().obtain(queue, max, fromPKId, false);
    }

    public static Event[] obtain(Queue queue, int max, boolean isDescendingOrder) {
        return PSDaoFactory.instance().getEventDAO().obtain(queue, max, null, isDescendingOrder);
    }

    public static Event[] obtain(Queue queue, int max) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"*** Event.obtain(queue, max) entered.");
        }
        return PSDaoFactory.instance().getEventDAO().obtain(queue, max);
    }

    public static int count(Queue queue) {
        return PSDaoFactory.instance().getEventDAO().count(queue);
    }

    public Event() {
    }

    public Event(Serializable data) {
        this.data = data;
    }

    public int compareTo(Object o) {
        int id2;
        Event e = (Event)o;
        int id1 = this.getId() != null ? this.getId() : 0;
        int n = id2 = e.getId() != null ? e.getId() : 0;
        return id1 < id2 ? -1 : (id1 == id2 ? 0 : 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event other = (Event)o;
        if (!Is.equal((Object)this.id, (Object)other.id)) {
            return false;
        }
        if (!Is.equal((Object)this.queue, (Object)this.queue)) {
            return false;
        }
        if (!Is.equal((Object)this.pending, (Object)other.pending)) {
            return false;
        }
        return Is.equal((Object)this.data, (Object)other.data);
    }

    public AuditInfo getAuditInfo() {
        return this.auditInfo;
    }

    public Serializable getData() {
        return this.data;
    }

    public Integer getId() {
        return this.id;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public Integer getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean isNew() {
        return this.getId() == null;
    }

    public boolean isPending() {
        return IConstants.ONE.equals(this.pending);
    }

    public void setAuditInfo(AuditInfo auditInfo) {
        this.auditInfo = auditInfo;
    }

    public void setData(Serializable data) {
        this.data = data;
    }

    protected void setId(Integer value) {
        if (value != null && value < 0) {
            throw new IllegalArgumentException("The identifier for events cannot be negative.");
        }
        this.id = value;
    }

    public void setPending(boolean isPending) {
        this.pending = isPending ? IConstants.ONE : IConstants.ZERO;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    protected void setVersion(Integer version) {
        this.version = version;
    }

    public void update() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)" ***Event.update() entered.");
        }
        PSDaoFactory.instance().getEventDAO().update(this);
    }

    public void delete() {
        PSDaoFactory.instance().getEventDAO().delete(this);
    }

    public static Event obtainFromKeyString(String key) {
        return Event.obtain(Integer.valueOf(key));
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[id=" + this.id + ", pending=" + this.isPending() + ", queue=" + (this.queue != null ? this.queue.getName() : null) + "]";
    }
}

