/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.maint.conversion;

import gov.va.med.person.idmgmt.maint.util.UserErrors;
import gov.va.med.term.access.util.ThreadLocale;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringConverter {
    private static Hashtable cache_ = new Hashtable();

    private static synchronized ConversionMethod conversionMethodFor(Class datatype) {
        ConversionMethod result = (ConversionMethod)cache_.get(datatype);
        if (result == null) {
            result = ConversionMethod.conversionMethodFor(datatype);
            cache_.put(datatype, result);
        }
        return result;
    }

    public static Object fromString(String from, Class datatype, String fieldName, UserErrors errors) {
        if (from == null || from.length() == 0) {
            return null;
        }
        ConversionMethod conversionMethod = StringConverter.conversionMethodFor(datatype);
        return conversionMethod.fromString(from, fieldName, errors);
    }

    public static Object fromString(String from, Class datatype) throws FormatException {
        if (from == null || from.length() == 0) {
            return null;
        }
        ConversionMethod conversionMethod = StringConverter.conversionMethodFor(datatype);
        return conversionMethod.fromString(from);
    }

    public static boolean canConvert(Class datatype) {
        ConversionMethod conversionMethod = null;
        try {
            conversionMethod = StringConverter.conversionMethodFor(datatype);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return conversionMethod != null;
    }

    private static abstract class ConversionMethod {
        private static final Class[] parameterTypes_ = new Class[]{String.class};
        private final Class datatype_;
        private final String datatypeName_;

        static ConversionMethod conversionMethodFor(Class datatype) {
            ConversionMethod result = null;
            result = datatype.isInterface() ? ConversionMethod.initFromInterface(datatype) : ConversionMethod.initFromClass(datatype);
            if (result == null) {
                throw new ConversionNotSupportedException("No obvious way to obtain a " + datatype.getName() + " from a String");
            }
            return result;
        }

        private static Class getWrapperClass(Class primitiveClass) {
            if (Boolean.TYPE.equals(primitiveClass)) {
                return Boolean.class;
            }
            if (Byte.TYPE.equals(primitiveClass)) {
                return Byte.class;
            }
            if (Character.TYPE.equals(primitiveClass)) {
                return Character.class;
            }
            if (Short.TYPE.equals(primitiveClass)) {
                return Short.class;
            }
            if (Integer.TYPE.equals(primitiveClass)) {
                return Integer.class;
            }
            if (Long.TYPE.equals(primitiveClass)) {
                return Long.class;
            }
            if (Float.TYPE.equals(primitiveClass)) {
                return Float.class;
            }
            if (Double.TYPE.equals(primitiveClass)) {
                return Double.class;
            }
            throw new IllegalArgumentException("Class must represent a primitive type: " + primitiveClass.getName());
        }

        private static ConversionMethod initFromClass(Class datatype) {
            try {
                Method method;
                if (datatype.isPrimitive()) {
                    datatype = ConversionMethod.getWrapperClass(datatype);
                }
                if (Modifier.isStatic((method = datatype.getMethod("valueOf", parameterTypes_)).getModifiers())) {
                    return new ConversionMethodStaticMethod(datatype, method);
                }
            }
            catch (Exception method) {
                // empty catch block
            }
            try {
                Constructor ctor = datatype.getConstructor(parameterTypes_);
                return new ConversionMethodConstructor(datatype, ctor);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static ConversionMethod initFromInterface(Class datatype) {
            try {
                Field fFactory = datatype.getField("factory");
                Class<?> cFactory = fFactory.getType();
                Method method = cFactory.getMethod("obtainFromKeyString", parameterTypes_);
                Object factory = fFactory.get(null);
                return new ConversionMethodFactory(datatype, method, factory);
            }
            catch (Exception exception) {
                return null;
            }
        }

        protected ConversionMethod(Class datatype) {
            this.datatype_ = datatype;
            this.datatypeName_ = datatype.getName();
        }

        protected String message() {
            ResourceBundle bundle2;
            String result = null;
            Locale locale = ThreadLocale.get();
            try {
                bundle2 = ResourceBundle.getBundle("gov.va.med.term.access.maint.conversion.messages", locale);
                result = bundle2.getString(this.datatypeName_);
            }
            catch (MissingResourceException bundle2) {
                // empty catch block
            }
            if (result == null) {
                try {
                    bundle2 = ResourceBundle.getBundle(String.valueOf(ConversionMethod.packagePrefix(this.datatypeName_)) + ".messages", locale);
                    result = bundle2.getString(this.datatypeName_);
                }
                catch (MissingResourceException bundle3) {
                    // empty catch block
                }
            }
            if (result == null) {
                try {
                    bundle2 = ResourceBundle.getBundle("gov.va.med.term.access.maint.conversion.messages", locale);
                    result = bundle2.getString("default");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return result == null ? "Invalid value." : result;
        }

        private static String packagePrefix(String className) {
            int p = className.lastIndexOf(46);
            className = p >= 0 ? className.substring(0, p) : null;
            return className;
        }

        Object fromString(String inputValue, String fieldName, UserErrors errors) {
            try {
                return this.convert(inputValue);
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (InvocationTargetException x) {
                errors.put(inputValue, fieldName, this.message());
                return null;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }

        Object fromString(String inputValue) throws FormatException {
            try {
                return this.convert(inputValue);
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (InvocationTargetException x) {
                if (x.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)x.getTargetException();
                }
                throw new FormatException(this.message());
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }

        protected abstract Object convert(String var1) throws Exception;
    }

    private static class ConversionMethodConstructor
    extends ConversionMethod {
        private final Constructor constructor_;

        public ConversionMethodConstructor(Class datatype, Constructor constructor) {
            super(datatype);
            this.constructor_ = constructor;
        }

        @Override
        protected Object convert(String inputValue) throws Exception {
            Object[] arguments = new Object[]{inputValue};
            return this.constructor_.newInstance(arguments);
        }
    }

    private static class ConversionMethodFactory
    extends ConversionMethod {
        private final Method converter_;
        private final Object factory_;

        public ConversionMethodFactory(Class datatype, Method converter, Object factory) {
            super(datatype);
            this.converter_ = converter;
            this.factory_ = factory;
        }

        @Override
        protected Object convert(String inputValue) throws Exception {
            Object[] arguments = new Object[]{inputValue};
            return this.converter_.invoke(this.factory_, arguments);
        }
    }

    private static class ConversionMethodStaticMethod
    extends ConversionMethod {
        private final Method converter_;

        public ConversionMethodStaticMethod(Class datatype, Method converter) {
            super(datatype);
            this.converter_ = converter;
        }

        @Override
        protected Object convert(String inputValue) throws Exception {
            Object[] arguments = new Object[]{inputValue};
            return this.converter_.invoke(null, arguments);
        }
    }

    public static class ConversionNotSupportedException
    extends RuntimeException {
        public ConversionNotSupportedException(String message) {
            super(message);
        }
    }

    public static class FormatException
    extends Exception {
        public FormatException(String message) {
            super(message);
        }
    }
}

