/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.hibernate;

import gov.va.med.person.idmgmt.hibernate.CmtTableHiLoGenerator;
import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.Configurable;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.id.IdentityGenerator;
import net.sf.hibernate.id.SequenceGenerator;
import net.sf.hibernate.id.TableHiLoGenerator;
import net.sf.hibernate.type.Type;
import org.apache.log4j.Logger;

public class PSIdentifierGenerator
implements IdentifierGenerator,
Configurable {
    private static final Logger logger = Logger.getLogger(PSIdentifierGenerator.class);
    private IdentifierGenerator delegate;

    public PSIdentifierGenerator() {
        logger.debug((Object)"PSIdentifierGenerator <init>");
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        if (logger.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            out.println("configure(Type, Properties, Dialect) - start");
            out.println("type: " + type);
            out.println("params:" + params);
            out.println("dialect:" + dialect);
            out.println("TRANSACTION_STRATEGY: " + HBSessionFactory.getConfiguration().getProperties().getProperty("hibernate.transaction.factory_class"));
            out.close();
            logger.debug((Object)sw);
        }
        if (dialect.supportsIdentityColumns()) {
            this.delegate = new IdentityGenerator();
        }
        this.delegate = dialect.supportsSequences() ? new SequenceGenerator() : (HBSessionFactory.isContainerManagedTransactions() ? new CmtTableHiLoGenerator() : new TableHiLoGenerator());
        if (this.delegate instanceof Configurable) {
            ((Configurable)this.delegate).configure(type, params, dialect);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("configure(Type, Properties, Dialect) - end\nCreated delegate: " + this.delegate));
        }
    }

    public Serializable generate(SessionImplementor session, Object object) throws SQLException, HibernateException {
        Serializable id = this.delegate.generate(session, object);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("generated id = " + id));
        }
        return id;
    }
}

