/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.hibernate;

import com.opensymphony.oscache.base.Config;
import gov.va.med.person.idmgmt.hibernate.OSCache;
import java.util.Properties;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CacheProvider;
import net.sf.hibernate.cache.Timestamper;
import net.sf.hibernate.util.PropertiesHelper;
import net.sf.hibernate.util.StringHelper;

public class OSCacheProvider
implements CacheProvider {
    public static final String OSCACHE_REFRESH_PERIOD = "refresh.period";
    public static final String OSCACHE_CRON = "cron";
    private static final Properties OSCACHE_PROPERTIES = new Config().getProperties();

    public Cache buildCache(String region, Properties properties) throws CacheException {
        int refreshPeriod = PropertiesHelper.getInt((String)StringHelper.qualify((String)region, (String)OSCACHE_REFRESH_PERIOD), (Properties)OSCACHE_PROPERTIES, (int)-1);
        String cron = OSCACHE_PROPERTIES.getProperty(StringHelper.qualify((String)region, (String)OSCACHE_CRON));
        return new OSCache(refreshPeriod, cron, region);
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public void stop() {
    }

    public void start(Properties properties) throws CacheException {
    }
}

