/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.hibernate;

import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.Map;
import java.util.Properties;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.Timestamper;
import net.sf.hibernate.util.PropertiesHelper;

public class OSCache
implements Cache {
    public static final String OSCACHE_CAPACITY = "cache.capacity";
    private static final Properties OSCACHE_PROPERTIES = new Config().getProperties();
    private static GeneralCacheAdministrator cache = new GeneralCacheAdministrator();
    private static Integer capacity = PropertiesHelper.getInteger((String)"cache.capacity", (Properties)OSCACHE_PROPERTIES);
    private final int refreshPeriod;
    private final String cron;
    private final String regionName;
    private final String[] regionGroups;

    static {
        if (capacity != null) {
            cache.setCacheCapacity(capacity.intValue());
        }
    }

    private String toString(Object key) {
        return String.valueOf(String.valueOf(key)) + "." + this.regionName;
    }

    public OSCache(int refreshPeriod, String cron, String region) {
        this.refreshPeriod = refreshPeriod;
        this.cron = cron;
        this.regionName = region;
        this.regionGroups = new String[]{region};
    }

    public Object get(Object key) throws CacheException {
        try {
            return cache.getFromCache(this.toString(key), this.refreshPeriod, this.cron);
        }
        catch (NeedsRefreshException e) {
            cache.cancelUpdate(this.toString(key));
            return null;
        }
    }

    public void put(Object key, Object value) throws CacheException {
        cache.putInCache(this.toString(key), value, this.regionGroups);
    }

    public void remove(Object key) throws CacheException {
        cache.flushEntry(this.toString(key));
    }

    public void clear() throws CacheException {
        cache.flushGroup(this.regionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws CacheException {
        GeneralCacheAdministrator generalCacheAdministrator = cache;
        synchronized (generalCacheAdministrator) {
            cache.destroy();
        }
    }

    public void lock(Object key) throws CacheException {
    }

    public void unlock(Object key) throws CacheException {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return 245760000;
    }

    public Map toMap() {
        throw new UnsupportedOperationException();
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return -1L;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }

    public Object read(Object key) throws CacheException {
        return this.get(key);
    }
}

