/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.hibernate;

import gov.va.med.person.idmgmt.common.IdentityExceptionType;
import gov.va.med.person.idmgmt.db.PSDaoFactory;
import gov.va.med.person.idmgmt.db.hb.AliasSSNLink;
import gov.va.med.person.idmgmt.db.hb.ChangeType;
import gov.va.med.person.idmgmt.db.hb.CorrelationCategory;
import gov.va.med.person.idmgmt.db.hb.DbIdentityException;
import gov.va.med.person.idmgmt.db.hb.DbIdentityTask;
import gov.va.med.person.idmgmt.db.hb.IdsAppAnswer;
import gov.va.med.person.idmgmt.db.hb.IdsAppClient;
import gov.va.med.person.idmgmt.db.hb.IdsAppNotes;
import gov.va.med.person.idmgmt.db.hb.IdsAppQuestion;
import gov.va.med.person.idmgmt.db.hb.MessageLog;
import gov.va.med.person.idmgmt.db.hb.Person;
import gov.va.med.person.idmgmt.db.hb.PersonAddress;
import gov.va.med.person.idmgmt.db.hb.PersonAddressHistory;
import gov.va.med.person.idmgmt.db.hb.PersonClassDetail;
import gov.va.med.person.idmgmt.db.hb.PersonCorrelation;
import gov.va.med.person.idmgmt.db.hb.PersonNPI;
import gov.va.med.person.idmgmt.db.hb.PersonNPIHistory;
import gov.va.med.person.idmgmt.db.hb.PersonName;
import gov.va.med.person.idmgmt.db.hb.PersonNameHistory;
import gov.va.med.person.idmgmt.db.hb.PersonPhone;
import gov.va.med.person.idmgmt.db.hb.PersonPhoneHistory;
import gov.va.med.person.idmgmt.db.hb.PersonTrait;
import gov.va.med.person.idmgmt.db.hb.PersonTraitHistory;
import gov.va.med.person.idmgmt.db.hb.PersonVPID;
import gov.va.med.person.idmgmt.db.hb.PersonVPIDLight;
import gov.va.med.person.idmgmt.db.hb.ReportPersonTraits;
import gov.va.med.person.idmgmt.db.hb.SSN;
import gov.va.med.person.idmgmt.db.hb.SSNHistory;
import gov.va.med.person.idmgmt.db.hb.SystemOfInterest;
import gov.va.med.person.idmgmt.db.hb.Verification;
import gov.va.med.person.idmgmt.db.hb.VerificationLevel;
import gov.va.med.person.idmgmt.db.hb.VirtualTableType;
import gov.va.med.person.idmgmt.exceptions.DataAccessException;
import gov.va.med.person.idmgmt.hibernate.AuditInfoInterceptor;
import gov.va.med.person.idmgmt.maint.event.Event;
import gov.va.med.person.idmgmt.util.IConstants;
import gov.va.med.person.idmgmt.util.PSIMSettings;
import gov.va.med.person.idmgmt.util.StringAndCollectionTools;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Vector;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.transaction.JTATransactionFactory;
import net.sf.hibernate.transaction.TransactionManagerLookup;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class HBSessionFactory {
    private static final AuditInfoInterceptor AUDIT_INFO_INTERCEPTOR = new AuditInfoInterceptor();
    private static final String EXCEPTION_CAUGHT = "Exception caught!";
    private static final String DIALECT_ORACLE9 = "net.sf.hibernate.dialect.Oracle9Dialect";
    private static final String CACHE_REGION_PREFIX = "PSIM-NODE1";
    private static final String WEBLOGIC_TXN_MGR_LOOKUP = "net.sf.hibernate.transaction.WeblogicTransactionManagerLookup";
    private static final String JTATRANSACTION_FACTORY = "net.sf.hibernate.transaction.JTATransactionFactory";
    private static final String CONFIG_FILE_LOCATION = "/hibernate.cfg.xml";
    private static final ThreadLocal threadLocal = new ThreadLocal();
    private static final ThreadLocal threadTransaction = new ThreadLocal();
    private static final ThreadLocal threadAuditInfo = new ThreadLocal();
    private static final ThreadLocal threadSessionInfo = new ThreadLocal();
    private static Configuration cfg;
    private static final Logger logger;
    private static SessionFactory sessionFactory;
    private static TransactionManagerLookup txnManagerLookup;

    static {
        logger = Logger.getLogger(HBSessionFactory.class);
        try {
            Class<PSDaoFactory> configKey = PSDaoFactory.class;
            Properties properties = PSIMSettings.getInstance().getPropertiesFor(configKey);
            Properties env = HBSessionFactory.loadProperties(properties);
            HBSessionFactory.logProperties("Hibernate config properties: ", env);
            cfg = new Configuration();
            cfg.setProperties(env);
            HBSessionFactory.loadClasses(cfg);
            sessionFactory = cfg.buildSessionFactory();
            HBSessionFactory.showStatus();
        }
        catch (Exception ex) {
            logger.error((Object)" HbSessionFactory, sessionFactory configuring failed!", (Throwable)ex);
        }
    }

    public static Session currentSession() throws HibernateException {
        Session session = (Session)threadLocal.get();
        if (session == null) {
            session = HBSessionFactory.openSession();
            threadLocal.set(session);
        }
        try {
            if (!session.isConnected()) {
                session.reconnect();
            }
        }
        catch (Exception e) {
            logger.error((Object)"HbSessionFactory.currentSession() failed:", (Throwable)e);
            session = sessionFactory.openSession();
            threadLocal.set(session);
        }
        return session;
    }

    public static Session openSession() throws HibernateException {
        if (sessionFactory == null) {
            throw new IllegalStateException("SessionFactory is null! Must call configure(Properties) first.");
        }
        Session session = sessionFactory.openSession((Interceptor)AUDIT_INFO_INTERCEPTOR);
        return session;
    }

    public static void configure(Properties properties) throws HibernateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.configure(Properties) - start");
        }
        HBSessionFactory.logProperties("Configure with properties: ", properties);
        if (sessionFactory == null) {
            try {
                Properties env = HBSessionFactory.loadProperties(properties);
                HBSessionFactory.logProperties("Hibernate config properties: ", env);
                cfg = new Configuration();
                cfg.setProperties(env);
                HBSessionFactory.loadClasses(cfg);
                sessionFactory = cfg.buildSessionFactory();
                HBSessionFactory.showStatus();
            }
            catch (Exception exc) {
                exc.printStackTrace();
                logger.error((Object)"HbSessionFactory.configure() failed!", (Throwable)exc);
                try {
                    logger.error((Object)" HBSessionFactory.configure()  First Attempt failed.  Making Second Attempt using /hibernate.cfg.xml");
                    cfg = new Configuration();
                    cfg.configure(CONFIG_FILE_LOCATION);
                    sessionFactory = cfg.buildSessionFactory();
                }
                catch (HibernateException e) {
                    logger.error((Object)"%%%% Error Creating SessionFactory %%%%", (Throwable)e);
                    throw new HibernateException((Throwable)e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.configure(Properties) - end");
        }
    }

    private static void showStatus() {
        try {
            DatabaseMetaData databaseMetaData = HBSessionFactory.currentSession().connection().getMetaData();
            StringBuffer buffer = new StringBuffer();
            buffer.append("Database connection information:");
            buffer.append(IConstants.ENDL);
            buffer.append("   DatabaseProductName: ");
            buffer.append(databaseMetaData.getDatabaseProductName());
            buffer.append(IConstants.ENDL);
            buffer.append("   DatabaseProductVersion: ");
            buffer.append(databaseMetaData.getDatabaseProductVersion());
            buffer.append(IConstants.ENDL);
            buffer.append("   DriverName: ");
            buffer.append(databaseMetaData.getDriverName());
            buffer.append(IConstants.ENDL);
            buffer.append("   DriverVersion: ");
            buffer.append(databaseMetaData.getDriverMajorVersion());
            buffer.append('.');
            buffer.append(databaseMetaData.getDriverMinorVersion());
            buffer.append(IConstants.ENDL);
            buffer.append("   JDBCVersion: ");
            buffer.append(databaseMetaData.getJDBCMajorVersion());
            buffer.append('.');
            buffer.append(databaseMetaData.getJDBCMinorVersion());
            buffer.append(IConstants.ENDL);
            buffer.append("   URL: ");
            buffer.append(databaseMetaData.getURL());
            buffer.append(IConstants.ENDL);
            buffer.append("   UserName: ");
            buffer.append(databaseMetaData.getUserName());
            buffer.append(IConstants.ENDL);
            logger.info((Object)buffer);
        }
        catch (HibernateException e) {
            logger.warn((Object)"Failed to get database status information.", (Throwable)e);
        }
        catch (SQLException e) {
            logger.warn((Object)"Failed to get database status information.", (Throwable)e);
        }
    }

    private HBSessionFactory() {
    }

    public static void shutdown() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory shutdown() - start");
        }
        cfg = null;
        threadLocal.set(null);
        threadTransaction.set(null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.shutdown() - end");
        }
        threadSessionInfo.set(null);
        threadAuditInfo.set(null);
    }

    public static void closeSession() throws HibernateException {
        HBSessionFactory.closeSession(false);
    }

    public static void closeSession(boolean fail) throws HibernateException {
        Session s = (Session)threadLocal.get();
        Transaction tx = HBSessionFactory.getThreadTransaction();
        if (!(tx == null || tx.wasCommitted() && tx.wasRolledBack())) {
            if (fail) {
                throw new IllegalStateException("Closing Session but Transaction still open!");
            }
            logger.warn((Object)"Closing Session but Transaction still open.  Will rollback!");
            tx.rollback();
        }
        if (s != null && s.isOpen()) {
            s.close();
        }
        threadTransaction.set(null);
        threadLocal.set(null);
        threadSessionInfo.set(null);
        threadAuditInfo.set(null);
    }

    public static void beginTransaction() throws HibernateException {
        Transaction tx = HBSessionFactory.getThreadTransaction();
        if (tx == null) {
            tx = HBSessionFactory.currentSession().beginTransaction();
            threadTransaction.set(tx);
        }
    }

    public static String getMyAuditInfo() {
        return (String)threadAuditInfo.get();
    }

    public static void setAuditInfo(String mcid) {
        threadAuditInfo.set(mcid);
    }

    public static Vector getMySessionInfo() {
        return (Vector)threadSessionInfo.get();
    }

    public static void addSessionInfo(String sessInfo) {
        Vector<String> sessVec = (Vector<String>)threadSessionInfo.get();
        if (sessVec == null) {
            sessVec = new Vector<String>();
            threadSessionInfo.set(sessVec);
        }
        sessVec.add(sessInfo);
    }

    protected static Transaction getThreadTransaction() {
        return (Transaction)threadTransaction.get();
    }

    public static void commitTransaction() throws HibernateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.commitTransaction() - start");
        }
        Transaction tx = HBSessionFactory.getThreadTransaction();
        try {
            if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
                tx.commit();
            }
            threadTransaction.set(null);
        }
        catch (RuntimeException e) {
            logger.error((Object)"HbSessionFactory.Commit failed!", (Throwable)e);
            HBSessionFactory.rollbackTransaction();
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.commitTransaction() - end");
        }
    }

    public static void rollbackTransaction() throws HibernateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.rollbackTransaction() - start");
        }
        Transaction tx = HBSessionFactory.getThreadTransaction();
        try {
            try {
                if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
                    tx.rollback();
                }
                threadTransaction.set(null);
            }
            catch (RuntimeException e) {
                logger.error((Object)"HbSessionFactory.rollbackTransaction() Failed", (Throwable)e);
                throw new RuntimeException("Might swallow original cause, check ERROR log!", e);
            }
            catch (HibernateException e) {
                logger.error((Object)"HbSessionFactory.rollbackTransaction() Failed", (Throwable)e);
                throw e;
            }
        }
        finally {
            HBSessionFactory.closeSession();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.rollbackTransaction() - end");
        }
    }

    public static void reconnect(Session session) throws HibernateException {
        session.reconnect();
        threadLocal.set(session);
    }

    public static Session disconnectSession() throws HibernateException {
        Transaction tx;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.disconnectSession() - start");
        }
        if (!((tx = HBSessionFactory.getThreadTransaction()) == null || tx.wasCommitted() && tx.wasRolledBack())) {
            throw new IllegalStateException("Disconnecting Session but Transaction still open!");
        }
        Session session = HBSessionFactory.currentSession();
        if (session.isConnected() && session.isOpen()) {
            session.disconnect();
        }
        threadTransaction.set(null);
        threadLocal.set(null);
        threadSessionInfo.set(null);
        threadAuditInfo.set(null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.disconnectSession() - end");
        }
        return session;
    }

    private static Properties loadProperties(Properties settings) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.loadProperties() - start");
        }
        Properties prop = new Properties();
        String adrDataSource = HBSessionFactory.getProperty(settings, "adr-datasource");
        if (StringAndCollectionTools.isEmpty(adrDataSource)) {
            String adrUrl = HBSessionFactory.getProperty(settings, "adr-url");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Configure for URL: " + adrUrl));
            }
            prop.put("hibernate.connection.url", adrUrl);
            prop.put("hibernate.connection.driver_class", HBSessionFactory.getProperty(settings, "adr-driver"));
            prop.put("hibernate.connection.username", HBSessionFactory.getProperty(settings, "adr-username"));
            prop.put("hibernate.connection.password", HBSessionFactory.getProperty(settings, "adr-password"));
            prop.put("hibernate.connection.pool_size", HBSessionFactory.getProperty(settings, "adr-poolsize", "3"));
        } else {
            String txnLookup;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Configure for DataSource: '" + adrDataSource + "'"));
            }
            prop.put("hibernate.connection.datasource", adrDataSource);
            String txnFactory = HBSessionFactory.getProperty(settings, "txn-factory", JTATRANSACTION_FACTORY);
            if (!StringAndCollectionTools.isEmpty(txnFactory)) {
                prop.put("hibernate.transaction.factory_class", txnFactory);
            }
            if (!StringAndCollectionTools.isEmpty(txnLookup = HBSessionFactory.getProperty(settings, "txn-manager-lookup", WEBLOGIC_TXN_MGR_LOOKUP))) {
                prop.put("hibernate.transaction.manager_lookup_class", txnLookup);
            }
        }
        prop.put("hibernate.dialect", HBSessionFactory.getProperty(settings, "hibernate-dialect", DIALECT_ORACLE9));
        prop.put("hibernate.show_sql", HBSessionFactory.getProperty(settings, "show-sql", "false"));
        prop.put("hibernate.cache.region_prefix", HBSessionFactory.getProperty(settings, "cacheRegionPrefix", CACHE_REGION_PREFIX));
        prop.put("hibernate.cache.use_query_cache", HBSessionFactory.getProperty(settings, "useQueryCache", "true"));
        prop.put("hibernate.cache.use_minimal_puts", HBSessionFactory.getProperty(settings, "useMinimalPuts", "true"));
        return prop;
    }

    private static void logProperties(String message, Properties properties) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println(message);
        properties.list(out);
        out.close();
        logger.info((Object)sw);
    }

    private static String getProperty(Properties settings, String key) {
        String value = settings.getProperty(key);
        if (value == null) {
            logger.error((Object)("HbSessionFactory.Property not found: " + key));
            throw new MissingResourceException("Property not found!", "HbSessionFactory", key);
        }
        return value;
    }

    private static String getProperty(Properties settings, String key, String defaultValue) {
        if (defaultValue == null) {
            IllegalArgumentException e = new IllegalArgumentException("defaultValue is null for property: " + key);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        String value = settings.getProperty(key);
        if (value == null) {
            logger.info((Object)("Property not found: " + key + ", Using default: " + defaultValue));
            value = defaultValue;
        }
        return value;
    }

    private static void loadClasses(Configuration config) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.loadClasses(Configuration) - start");
        }
        try {
            config.addClass(AliasSSNLink.class);
            config.addClass(SSN.class);
            config.addClass(SSNHistory.class);
            config.addClass(ChangeType.class);
            config.addClass(Person.class);
            config.addClass(PersonClassDetail.class);
            config.addClass(PersonVPID.class);
            config.addClass(PersonVPIDLight.class);
            config.addClass(PersonNPI.class);
            config.addClass(PersonNPIHistory.class);
            config.addClass(PersonName.class);
            config.addClass(PersonNameHistory.class);
            config.addClass(PersonTrait.class);
            config.addClass(PersonTraitHistory.class);
            config.addClass(Verification.class);
            config.addClass(VerificationLevel.class);
            config.addClass(SystemOfInterest.class);
            config.addClass(CorrelationCategory.class);
            config.addClass(PersonCorrelation.class);
            config.addClass(VirtualTableType.class);
            config.addClass(MessageLog.class);
            config.addClass(Event.class);
            config.addClass(DbIdentityException.class);
            config.addClass(IdentityExceptionType.class);
            config.addClass(PersonPhone.class);
            config.addClass(PersonPhoneHistory.class);
            config.addClass(PersonAddress.class);
            config.addClass(PersonAddressHistory.class);
            config.addClass(ReportPersonTraits.class);
            config.addClass(DbIdentityTask.class);
            config.addClass(IdsAppClient.class);
            config.addClass(IdsAppQuestion.class);
            config.addClass(IdsAppAnswer.class);
            config.addClass(IdsAppNotes.class);
        }
        catch (MappingException e) {
            System.out.println("CAN'T MAP ALL CLASSES!");
            e.printStackTrace();
            logger.error((Object)(" HBSessionFactory.loadClasses Mapping Exception: " + (Object)((Object)e)));
            throw new DataAccessException("HbSessionFactory.Hibernate Mapping Exception: ", (Exception)((Object)e));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.loadClasses(Configuration) - end");
        }
    }

    public static void rollbackAndClose() {
        block13: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"HbSessionFactory.rollbackAndClose() - start");
            }
            try {
                try {
                    HBSessionFactory.rollbackTransaction();
                }
                catch (HibernateException e) {
                    logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
                    try {
                        HBSessionFactory.closeSession();
                    }
                    catch (HibernateException e2) {
                        logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e2);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    HBSessionFactory.closeSession();
                }
                catch (HibernateException e) {
                    logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
                }
                throw throwable;
            }
            try {
                HBSessionFactory.closeSession();
            }
            catch (HibernateException e) {
                logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HbSessionFactory.rollbackAndClose() - end");
        }
    }

    public static boolean isContainerManagedTransactions() {
        String jtaTxnFactory = JTATransactionFactory.class.getName();
        return jtaTxnFactory.equals(cfg.getProperties().getProperty("hibernate.transaction.factory_class"));
    }

    public static Configuration getConfiguration() {
        return cfg;
    }

    public static boolean wasRolledBack() throws HibernateException {
        return HBSessionFactory.getThreadTransaction() != null && HBSessionFactory.getThreadTransaction().wasRolledBack();
    }

    public static boolean wasCommitted() throws HibernateException {
        return HBSessionFactory.getThreadTransaction() != null && HBSessionFactory.getThreadTransaction().wasCommitted();
    }

    public static TransactionManager getTransactionManager() {
        TransactionManager transactionManager = null;
        try {
            String txnMgrLookup = HBSessionFactory.getConfiguration().getProperty("hibernate.transaction.manager_lookup_class");
            if (!StringUtils.isEmpty((String)txnMgrLookup)) {
                if (txnManagerLookup == null) {
                    Class<?> txnMgrLookupClass = Class.forName(txnMgrLookup);
                    txnManagerLookup = (TransactionManagerLookup)txnMgrLookupClass.newInstance();
                }
                transactionManager = txnManagerLookup.getTransactionManager(new Properties());
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
        }
        catch (HibernateException e) {
            logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
        }
        return transactionManager;
    }
}

