/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.hibernate;

import gov.va.med.person.idmgmt.hibernate.HBSessionFactory;
import gov.va.med.person.idmgmt.util.StringAndCollectionTools;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.Configurable;
import net.sf.hibernate.id.IdentifierGenerationException;
import net.sf.hibernate.id.PersistentIdentifierGenerator;
import net.sf.hibernate.transaction.TransactionManagerLookup;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.log4j.Logger;

public class CmtTableHiLoGenerator
implements PersistentIdentifierGenerator,
Configurable {
    private static final Logger logger = Logger.getLogger(CmtTableHiLoGenerator.class);
    public static final String TABLE = "table";
    public static final String COLUMN = "column";
    public static final String MAX_LO = "max_lo";
    private static final String DEFAULT_COLUMN_NAME = "next_hi";
    private static final String DEFAULT_TABLE_NAME = "hibernate_unique_key";
    private String tableName;
    private String columnName;
    private String query;
    private String update;
    private TransactionManagerLookup transactionManagerLookup;
    private Class returnClass;
    private int maxLo;
    private long hi;
    private int lo;
    private static final String EXCEPTION_CAUGHT = "Exception caught!";

    public synchronized void configure(Type type, Properties params, Dialect dialect) {
        this.tableName = PropertiesHelper.getString((String)TABLE, (Properties)params, (String)DEFAULT_TABLE_NAME);
        this.columnName = PropertiesHelper.getString((String)COLUMN, (Properties)params, (String)DEFAULT_COLUMN_NAME);
        String schemaName = params.getProperty("schema");
        if (schemaName != null && this.tableName.indexOf(46) < 0) {
            this.tableName = String.valueOf(schemaName) + '.' + this.tableName;
        }
        this.query = "select " + this.columnName + " from " + this.tableName;
        if (dialect.supportsForUpdate()) {
            this.query = String.valueOf(this.query) + " for update";
        }
        this.update = "update " + this.tableName + " set " + this.columnName + " = ? where " + this.columnName + " = ?";
        this.configureTransactionManagerLookup();
        this.maxLo = PropertiesHelper.getInt((String)MAX_LO, (Properties)params, (int)Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
        if (logger.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            out.println("Configured id generator: ");
            out.println("tableName=" + this.tableName);
            out.println("columnName=" + this.columnName);
            out.println("maxLo=" + this.maxLo);
            out.println("query=" + this.query);
            out.println("update=" + this.update);
            out.println("returnClass=" + this.returnClass);
            out.println("transactionManagerLookup=" + this.transactionManagerLookup);
            out.close();
            logger.debug((Object)sw);
        }
    }

    private void configureTransactionManagerLookup() {
        try {
            String txnMgrLookup = HBSessionFactory.getConfiguration().getProperty("hibernate.transaction.manager_lookup_class");
            if (StringAndCollectionTools.isEmpty(txnMgrLookup)) {
                logger.warn((Object)"No TransactionManagerLookup class configured in PDSConfig.");
            } else {
                Class<?> txnMgrLookupClass = Class.forName(txnMgrLookup);
                this.transactionManagerLookup = (TransactionManagerLookup)txnMgrLookupClass.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
        }
    }

    public synchronized Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        if (this.lo > this.maxLo) {
            long hival = this.generateBaseID(session);
            this.lo = 1;
            this.hi = hival * (long)(this.maxLo + 1);
            logger.debug((Object)("new hi value: " + hival));
        }
        return CmtTableHiLoGenerator.createNumber(this.hi + (long)this.lo++, this.returnClass);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long generateBaseID(SessionImplementor session) throws HibernateException, IdentifierGenerationException {
        long l;
        TransactionManager tm = this.transactionManagerLookup.getTransactionManager(new Properties());
        Transaction surroundingTransaction = null;
        Connection connection = null;
        try {
            surroundingTransaction = tm.suspend();
            logger.debug((Object)"surrounding tx suspended");
            tm.begin();
            connection = session.getBatcher().openConnection();
            long result = this.readNextValue(connection);
            long sequence = result + 1L;
            this.updateNextValue(connection, result, sequence);
            tm.commit();
            l = sequence;
            this.closeConnection(connection);
        }
        catch (SQLException sqle) {
            try {
                throw new IdentifierGenerationException("could not get or update next value", (Throwable)sqle);
                catch (Exception e) {
                    try {
                        tm.rollback();
                        throw new HibernateException((Throwable)e);
                    }
                    catch (SystemException e1) {
                        throw new HibernateException((Throwable)e1);
                    }
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(connection);
                this.resume(tm, surroundingTransaction);
                throw throwable;
            }
        }
        this.resume(tm, surroundingTransaction);
        return l;
    }

    private void resume(TransactionManager tm, Transaction surroundingTransaction) throws HibernateException {
        if (surroundingTransaction != null) {
            try {
                tm.resume(surroundingTransaction);
                logger.debug((Object)"surrounding tx resumed");
            }
            catch (InvalidTransactionException e) {
                logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
                throw new HibernateException((Throwable)e);
            }
            catch (SystemException e) {
                logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
                throw new HibernateException((Throwable)e);
            }
        }
    }

    private void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error((Object)EXCEPTION_CAUGHT, (Throwable)e);
            }
        }
    }

    private void updateNextValue(Connection conn, long currentValue, long nextValue) throws SQLException {
        PreparedStatement ups = conn.prepareStatement(this.update);
        try {
            try {
                ups.setLong(1, nextValue);
                ups.setLong(2, currentValue);
                ups.executeUpdate();
            }
            catch (SQLException sqle) {
                logger.error((Object)("could not update sequence value in: " + this.tableName), (Throwable)sqle);
                throw sqle;
            }
        }
        finally {
            ups.close();
        }
    }

    private long readNextValue(Connection conn) throws SQLException, IdentifierGenerationException {
        long result;
        PreparedStatement qps = conn.prepareStatement(this.query);
        try {
            try {
                ResultSet rs = qps.executeQuery();
                if (!rs.next()) {
                    String err = "could not read sequence value - you need to populate the table: " + this.tableName;
                    logger.error((Object)err);
                    throw new IdentifierGenerationException(err);
                }
                result = rs.getLong(1);
                rs.close();
            }
            catch (SQLException sqle) {
                logger.error((Object)"could not read a sequence value", (Throwable)sqle);
                throw sqle;
            }
        }
        finally {
            qps.close();
        }
        return result;
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{"create table " + this.tableName + " ( " + this.columnName + " " + dialect.getTypeName(-5) + " )", "insert into " + this.tableName + " values ( 0 )"};
    }

    public String sqlDropString(Dialect dialect) {
        StringBuffer sqlDropString = new StringBuffer(52).append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            sqlDropString.append("if exists ");
        }
        sqlDropString.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            sqlDropString.append(" if exists");
        }
        return sqlDropString.toString();
    }

    public Object generatorKey() {
        return this.tableName;
    }

    static Number createNumber(long value, Class clazz) throws IdentifierGenerationException {
        if (clazz == Long.class) {
            return new Long(value);
        }
        if (clazz == Integer.class) {
            return new Integer((int)value);
        }
        if (clazz == Short.class) {
            return new Short((short)value);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short");
    }
}

