/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.hibernate;

import gov.va.med.person.idmgmt.db.PSDaoFactory;
import gov.va.med.person.idmgmt.db.hb.AuditInfo;
import gov.va.med.person.idmgmt.db.hb.IAuditable;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import net.sf.hibernate.CallbackException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.type.Type;

public class AuditInfoInterceptor
implements Interceptor {
    public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        return false;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) throws CallbackException {
        if (entity instanceof IAuditable) {
            IAuditable auditable = (IAuditable)entity;
            this.updateAuditInfo(auditable.getAuditInfo());
            return true;
        }
        return false;
    }

    protected void updateAuditInfo(AuditInfo auditInfo) {
        auditInfo.setUpdated(new Date(System.currentTimeMillis()));
        auditInfo.getUpdatedByAutoFlag();
        auditInfo.setUpdatedBy(PSDaoFactory.instance().getAuditInfo());
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        return false;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
    }

    public void preFlush(Iterator entities) throws CallbackException {
    }

    public void postFlush(Iterator entities) throws CallbackException {
    }

    public Boolean isUnsaved(Object entity) {
        return null;
    }

    public int[] findDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        return null;
    }

    public Object instantiate(Class clazz, Serializable id) throws CallbackException {
        return null;
    }
}

