/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.factory;

import gov.va.med.person.idmgmt.common.ISSN;
import gov.va.med.person.idmgmt.common.ISSNHistory;
import gov.va.med.person.idmgmt.db.hb.SSN;
import gov.va.med.person.idmgmt.factory.QualifiedIdentifierFactory;
import org.apache.log4j.Logger;

public class SSNFactory {
    private static final Logger logger = Logger.getLogger(SSNFactory.class);

    public static ISSN create(ISSNHistory ssnHistory) {
        String ssnFromHistory;
        SSN ssn;
        block14: {
            block13: {
                ssn = new SSN();
                if (ssnHistory != null) break block13;
                return null;
            }
            ssnFromHistory = ssnHistory.getSsn();
            if (ssnHistory.getPseudoSSNReason() != null) {
                ssn.setPseudoSSNReason(ssnHistory.getPseudoSSNReason().getCode().toString());
                if (ssnFromHistory == null) {
                    ssnFromHistory = "\"\"";
                }
            }
            if (ssnFromHistory != null) break block14;
            return null;
        }
        try {
            ssn.setSSN(QualifiedIdentifierFactory.create(ssnFromHistory, "SS"));
            if (ssnHistory.getReceivedFromSSA() != null) {
                ssn.setReceivedFromSSA(ssnHistory.getReceivedFromSSA());
            }
            if (ssnHistory.getSsaVerificationCode() != null) {
                ssn.setSsaVerificationCode(ssnHistory.getSsaVerificationCode().getCode());
            }
            if (ssnHistory.getSentToSSA() != null) {
                ssn.setSentToSSA(ssnHistory.getSentToSSA());
            }
            if (ssnHistory.getSsnChangeSource() != null) {
                ssn.setSsnChangeSource(ssnHistory.getSsnChangeSource().getCode());
            }
            if (ssnHistory.getSsnType() != null) {
                ssn.setSsnType(ssnHistory.getSsnType().getCode());
            }
            if (ssnHistory.getSsnVerificationStatus() != null) {
                ssn.setSsnVerificationStatus(ssnHistory.getSsnVerificationStatus().getCode().toString());
            }
            if (ssnHistory.getVerifiedBySSA() != null) {
                ssn.setVerifiedBySSA(ssnHistory.getVerifiedBySSA());
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Problem creating SSN", (Throwable)e);
        }
        return ssn;
    }

    public static ISSN create(String ssnType, int ssnVerificationStatus) {
        SSN ssn = new SSN();
        if (ssnType != null) {
            ssn.setSsnType(ssnType);
        }
        Integer strVerifStatus = new Integer(ssnVerificationStatus);
        ssn.setSsnVerificationStatus(strVerifStatus.toString());
        return ssn;
    }
}

