/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.factory;

import gov.va.med.person.idmgmt.IQualifiedIdentifier;
import gov.va.med.person.idmgmt.NPI;
import gov.va.med.person.idmgmt.QualifiedIdentifierImpl;
import gov.va.med.person.idmgmt.VPID;
import gov.va.med.person.idmgmt.common.ISystemOfInterest;
import gov.va.med.person.idmgmt.exceptions.NPIException;
import gov.va.med.person.idmgmt.exceptions.PSIMException;
import gov.va.med.person.idmgmt.exceptions.VPIDException;
import gov.va.med.person.idmgmt.util.IConstants;
import gov.va.med.term.access.AssigningAuthority;
import gov.va.med.term.access.IdentifierType;
import java.util.Date;

public class QualifiedIdentifierFactory
implements IConstants {
    public static IQualifiedIdentifier create(String identifier, String identifierType) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create(identifier, identifierType, null, null, null, null, null);
    }

    public static IQualifiedIdentifier create(String identifier, IdentifierType identifierType) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create(identifier, identifierType, null, null, null, null, null);
    }

    public static IQualifiedIdentifier create(String identifier, String identifierType, String assigningAuthority) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create(identifier, identifierType, assigningAuthority, null, null, null, null);
    }

    public static IQualifiedIdentifier create(String identifier, IdentifierType identifierType, AssigningAuthority assigningAuthority) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create(identifier, identifierType, assigningAuthority, null, null, null, null);
    }

    public static IQualifiedIdentifier create(String identifier, String identifierType, String assigningAuthority, String assigningLocation) throws PSIMException, VPIDException, NPIException {
        String localAA = assigningAuthority;
        if (localAA == null || localAA.length() == 0) {
            localAA = "USVHA";
        }
        return QualifiedIdentifierFactory.create(identifier, identifierType, localAA, assigningLocation, null, null, null);
    }

    public static IQualifiedIdentifier create(String identifier, IdentifierType identifierType, AssigningAuthority assigningAuthority, ISystemOfInterest assigningLocation) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create(identifier, identifierType, assigningAuthority, assigningLocation, null, null, null);
    }

    public static IQualifiedIdentifier create(String identifier, String identifierType, String assigningAuthority, String assigningLocation, String assigningLocationName) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create(identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, null, null);
    }

    public static IQualifiedIdentifier create(String identifier, IdentifierType identifierType, AssigningAuthority assigningAuthority, ISystemOfInterest assigningLocation, String assigningLocationName) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create(identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, null, null);
    }

    public static IQualifiedIdentifier create(String identifier, String identifierType, String assigningAuthority, String assigningLocation, String assigningLocationName, Date effective) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create(identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, null);
    }

    public static IQualifiedIdentifier create(String identifier, IdentifierType identifierType, AssigningAuthority assigningAuthority, ISystemOfInterest assigningLocation, String assigningLocationName, Date effective) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create(identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, null);
    }

    public static IQualifiedIdentifier create(String identifier, IdentifierType identifierType, AssigningAuthority assigningAuthority, ISystemOfInterest assigningLocation, String assigningLocationName, Date effective, Date expiration) throws PSIMException, VPIDException, NPIException {
        if (identifierType == null) {
            String errMsg = QualifiedIdentifierFactory.buildExceptionText("An identifier type value is required.", identifier, "", "", "", assigningLocationName, effective, expiration);
            throw new PSIMException(errMsg);
        }
        if (assigningAuthority == null) {
            String errMsg = QualifiedIdentifierFactory.buildExceptionText("An assigning authority is required.", identifier.toString(), "", "", "", assigningLocationName, effective, expiration);
            throw new PSIMException(errMsg);
        }
        if (assigningLocation != null) {
            return QualifiedIdentifierFactory.create(identifier, identifierType.getCode(), assigningAuthority.getCode(), assigningLocation.getSiteCode(), assigningLocationName, effective, expiration);
        }
        return QualifiedIdentifierFactory.create(identifier, identifierType.getCode(), assigningAuthority.getCode(), assigningLocationName, assigningLocationName, effective, expiration);
    }

    public static IQualifiedIdentifier create(String identifier, String identifierType, String assigningAuthority, String assigningLocation, String assigningLocationName, Date effective, Date expiration) throws PSIMException, VPIDException, NPIException {
        if (identifier == null && "SS".equalsIgnoreCase(identifierType)) {
            return null;
        }
        if (identifier == null) {
            String errMsg = QualifiedIdentifierFactory.buildExceptionText("An identifier value is required.", identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
            throw new PSIMException(errMsg);
        }
        if (identifierType != null) {
            if ("NI".equals(identifierType)) {
                if (assigningLocation != null && assigningLocation.length() > 0 && !"200PS".equalsIgnoreCase(assigningLocation) && !"200M".equalsIgnoreCase(assigningLocation)) {
                    if ("USVHA".equalsIgnoreCase(assigningAuthority)) {
                        String errMsg = QualifiedIdentifierFactory.buildExceptionText("A USVHA National Id can only be set by MVI(MPI/PSIM).", identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
                        throw new PSIMException(errMsg);
                    }
                    return QualifiedIdentifierFactory.createIEN(identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
                }
                return QualifiedIdentifierFactory.createVPID(identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
            }
            if ("PI".equals(identifierType) || "EI".equals(identifierType)) {
                return QualifiedIdentifierFactory.createIEN(identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
            }
            if ("SS".equals(identifierType)) {
                return QualifiedIdentifierFactory.createSSN(identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
            }
            if ("NPI".equals(identifierType)) {
                return QualifiedIdentifierFactory.createNPI(identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
            }
            String errMsg = QualifiedIdentifierFactory.buildExceptionText("An invalid identifier type was passed in.", identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
            throw new PSIMException(errMsg);
        }
        String errMsg = QualifiedIdentifierFactory.buildExceptionText("An identifier type value is required.", identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
        throw new PSIMException(errMsg);
    }

    private static IQualifiedIdentifier createVPID(String identifier, String identifierType, String assigningAuthority, String assigningLocation, String assigningLocationName, Date effective, Date expiration) throws VPIDException {
        VPID vpid = new VPID(identifier);
        return QualifiedIdentifierFactory.populate(vpid.getVPID().getIdentifier(), identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
    }

    private static IQualifiedIdentifier createNPI(String identifier, String identifierType, String assigningAuthority, String assigningLocation, String assigningLocationName, Date effective, Date expiration) throws NPIException {
        if ("\"\"".equals(identifier) || "<NULL>".equals(identifier) || "NOTSENT".equals(identifier)) {
            return QualifiedIdentifierFactory.populate(identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
        }
        NPI npi = new NPI(identifier);
        return QualifiedIdentifierFactory.populate(npi.getNPI().getIdentifier(), identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
    }

    private static IQualifiedIdentifier createIEN(String identifier, String identifierType, String assigningAuthority, String assigningLocation, String assigningLocationName, Date effective, Date expiration) throws PSIMException {
        try {
            return QualifiedIdentifierFactory.populate(identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
        }
        catch (Exception rte) {
            String errMsg = QualifiedIdentifierFactory.buildExceptionText("Could NOT create Qualified Identified with these attributes:", identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
            throw new PSIMException(errMsg, rte);
        }
    }

    private static IQualifiedIdentifier createSSN(String identifier, String identifierType, String assigningAuthority, String assigningLocation, String assigningLocationName, Date effective, Date expiration) throws PSIMException {
        return QualifiedIdentifierFactory.populate(identifier, identifierType, assigningAuthority == null ? "USSSA" : assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
    }

    private static IQualifiedIdentifier populate(String identifier, String identifierType, String assigningAuthority, String assigningLocation, String assigningLocationName, Date effective, Date expiration) {
        QualifiedIdentifierImpl id = new QualifiedIdentifierImpl(identifier, identifierType, assigningAuthority, assigningLocation, assigningLocationName, effective, expiration);
        return id;
    }

    private static String buildExceptionText(String msg, String identifier, String identifierType, String assigningAuthority, String assigningLocation, String assigningLocationName, Date effective, Date expiration) {
        StringBuffer errBuf = new StringBuffer(300);
        errBuf.append(msg).append(" Id:").append(identifier).append(",Type:").append(identifierType).append(",AA:").append(assigningAuthority).append(",AL: ").append(assigningLocation).append(",ALName: ").append(assigningLocationName).append(",EFF: ").append(effective).append(",EXP: ").append(expiration);
        return errBuf.toString();
    }

    private static boolean isAlphaNumericWithOneOptionalPeriod(String str) {
        return str != null && str.trim().length() != 0 && str.matches("(^[A-Za-z[0-9]]*[\\.]?[A-Za-z[0-9]]*$)");
    }
}

