/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.common.ISystemOfInterest;
import gov.va.med.person.idmgmt.db.hb.AuditInfo;
import gov.va.med.person.idmgmt.sds.IdmInstitution;
import gov.va.med.person.idmgmt.sds.SDSDelegate;
import gov.va.med.term.access.Institution;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SystemOfInterest
implements Serializable,
ISystemOfInterest {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String description;
    private Long institutionId;
    private Institution institution;
    private IdmInstitution idmInstitution;
    private Integer version;
    private AuditInfo auditInfo;
    private boolean isMedicalTreating = false;
    private String siteCode = "";
    private String siteName = "";
    private String afoid = "";

    public SystemOfInterest(String name, String description, Long institutionId, Integer version, AuditInfo auditInfo) {
        this.name = name;
        this.description = description;
        this.institutionId = institutionId;
        this.version = version;
        this.auditInfo = auditInfo;
    }

    public SystemOfInterest() {
    }

    public SystemOfInterest(String name, AuditInfo auditInfo) {
        this.name = name;
        this.auditInfo = auditInfo;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getAfoid() {
        return this.afoid;
    }

    @Override
    public void setAfoid(String afoid) {
        this.afoid = afoid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Long getInstitutionId() {
        if (this.institution == null && this.institutionId != null) {
            this.institution = Institution.factory.obtainFromKeyValue(this.institutionId);
        }
        return this.institutionId;
    }

    @Override
    public void setInstitutionId(Long institutionId) {
        this.institutionId = institutionId;
        this.institution = null;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public AuditInfo getAuditInfo() {
        return this.auditInfo;
    }

    public void setAuditInfo(AuditInfo auditInfo) {
        this.auditInfo = auditInfo;
    }

    @Override
    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    @Override
    public String getSiteCode() {
        if (this.siteCode == null || this.siteCode.length() == 0) {
            if (this.institutionId != null) {
                if (this.idmInstitution == null) {
                    this.idmInstitution = SDSDelegate.getInstitutionByKeyValue(this.institutionId);
                }
                if (this.idmInstitution == null) {
                    System.err.println("Invalid PSOI Entry:" + this.getId());
                    System.out.println("Invalid PSOI Entry:" + this.getId());
                    this.siteCode = "99999";
                } else {
                    this.siteCode = this.idmInstitution.getStationNumber();
                }
            } else {
                this.siteCode = this.getAuditInfo().getCreatedBy();
            }
        }
        return this.siteCode;
    }

    @Override
    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @Override
    public String getSiteName() {
        if (this.siteName == null || this.siteName.length() == 0) {
            if (this.institutionId != null) {
                if (this.idmInstitution == null) {
                    this.idmInstitution = SDSDelegate.getInstitutionByKeyValue(this.institutionId);
                }
                this.siteName = this.idmInstitution.getName();
            } else {
                this.siteName = this.name;
            }
        }
        return this.siteName;
    }

    @Override
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append((Object)"\r\n** SystemOfInterest:\r\n").append((Object)"id = ").append((Object)this.id).append((Object)"\r\n").append((Object)"name = ").append((Object)this.name).append((Object)"\r\n").append((Object)"description = ").append((Object)this.description).append((Object)"\r\n").append((Object)"version = ").append((Object)this.version).append((Object)"\r\n").append((Object)"auditInfo = ").append((Object)this.auditInfo);
        return builder.toString();
    }

    @Override
    public boolean isMedicalTreating() {
        if (this.institutionId != null) {
            if (this.idmInstitution == null) {
                this.idmInstitution = SDSDelegate.getInstitutionByKeyValue(this.institutionId);
                this.isMedicalTreating = this.idmInstitution.isMedicalTreating();
            }
        } else {
            String[] facilityData;
            this.isMedicalTreating = false;
            if (this.description != null && this.description.length() > 0 && this.description.indexOf("^") > -1 && (facilityData = this.description.split("^")).length > 1 && facilityData[1].equalsIgnoreCase("1")) {
                this.isMedicalTreating = true;
            }
        }
        return this.isMedicalTreating;
    }
}

