/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.FilterCriteria;
import gov.va.med.person.idmgmt.common.ISSNHistory;
import gov.va.med.person.idmgmt.db.hb.SSNHistory;
import gov.va.med.term.access.SSNType;
import java.sql.Timestamp;

public class SSNHistoryFilterFactory {
    public static FilterCriteria createFilterActiveHistory() {
        return new TimeStampHistoryFilter(new Timestamp(System.currentTimeMillis()));
    }

    public static FilterCriteria createFilterTimeStampedHistory(Timestamp timeStamp) {
        return new TimeStampHistoryFilter(timeStamp);
    }

    public static FilterCriteria createFilterSSNTypeHistory(Long ssnTypeId) {
        return new SSNTypeHistoryFilter(ssnTypeId);
    }

    private static class EffectiveDateFilter
    implements FilterCriteria {
        private Timestamp timestamp;
        private boolean inverse;

        EffectiveDateFilter(Timestamp timestamp, boolean inverse) {
            this.inverse = inverse;
            this.timestamp = timestamp;
        }

        EffectiveDateFilter(Timestamp timestamp) {
            this(timestamp, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof ISSNHistory) {
                boolean isMatch;
                ISSNHistory history = (ISSNHistory)obj;
                boolean bl = isMatch = (history.getEffectiveDate().before(this.timestamp) || history.getEffectiveDate().equals(this.timestamp)) && this.timestamp.before(history.getExpirationDate());
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class SSNTypeHistoryFilter
    implements FilterCriteria {
        private Long typeId;
        private boolean inverse;

        SSNTypeHistoryFilter(Long typeId, boolean inverse) {
            this.typeId = typeId;
            this.inverse = inverse;
        }

        SSNTypeHistoryFilter(Long typeId) {
            this(typeId, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof SSNHistory) {
                boolean isMatch = false;
                SSNHistory history = (SSNHistory)obj;
                SSNType type = history.getSsnType();
                if (type == null) {
                    isMatch = false;
                } else {
                    boolean bl = isMatch = this.typeId.longValue() == type.getId().longValue();
                }
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class TimeStampHistoryFilter
    implements FilterCriteria {
        private Timestamp timestamp;
        private boolean inverse;

        TimeStampHistoryFilter(Timestamp timestamp, boolean inverse) {
            this.inverse = inverse;
            this.timestamp = timestamp;
        }

        TimeStampHistoryFilter(Timestamp timestamp) {
            this(timestamp, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof ISSNHistory) {
                boolean isMatch;
                ISSNHistory history = (ISSNHistory)obj;
                boolean bl = isMatch = (history.getEffectiveDate().before(this.timestamp) || history.getEffectiveDate().equals(this.timestamp)) && this.timestamp.before(history.getExpirationDate());
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }
}

