/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.common.ISSNHistory;
import gov.va.med.person.idmgmt.db.hb.AbstractEntity;
import gov.va.med.person.idmgmt.db.hb.SSN;
import gov.va.med.person.idmgmt.util.IConstants;
import gov.va.med.term.access.PseudoSSNReason;
import gov.va.med.term.access.SSAMessageType;
import gov.va.med.term.access.SSAVerificationCode;
import gov.va.med.term.access.SSNChangeSource;
import gov.va.med.term.access.SSNType;
import gov.va.med.term.access.SSNVerificationStatus;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SSNHistory
extends AbstractEntity
implements ISSNHistory {
    private static final long serialVersionUID = 1L;
    private String ssn;
    private Date sentToSSA;
    private Date receivedFromSSA;
    private Date verifiedBySSA;
    private Long ssnTypeId;
    private Long pseudoSSNReasonId;
    private Long ssnChangeSourceId;
    private Long ssnVerificationStatusId;
    private Long ssaMessageTypeId;
    private Long ssaVerificationCodeId;
    private Byte active;
    private Timestamp effectiveDate;
    private Timestamp expirationDate;
    private SSN owner;
    private SSAMessageType ssaMessageType;
    private SSAVerificationCode ssaVerificationCode;
    private SSNChangeSource ssnChangeSource;
    private SSNType ssnType;
    private SSNVerificationStatus ssnVerificationStatus;
    private PseudoSSNReason pseudoSSNReason;

    @Override
    public String getSsn() {
        return this.ssn;
    }

    @Override
    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    @Override
    public Date getSentToSSA() {
        return this.sentToSSA;
    }

    @Override
    public void setSentToSSA(Date sentToSSA) {
        this.sentToSSA = sentToSSA;
    }

    @Override
    public Date getReceivedFromSSA() {
        return this.receivedFromSSA;
    }

    @Override
    public void setReceivedFromSSA(Date receivedFromSSA) {
        this.receivedFromSSA = receivedFromSSA;
    }

    @Override
    public Date getVerifiedBySSA() {
        return this.verifiedBySSA;
    }

    @Override
    public void setVerifiedBySSA(Date verifiedBySSA) {
        this.verifiedBySSA = verifiedBySSA;
    }

    @Override
    public Long getSsnTypeId() {
        return this.ssnTypeId;
    }

    @Override
    public void setSsnTypeId(Long ssnTypeId) {
        this.ssnTypeId = ssnTypeId;
        this.ssnType = null;
    }

    @Override
    public Long getPseudoSSNReasonId() {
        return this.pseudoSSNReasonId;
    }

    @Override
    public void setPseudoSSNReasonId(Long id) {
        this.pseudoSSNReasonId = id;
        this.pseudoSSNReason = null;
    }

    @Override
    public Long getSsnChangeSourceId() {
        return this.ssnChangeSourceId;
    }

    @Override
    public void setSsnChangeSourceId(Long ssnChangeSourceId) {
        this.ssnChangeSourceId = ssnChangeSourceId;
        this.ssnChangeSource = null;
    }

    @Override
    public Long getSsnVerificationStatusId() {
        return this.ssnVerificationStatusId;
    }

    @Override
    public void setSsnVerificationStatusId(Long id) {
        this.ssnVerificationStatusId = id;
        this.ssnVerificationStatus = null;
    }

    public void setSsnVerificationStatus(SSNVerificationStatus status) {
        this.ssnVerificationStatus = status;
        this.ssnVerificationStatusId = status != null ? status.getId() : null;
    }

    @Override
    public Long getSsaMessageTypeId() {
        return this.ssaMessageTypeId;
    }

    @Override
    public void setSsaMessageTypeId(Long ssaMessageTypeId) {
        this.ssaMessageTypeId = ssaMessageTypeId;
        this.ssaMessageType = null;
    }

    @Override
    public Long getSsaVerificationCodeId() {
        return this.ssaVerificationCodeId;
    }

    @Override
    public void setSsaVerificationCodeId(Long ssaVerificationCodeId) {
        this.ssaVerificationCodeId = ssaVerificationCodeId;
        this.ssaVerificationCode = null;
    }

    @Override
    public Timestamp getEffectiveDate() {
        return this.effectiveDate;
    }

    @Override
    public void setEffectiveDate(Timestamp effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Override
    public Timestamp getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public void setExpirationDate(Timestamp expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Override
    public SSN getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(SSN owner) {
        this.owner = owner;
    }

    @Override
    public SSNType getSsnType() {
        if (this.ssnType == null && this.ssnTypeId != null) {
            this.ssnType = SSNType.factory.obtainFromKeyValue(this.ssnTypeId);
        }
        return this.ssnType;
    }

    @Override
    public SSNChangeSource getSsnChangeSource() {
        if (this.ssnChangeSource == null && this.ssnChangeSourceId != null) {
            this.ssnChangeSource = SSNChangeSource.factory.obtainFromKeyValue(this.ssnChangeSourceId);
        }
        return this.ssnChangeSource;
    }

    @Override
    public SSAMessageType getSsaMessageType() {
        if (this.ssaMessageType == null && this.ssaMessageTypeId != null) {
            this.ssaMessageType = SSAMessageType.factory.obtainFromKeyValue(this.ssaMessageTypeId);
        }
        return this.ssaMessageType;
    }

    @Override
    public SSAVerificationCode getSsaVerificationCode() {
        if (this.ssaVerificationCode == null && this.ssaVerificationCodeId != null) {
            this.ssaVerificationCode = SSAVerificationCode.factory.obtainFromKeyValue(this.ssaVerificationCodeId);
        }
        return this.ssaVerificationCode;
    }

    @Override
    public SSNVerificationStatus getSsnVerificationStatus() {
        if (this.ssnVerificationStatus == null && this.ssnVerificationStatusId != null) {
            this.ssnVerificationStatus = SSNVerificationStatus.factory.obtainFromKeyValue(this.ssnVerificationStatusId);
        }
        return this.ssnVerificationStatus;
    }

    @Override
    public boolean isActive() {
        return IConstants.ONE.equals(this.active);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).toString();
    }

    public void setActive(boolean b) {
        this.active = b ? IConstants.ONE : IConstants.ZERO;
    }

    public void setSsnType(SSNType type) {
        this.ssnType = type;
        this.ssnTypeId = type != null ? type.getId() : null;
    }

    public void setPseudoSSNReason(PseudoSSNReason psr) {
        this.pseudoSSNReason = psr;
        this.pseudoSSNReasonId = psr != null ? psr.getId() : null;
    }

    @Override
    public PseudoSSNReason getPseudoSSNReason() {
        if (this.pseudoSSNReason == null && this.pseudoSSNReasonId != null) {
            this.pseudoSSNReason = PseudoSSNReason.factory.obtainFromKeyValue(this.pseudoSSNReasonId);
        }
        return this.pseudoSSNReason;
    }

    public int compareTo(Object o) {
        int result = 0;
        if (!(o instanceof SSNHistory)) {
            return -1;
        }
        SSNHistory other = (SSNHistory)o;
        SSN value = this.getOwner();
        SSN otherValue = other.getOwner();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        if (result != 0) {
            return result;
        }
        Timestamp dateValue = this.getEffectiveDate();
        Timestamp otherDateValue = other.getEffectiveDate();
        if (dateValue == null) {
            return otherDateValue == null ? 0 : -1;
        }
        if (otherDateValue == null) {
            return 1;
        }
        result = dateValue.compareTo(otherDateValue);
        return result;
    }

    public boolean equals(Object o) {
        int x = this.compareTo(o);
        return x == 0;
    }

    public void onSave() {
        this.owner.addHistory(this);
    }
}

