/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.FilterCriteria;
import gov.va.med.person.idmgmt.db.hb.SSN;
import gov.va.med.person.idmgmt.db.hb.SSNHistory;

public class SSNFilterFactory {
    public static FilterCriteria createFilterActive() {
        return new ActiveFilter();
    }

    public static FilterCriteria createFilterExpired() {
        return new ActiveFilter(true);
    }

    public static FilterCriteria createFilterSSNType(String ssnType) {
        return new SSNTypeFilter(ssnType);
    }

    public static FilterCriteria createFilterSSNTypeId(Long ssnTypeId) {
        return new SSNTypeIdFilter(ssnTypeId);
    }

    public static FilterCriteria createFilterSSNTypeInverse(String ssnType) {
        return new SSNTypeFilter(ssnType, true);
    }

    public static FilterCriteria createFilterSSNValue(String ssnValue) {
        return new SSNValueFilter(ssnValue);
    }

    private static class ActiveFilter
    implements FilterCriteria {
        private boolean inverse;

        ActiveFilter(boolean inverse) {
            this.inverse = inverse;
        }

        ActiveFilter() {
            this(false);
        }

        @Override
        public boolean passes(Object obj) {
            boolean isMatch = false;
            if (obj != null && obj instanceof SSN) {
                SSN ssn = (SSN)obj;
                SSNHistory history = (SSNHistory)ssn.getActiveHistory();
                isMatch = history == null ? false : history.isActive();
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class SSNTypeFilter
    implements FilterCriteria {
        private String type;
        private boolean inverse;

        SSNTypeFilter(String type, boolean inverse) {
            this.type = type;
            this.inverse = inverse;
        }

        SSNTypeFilter(String type) {
            this(type, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof SSN) {
                SSN ssn = (SSN)obj;
                boolean isMatch = false;
                if (this.type == null) {
                    if (ssn.getSsnType() == null) {
                        isMatch = true;
                    }
                } else {
                    isMatch = this.type.equalsIgnoreCase(ssn.getSsnType());
                }
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class SSNTypeIdFilter
    implements FilterCriteria {
        private Long id;
        private boolean inverse;

        SSNTypeIdFilter(Long id, boolean inverse) {
            this.id = id;
            this.inverse = inverse;
        }

        SSNTypeIdFilter(Long id) {
            this(id, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof SSN) {
                SSN ssn = (SSN)obj;
                boolean isMatch = false;
                if (this.id == null) {
                    if (ssn.getSsnType() == null) {
                        isMatch = true;
                    }
                } else {
                    isMatch = this.id.equals(ssn.getSsnTypeId());
                }
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class SSNValueFilter
    implements FilterCriteria {
        private String ssnValue;
        private boolean inverse;

        SSNValueFilter(String ssnValue, boolean inverse) {
            this.ssnValue = ssnValue;
            this.inverse = inverse;
        }

        SSNValueFilter(String ssnValue) {
            this(ssnValue, false);
        }

        @Override
        public boolean passes(Object obj) {
            boolean isMatch = false;
            if (obj != null && obj instanceof SSN) {
                SSN ssn = (SSN)obj;
                String dbValue = ssn.getSsn();
                if (dbValue == null) {
                    dbValue = "";
                }
                isMatch = this.ssnValue.equalsIgnoreCase(dbValue);
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return isMatch;
        }
    }
}

