/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.CollectionFilter;
import gov.va.med.person.idmgmt.IQualifiedIdentifier;
import gov.va.med.person.idmgmt.common.IPersonTrait;
import gov.va.med.person.idmgmt.common.ISSN;
import gov.va.med.person.idmgmt.common.ISSNHistory;
import gov.va.med.person.idmgmt.db.hb.AbstractEntity;
import gov.va.med.person.idmgmt.db.hb.PersonTrait;
import gov.va.med.person.idmgmt.db.hb.SSNHistory;
import gov.va.med.person.idmgmt.db.hb.SSNHistoryFilterFactory;
import gov.va.med.term.access.SSAVerificationCode;
import gov.va.med.term.access.SSNType;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SSN
extends AbstractEntity
implements ISSN {
    private static final long serialVersionUID = 1L;
    private PersonTrait personTrait;
    private Set historyStore = new HashSet();
    private String ssnType;
    private String pseudoSSNReason;
    private IQualifiedIdentifier ssn;
    private String ssnVerificationStatus;
    private Date sentToSSA;
    private Date receivedFromSSA;
    private Date verifiedBySSA;
    private String ssnChangeSource;
    private String ssaMessageType;
    private String ssaVerificationCode;
    private static final ISSNHistory[] HISTORY_TEMPLATE = new ISSNHistory[0];
    private transient ISSNHistory[] history;
    private ISSNHistory activeHistory;

    public ISSNHistory getActiveHistory() {
        if (this.activeHistory == null) {
            CollectionFilter cf = new CollectionFilter();
            cf.addFilterCriteria(SSNHistoryFilterFactory.createFilterActiveHistory());
            Iterator itr = cf.filterCopy(this.historyStore).iterator();
            if (itr.hasNext()) {
                this.activeHistory = (ISSNHistory)itr.next();
            }
        }
        return this.activeHistory;
    }

    @Override
    public IPersonTrait getPersonTrait() {
        return this.personTrait;
    }

    @Override
    public void setPersonTrait(IPersonTrait personTrait) {
        this.personTrait = (PersonTrait)personTrait;
    }

    @Override
    public Set getHistoryStore() {
        return this.historyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHistoryStore(Set historyStore) {
        Set set = this.historyStore;
        synchronized (set) {
            this.historyStore = historyStore;
            this.history = null;
        }
    }

    @Override
    public String getPseudoSSNReason() {
        return this.pseudoSSNReason;
    }

    @Override
    public void setPseudoSSNReason(String pseudoSSNReason) {
        this.pseudoSSNReason = pseudoSSNReason;
    }

    @Override
    public Date getReceivedFromSSA() {
        return this.receivedFromSSA;
    }

    @Override
    public void setReceivedFromSSA(Date receivedFromSSA) {
        this.receivedFromSSA = receivedFromSSA;
    }

    @Override
    public Date getSentToSSA() {
        return this.sentToSSA;
    }

    @Override
    public void setSentToSSA(Date sentToSSA) {
        this.sentToSSA = sentToSSA;
    }

    @Override
    public String getSsaMessageType() {
        return this.ssaMessageType;
    }

    @Override
    public void setSsaMessageType(String ssaMessageType) {
        this.ssaMessageType = ssaMessageType;
    }

    @Override
    public String getSsaVerificationCode() {
        SSAVerificationCode type;
        if (this.ssaVerificationCode == null && (type = this.getSsaVerificationCode(new Timestamp(System.currentTimeMillis()))) != null) {
            this.ssaVerificationCode = type.getCode();
        }
        return this.ssaVerificationCode;
    }

    private SSAVerificationCode getSsaVerificationCode(Timestamp when) {
        ISSNHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].getSsaVerificationCode();
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setSsaVerificationCode(String ssaVerificationCode) {
        this.ssaVerificationCode = ssaVerificationCode;
    }

    @Override
    public IQualifiedIdentifier getSSN() {
        return this.ssn;
    }

    @Override
    public void setSSN(IQualifiedIdentifier ssn) {
        this.ssn = ssn;
    }

    @Override
    public String getSsnChangeSource() {
        return this.ssnChangeSource;
    }

    @Override
    public void setSsnChangeSource(String ssnChangeSource) {
        this.ssnChangeSource = ssnChangeSource;
    }

    @Override
    public String getSsnType() {
        SSNType type;
        if (this.ssnType == null && (type = this.getSsnType(new Timestamp(System.currentTimeMillis()))) != null) {
            this.ssnType = type.getCode();
        }
        return this.ssnType;
    }

    public Long getSsnTypeId() {
        Long id = null;
        SSNType type = this.getSsnType(new Timestamp(System.currentTimeMillis()));
        if (type != null) {
            id = type.getId();
        }
        return id;
    }

    private SSNType getSsnType(Timestamp when) {
        ISSNHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].getSsnType();
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setSsnType(String ssnType) {
        this.ssnType = ssnType;
    }

    @Override
    public String getSsnVerificationStatus() {
        return this.ssnVerificationStatus;
    }

    @Override
    public void setSsnVerificationStatus(String ssnVerificationStatus) {
        this.ssnVerificationStatus = ssnVerificationStatus;
    }

    @Override
    public Date getVerifiedBySSA() {
        return this.verifiedBySSA;
    }

    @Override
    public void setVerifiedBySSA(Date verifiedBySSA) {
        this.verifiedBySSA = verifiedBySSA;
    }

    @Override
    public ISSNHistory[] getHistory() {
        return (ISSNHistory[])this.history().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISSNHistory[] history() {
        if (this.historyStore != null) {
            Set set = this.historyStore;
            synchronized (set) {
                if (this.history == null) {
                    Object[] temp = this.historyStore.toArray(HISTORY_TEMPLATE);
                    Arrays.sort(temp);
                    this.history = temp;
                }
            }
            return this.history;
        }
        return HISTORY_TEMPLATE;
    }

    @Override
    public String getSsn() {
        return this.getSsn(new Timestamp(System.currentTimeMillis()));
    }

    public String getSsn(Timestamp when) {
        ISSNHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].getSsn();
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isActive(Timestamp when) {
        ISSNHistory[] history = this.history();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].isActive();
            }
            ++i;
        }
        return false;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).toString();
    }

    public int compareTo(Object o) {
        int result = 0;
        if (!(o instanceof SSN)) {
            return -1;
        }
        SSN other = (SSN)o;
        Long value = this.getId();
        Long otherValue = other.getId();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public boolean equals(Object o) {
        int x = this.compareTo(o);
        return x == 0;
    }

    public void onSave() {
        this.personTrait.addSsn(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistory(SSNHistory value) {
        Set set = this.historyStore;
        synchronized (set) {
            this.historyStore.add(value);
            this.history = null;
        }
    }
}

