/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.common.IPerson;
import gov.va.med.person.idmgmt.common.IPersonCorrelation;
import gov.va.med.person.idmgmt.common.IPersonTrait;
import gov.va.med.person.idmgmt.common.IPersonVPID;
import gov.va.med.person.idmgmt.common.ISystemOfInterest;
import gov.va.med.person.idmgmt.db.PSDaoFactory;
import gov.va.med.person.idmgmt.db.hb.AbstractEntity;
import gov.va.med.person.idmgmt.db.hb.Person;
import gov.va.med.person.idmgmt.db.hb.PersonCorrelation;
import gov.va.med.person.idmgmt.db.hb.PersonTrait;
import gov.va.med.person.idmgmt.db.hb.SystemOfInterest;
import gov.va.med.person.idmgmt.util.IConstants;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonVPID
extends AbstractEntity
implements IPersonVPID,
IConstants {
    private static final long serialVersionUID = 1L;
    private String vpid;
    private String idState;
    private PersonVPID survivingVPID;
    private SystemOfInterest originalFacility;
    private Set personCorrelationsStore = new HashSet();
    private Set dupePotentialsStore = new HashSet();
    private Set personsStore = new HashSet();
    private static final IPersonCorrelation[] PERSON_CORRELATIONS_TEMPLATE = new IPersonCorrelation[0];
    private transient IPersonCorrelation[] personCorrelations;
    private static final IPerson[] PERSONS_TEMPLATE = new IPerson[0];
    private transient IPerson[] persons;
    private Date primaryViewLastUpdated;
    private String primaryViewTransactionType;
    private Date originalCreationDate;
    private String originalCreationUser;

    @Override
    public String getVpid() {
        return this.vpid;
    }

    @Override
    public void setVpid(String vpid) {
        this.vpid = vpid;
    }

    @Override
    public String getIdState() {
        return this.idState;
    }

    @Override
    public void setIdState(String idState) {
        this.idState = idState;
    }

    @Override
    public IPersonVPID getSurvivingVPID() {
        return this.survivingVPID;
    }

    public void setSurvivingVPID(PersonVPID survivingVPID) {
        this.survivingVPID = survivingVPID;
    }

    @Override
    public ISystemOfInterest getOriginalFacility() {
        return this.originalFacility;
    }

    public void setOriginalFacility(SystemOfInterest originalFacility) {
        this.originalFacility = originalFacility;
    }

    @Override
    public Set getPersonCorrelationsStore() {
        return this.personCorrelationsStore;
    }

    @Override
    public void setPersonCorrelationsStore(Set personCorrelationsStore) {
        this.personCorrelationsStore = personCorrelationsStore;
    }

    public Set getDupePotentialsStore() {
        return this.dupePotentialsStore;
    }

    public void setDupePotentialsStore(Set dupePotentialsStore) {
        this.dupePotentialsStore = dupePotentialsStore;
    }

    @Override
    public Set getPersonsStore() {
        return this.personsStore;
    }

    @Override
    public void setPersonsStore(Set personsStore) {
        this.personsStore = personsStore;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).toString();
    }

    @Override
    public IPersonTrait getPrimaryTrait() {
        int mpiVpidSequenceId = 49;
        String vpid = this.getVpid();
        if (vpid == null || vpid.length() < 7) {
            return null;
        }
        char vpidSeq = vpid.charAt(6);
        String stationNumber = "200PS";
        if (vpidSeq == '1') {
            stationNumber = "200M";
        }
        SystemOfInterest authSOI = PSDaoFactory.instance().getSystemOfInterestDAO().obtainBySiteCode(stationNumber);
        IPersonCorrelation[] correlations = this.getPersonCorrelations();
        IPersonCorrelation pc = null;
        int i = 0;
        while (i < correlations.length) {
            pc = correlations[i];
            if (authSOI.equals(pc.getSystemOfInterest())) {
                return pc.getPersonTrait();
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPerson(Person value) {
        Set set = this.personsStore;
        synchronized (set) {
            this.personsStore.add(value);
            this.persons = null;
        }
    }

    @Override
    public IPerson[] getPersons() {
        return (IPerson[])this.persons().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPerson[] persons() {
        if (this.personsStore != null) {
            Set set = this.personsStore;
            synchronized (set) {
                if (this.persons == null) {
                    Object[] temp = this.personsStore.toArray(PERSONS_TEMPLATE);
                    Arrays.sort(temp);
                    this.persons = temp;
                }
            }
            return this.persons;
        }
        return PERSONS_TEMPLATE;
    }

    @Override
    public IPersonCorrelation[] getPersonCorrelations() {
        return (IPersonCorrelation[])this.personCorrelations().clone();
    }

    @Override
    public void setSurvivingVPID(IPersonVPID survivingVPID) {
        this.survivingVPID = (PersonVPID)survivingVPID;
    }

    @Override
    public void setOriginalFacility(ISystemOfInterest originalFacility) {
        this.originalFacility = (SystemOfInterest)originalFacility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPersonCorrelation[] personCorrelations() {
        if (this.personCorrelationsStore != null) {
            Set set = this.personCorrelationsStore;
            synchronized (set) {
                if (this.personCorrelations == null) {
                    Object[] temp = this.personCorrelationsStore.toArray(PERSON_CORRELATIONS_TEMPLATE);
                    Arrays.sort(temp);
                    this.personCorrelations = temp;
                }
            }
            return this.personCorrelations;
        }
        return PERSON_CORRELATIONS_TEMPLATE;
    }

    public int compareTo(Object o) {
        int result = 0;
        if (!(o instanceof PersonVPID)) {
            return -1;
        }
        PersonVPID other = (PersonVPID)o;
        String value = this.getVpid();
        String otherValue = other.getVpid();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public boolean equals(Object o) {
        int x = this.compareTo(o);
        return x == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersonCorrelation(PersonTrait key, PersonCorrelation value) {
        Set set = this.personCorrelationsStore;
        synchronized (set) {
            this.personCorrelationsStore.add(value);
            this.personCorrelations = null;
        }
    }

    @Override
    public Date getPrimaryViewLastUpdated() {
        return this.primaryViewLastUpdated;
    }

    public void setPrimaryViewLastUpdated(Date value) {
        this.primaryViewLastUpdated = value;
    }

    @Override
    public String getPrimaryViewTransactionType() {
        return this.primaryViewTransactionType;
    }

    public void setPrimaryViewTransactionType(String value) {
        this.primaryViewTransactionType = value;
    }

    @Override
    public Date getOriginalCreationDate() {
        return this.originalCreationDate;
    }

    public void setOriginalCreationDate(Date value) {
        this.originalCreationDate = value;
    }

    @Override
    public String getOriginalCreationUser() {
        return this.originalCreationUser;
    }

    public void setOriginalCreationUser(String value) {
        this.originalCreationUser = value;
    }
}

