/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.common.IChangeType;
import gov.va.med.person.idmgmt.common.IPersonTrait;
import gov.va.med.person.idmgmt.common.IPersonTraitHistory;
import gov.va.med.person.idmgmt.common.IVerification;
import gov.va.med.person.idmgmt.db.hb.AbstractEntity;
import gov.va.med.person.idmgmt.db.hb.PersonTrait;
import gov.va.med.person.idmgmt.types.MultipleBirthIndicator;
import gov.va.med.person.idmgmt.util.IConstants;
import gov.va.med.term.access.Country;
import gov.va.med.term.access.Gender;
import gov.va.med.term.access.State;
import java.sql.Timestamp;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonTraitHistory
extends AbstractEntity
implements IPersonTraitHistory {
    private static final long serialVersionUID = 1L;
    private String dataman;
    private Long genderId;
    private String pobCity;
    private Long pobStateId;
    private Long pobCountryId;
    private String mothersMaiden;
    private Byte multiBirthInd;
    private Timestamp eventTimestamp;
    private String eventPersonID;
    private String dob;
    private String updateStatus;
    private Byte active;
    private Timestamp effectiveDate;
    private Timestamp expirationDate;
    private PersonTrait owner;
    private IVerification verification;
    private IChangeType changeType;
    private Gender gender;
    private Country pobCountry;
    private State pobState;
    private String tin;
    private String fin;
    private String roi;
    private String ipp;
    private String idState;

    @Override
    public String getDataman() {
        return this.dataman;
    }

    public void setDataman(String val) {
        this.dataman = val;
        String safeVal = String.valueOf(val) + "^^^^^NOT USED";
        String[] values = safeVal.split("\\^");
        this.tin = values[0];
        this.fin = values[1];
        this.roi = values[2];
        this.ipp = values[3];
        this.idState = values[4];
    }

    @Override
    public void setMultiBirthInd(Byte multiBirthInd) {
        this.multiBirthInd = multiBirthInd;
    }

    @Override
    public void setOwner(PersonTrait owner) {
        this.owner = owner;
    }

    @Override
    public void setVerification(IVerification verification) {
        this.verification = verification;
    }

    @Override
    public IChangeType getChangeType() {
        return this.changeType;
    }

    @Override
    public void setChangeType(IChangeType changeType) {
        this.changeType = changeType;
    }

    @Override
    public String getDob() {
        return this.dob;
    }

    @Override
    public void setDob(String dob) {
        this.dob = dob;
    }

    @Override
    public Timestamp getEffectiveDate() {
        return this.effectiveDate;
    }

    @Override
    public void setEffectiveDate(Timestamp effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Override
    public String getEventPersonID() {
        return this.eventPersonID;
    }

    @Override
    public void setEventPersonID(String eventPersonID) {
        this.eventPersonID = eventPersonID;
    }

    @Override
    public Timestamp getEventTimestamp() {
        return this.eventTimestamp;
    }

    @Override
    public void setEventTimestamp(Timestamp eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    @Override
    public Timestamp getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public void setExpirationDate(Timestamp expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Override
    public Long getGenderId() {
        return this.genderId;
    }

    @Override
    public void setGenderId(Long genderId) {
        this.genderId = genderId;
        this.gender = null;
    }

    @Override
    public String getMothersMaiden() {
        return this.mothersMaiden;
    }

    @Override
    public void setMothersMaiden(String mothersMaiden) {
        this.mothersMaiden = mothersMaiden;
    }

    @Override
    public Byte getMultiBirthInd() {
        return this.multiBirthInd;
    }

    @Override
    public MultipleBirthIndicator getMultiBirth() {
        return new MultipleBirthIndicator(this.getMultiBirthInd());
    }

    @Override
    public IPersonTrait getOwner() {
        return this.owner;
    }

    @Override
    public String getPobCity() {
        return this.pobCity;
    }

    @Override
    public void setPobCity(String aPobCity) {
        this.pobCity = aPobCity != null ? aPobCity.toUpperCase() : aPobCity;
    }

    @Override
    public Long getPobCountryId() {
        return this.pobCountryId;
    }

    @Override
    public void setPobCountryId(Long pobCountryId) {
        this.pobCountryId = pobCountryId;
        this.pobCountry = null;
    }

    @Override
    public Long getPobStateId() {
        return this.pobStateId;
    }

    @Override
    public void setPobStateId(Long pobStateId) {
        this.pobStateId = pobStateId;
        this.pobState = null;
    }

    @Override
    public String getUpdateStatus() {
        return this.updateStatus;
    }

    @Override
    public void setUpdateStatus(String updateStatus) {
        this.updateStatus = updateStatus;
    }

    @Override
    public IVerification getVerification() {
        return this.verification;
    }

    @Override
    public Gender getGender() {
        if (this.gender == null && this.genderId != null) {
            this.gender = Gender.factory.obtainFromKeyValue(this.genderId);
        }
        return this.gender;
    }

    @Override
    public boolean isActive() {
        return IConstants.ONE.equals(this.active);
    }

    public void setActive(boolean value) {
        this.active = value ? IConstants.ONE : IConstants.ZERO;
    }

    public void setGender(Gender value) {
        this.gender = value;
        this.genderId = value != null ? value.getId() : null;
    }

    public void setPobCountry(Country value) {
        this.pobCountry = value;
        this.pobCountryId = value != null ? value.getId() : null;
    }

    @Override
    public Country getPobCountry() {
        if (this.pobCountry == null && this.pobCountryId != null) {
            this.pobCountry = Country.factory.obtainFromKeyValue(this.pobCountryId);
        }
        return this.pobCountry;
    }

    public void setPobState(State value) {
        this.pobState = value;
        this.pobStateId = value != null ? value.getId() : null;
    }

    @Override
    public State getPobState() {
        if (this.pobState == null && this.pobStateId != null) {
            this.pobState = State.factory.obtainFromKeyValue(this.pobStateId);
        }
        return this.pobState;
    }

    public void setMultiBirthInd(boolean b) {
        this.multiBirthInd = b ? IConstants.ONE : IConstants.ZERO;
    }

    public void setMultiBirth(MultipleBirthIndicator b) {
        if (b != null) {
            String multiBirthValue = b.getValue();
            if ("Y".equals(multiBirthValue)) {
                this.setMultiBirthInd(true);
            } else if ("N".equals(multiBirthValue)) {
                this.setMultiBirthInd(false);
            }
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).toString();
    }

    public int compareTo(Object o) {
        int result = 0;
        if (!(o instanceof PersonTraitHistory)) {
            return -1;
        }
        PersonTraitHistory other = (PersonTraitHistory)o;
        IPersonTrait value = this.getOwner();
        IPersonTrait otherValue = other.getOwner();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        if (result != 0) {
            return result;
        }
        Timestamp dateValue = this.getEffectiveDate();
        Timestamp otherDateValue = other.getEffectiveDate();
        if (dateValue == null) {
            return otherDateValue == null ? 0 : -1;
        }
        if (otherDateValue == null) {
            return 1;
        }
        result = dateValue.compareTo(otherDateValue);
        return result;
    }

    public boolean equals(Object o) {
        int x = this.compareTo(o);
        return x == 0;
    }

    public void onSave() {
        this.owner.addHistory(this);
    }

    public String getTin() {
        return this.tin;
    }

    public String getFin() {
        return this.fin;
    }

    public String getRoi() {
        return this.roi;
    }

    public String getIpp() {
        return this.ipp;
    }

    public String getIdState() {
        return this.idState;
    }
}

