/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.CollectionFilter;
import gov.va.med.person.idmgmt.PersonTraitHistoryFilter;
import gov.va.med.person.idmgmt.common.IPersonAddress;
import gov.va.med.person.idmgmt.common.IPersonCorrelation;
import gov.va.med.person.idmgmt.common.IPersonNPI;
import gov.va.med.person.idmgmt.common.IPersonName;
import gov.va.med.person.idmgmt.common.IPersonPhone;
import gov.va.med.person.idmgmt.common.IPersonTrait;
import gov.va.med.person.idmgmt.common.IPersonTraitHistory;
import gov.va.med.person.idmgmt.common.IPersonVPID;
import gov.va.med.person.idmgmt.common.ISSN;
import gov.va.med.person.idmgmt.db.hb.AbstractEntity;
import gov.va.med.person.idmgmt.db.hb.PersonAddress;
import gov.va.med.person.idmgmt.db.hb.PersonCorrelation;
import gov.va.med.person.idmgmt.db.hb.PersonNPI;
import gov.va.med.person.idmgmt.db.hb.PersonName;
import gov.va.med.person.idmgmt.db.hb.PersonPhone;
import gov.va.med.person.idmgmt.db.hb.PersonTraitHistory;
import gov.va.med.person.idmgmt.db.hb.PersonVPID;
import gov.va.med.person.idmgmt.db.hb.SSN;
import gov.va.med.person.idmgmt.db.hb.Verification;
import gov.va.med.person.idmgmt.types.MultipleBirthIndicator;
import gov.va.med.person.idmgmt.util.IConstants;
import gov.va.med.term.access.Country;
import gov.va.med.term.access.Gender;
import gov.va.med.term.access.State;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonTrait
extends AbstractEntity
implements IPersonTrait {
    private static final long serialVersionUID = 1L;
    private Set personNamesStore = new HashSet();
    private Set ssnsStore = new HashSet();
    private Set correlationsStore = new HashSet();
    private Set primaryPersonTraitEditsStore;
    private Set npisStore = new HashSet();
    private Set historyStore = new HashSet();
    private Set<PersonAddress> addressStore = new HashSet<PersonAddress>();
    private Set<PersonPhone> phoneStore = new HashSet<PersonPhone>();
    private transient IPersonPhone[] phones;
    private static final IPersonPhone[] PHONES_TEMPLATE = new IPersonPhone[0];
    private transient IPersonAddress[] addresses;
    private static final IPersonAddress[] ADDRESS_TEMPLATE = new IPersonAddress[0];
    private static final ISSN[] SSNS_TEMPLATE = new ISSN[0];
    private transient ISSN[] ssns;
    private static final IPersonTraitHistory[] HISTORY_TEMPLATE = new IPersonTraitHistory[0];
    private transient IPersonTraitHistory[] history;
    private static final IPersonName[] PERSON_NAMES_TEMPLATE = new IPersonName[0];
    private transient IPersonName[] personNames;
    private static final IPersonCorrelation[] CORRELATIONS_TEMPLATE = new IPersonCorrelation[0];
    private transient IPersonCorrelation[] correlations;
    private static final IPersonNPI[] NPIS_TEMPLATE = new IPersonNPI[0];
    private transient IPersonNPI[] npis;
    private PersonTraitHistory activeHistory = null;

    public String getDataman(Timestamp when) {
        try {
            return this.getActiveHistory(when).getDataman();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getDataman() {
        return this.getDataman(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public Set getNpisStore() {
        return this.npisStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNpisStore(Set npisStore) {
        Set set = this.npisStore;
        synchronized (set) {
            this.npisStore = npisStore;
            this.npis = null;
        }
    }

    @Override
    public Set getPersonNamesStore() {
        return this.personNamesStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPersonNamesStore(Set personNamesStore) {
        Set set = this.personNamesStore;
        synchronized (set) {
            this.personNamesStore = personNamesStore;
            this.personNames = null;
        }
    }

    @Override
    public Set getPrimaryPersonTraitEditsStore() {
        return this.primaryPersonTraitEditsStore;
    }

    @Override
    public void setPrimaryPersonTraitEditsStore(Set primaryPersonTraitEditsStore) {
        this.primaryPersonTraitEditsStore = primaryPersonTraitEditsStore;
    }

    @Override
    public Set getSsnsStore() {
        return this.ssnsStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSsnsStore(Set ssnsStore) {
        Set set = this.ssnsStore;
        synchronized (set) {
            this.ssnsStore = ssnsStore;
            this.ssns = null;
        }
    }

    @Override
    public ISSN[] getSsns() {
        return (ISSN[])this.ssns().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISSN[] ssns() {
        if (this.ssnsStore != null) {
            Set set = this.ssnsStore;
            synchronized (set) {
                if (this.ssns == null) {
                    Object[] temp = this.ssnsStore.toArray(SSNS_TEMPLATE);
                    Arrays.sort(temp);
                    this.ssns = temp;
                }
            }
            return this.ssns;
        }
        return SSNS_TEMPLATE;
    }

    @Override
    public String getDob() {
        return this.getDob(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public String getDob(Timestamp when) {
        try {
            return this.getActiveHistory(when).getDob();
        }
        catch (Exception e) {
            return null;
        }
    }

    public IPersonTraitHistory getHistory(Timestamp when) {
        try {
            return this.getActiveHistory(when);
        }
        catch (Exception e) {
            return null;
        }
    }

    public IPersonTraitHistory getActiveHistory() {
        return this.getActiveHistory(new Timestamp(System.currentTimeMillis()));
    }

    public IPersonTraitHistory getActiveHistory(Timestamp time) {
        if (this.activeHistory == null) {
            CollectionFilter cf = new CollectionFilter();
            cf.addFilterCriteria(new PersonTraitHistoryFilter(time, false));
            Iterator itr = cf.filterCopy(this.historyStore).iterator();
            if (itr.hasNext()) {
                this.activeHistory = (PersonTraitHistory)itr.next();
            }
        }
        return this.activeHistory;
    }

    @Override
    public Gender getGender() {
        return this.getGender(new Timestamp(System.currentTimeMillis()));
    }

    public Gender getGender(Timestamp when) {
        try {
            return this.getActiveHistory(when).getGender();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public IPersonCorrelation[] getCorrelations() {
        return (IPersonCorrelation[])this.correlations().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPersonCorrelation[] correlations() {
        if (this.correlationsStore != null) {
            Set set = this.correlationsStore;
            synchronized (set) {
                if (this.correlations == null) {
                    Object[] temp = this.correlationsStore.toArray(CORRELATIONS_TEMPLATE);
                    Arrays.sort(temp);
                    this.correlations = temp;
                }
            }
            return this.correlations;
        }
        return CORRELATIONS_TEMPLATE;
    }

    public Verification getVerification() {
        return this.getVerification(new Timestamp(System.currentTimeMillis()));
    }

    public Verification getVerification(Timestamp when) {
        try {
            return (Verification)this.getActiveHistory(when).getVerification();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getUpdateStatus() {
        return this.getUpdateStatus(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public String getUpdateStatus(Timestamp when) {
        try {
            return this.getActiveHistory(when).getUpdateStatus();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public IPersonNPI[] getNpis() {
        return (IPersonNPI[])this.npis().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPersonNPI[] npis() {
        if (this.npisStore != null) {
            Set set = this.npisStore;
            synchronized (set) {
                if (this.npis == null) {
                    Object[] temp = this.npisStore.toArray(NPIS_TEMPLATE);
                    Arrays.sort(temp);
                    this.npis = temp;
                }
            }
            return this.npis;
        }
        return NPIS_TEMPLATE;
    }

    @Override
    public IPersonCorrelation getPersonCorrelationFor(IPersonVPID key) {
        for (IPersonCorrelation o : this.correlationsStore) {
            if (!o.getPersonVPID().equals(key)) continue;
            return o;
        }
        return null;
    }

    @Override
    public String getPobCity() {
        return this.getPobCity(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public State getPobState() {
        return this.getPobState(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public Country getPobCountry() {
        return this.getPobCountry(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public String getMothersMaiden() {
        return this.getMothersMaiden(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public Byte getMultiBirthInd() {
        return this.getMultiBirthInd(new Timestamp(System.currentTimeMillis()));
    }

    public boolean isMultiBirth() {
        return IConstants.ONE.equals(this.getMultiBirthInd());
    }

    public String getMothersMaiden(Timestamp when) {
        try {
            return this.getActiveHistory(when).getMothersMaiden();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Byte getMultiBirthInd(Timestamp when) {
        try {
            return this.getActiveHistory(when).getMultiBirthInd();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPobCity(Timestamp when) {
        try {
            return this.getActiveHistory(when).getPobCity();
        }
        catch (Exception e) {
            return null;
        }
    }

    public State getPobState(Timestamp when) {
        try {
            return this.getActiveHistory(when).getPobState();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Country getPobCountry(Timestamp when) {
        try {
            return this.getActiveHistory(when).getPobCountry();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Set getHistoryStore() {
        return this.historyStore;
    }

    @Override
    public Set getCorrelationsStore() {
        return this.correlationsStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHistoryStore(Set historyStore) {
        Set set = this.historyStore;
        synchronized (set) {
            this.historyStore = historyStore;
            this.history = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCorrelationsStore(Set correlationsStore) {
        Set set = this.correlationsStore = correlationsStore;
        synchronized (set) {
            this.correlationsStore = correlationsStore;
            this.correlations = null;
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).toString();
    }

    public int compareTo(Object o) {
        int result = 0;
        if (!(o instanceof PersonTrait)) {
            return -1;
        }
        PersonTrait other = (PersonTrait)o;
        Long value = this.getId();
        Long otherValue = other.getId();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public boolean equals(Object o) {
        int x = this.compareTo(o);
        return x == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorrelation(PersonVPID key, PersonCorrelation value) {
        Set set = this.correlationsStore;
        synchronized (set) {
            this.correlationsStore.add(value);
            this.correlations = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersonName(PersonName name) {
        Set set = this.personNamesStore;
        synchronized (set) {
            this.personNamesStore.add(name);
            this.personNames = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNpi(PersonNPI value) {
        Set set = this.npisStore;
        synchronized (set) {
            this.npisStore.add(value);
            this.npis = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistory(PersonTraitHistory value) {
        Set set = this.historyStore;
        synchronized (set) {
            this.historyStore.add(value);
            this.history = null;
            this.activeHistory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSsn(SSN value) {
        Set set = this.ssnsStore;
        synchronized (set) {
            this.ssnsStore.add(value);
            this.ssns = null;
        }
    }

    @Override
    public IPersonName[] getActivePersonNames() {
        ArrayList<PersonName> activeNamesList = new ArrayList<PersonName>();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        TreeSet names = new TreeSet();
        names.addAll(this.personNamesStore);
        for (PersonName name : names) {
            if (name == null || name.getNameType() == null || !name.isActive(now)) continue;
            activeNamesList.add(name);
        }
        return activeNamesList.toArray(new IPersonName[activeNamesList.size()]);
    }

    public ISSN[] getActiveSSNs() {
        ISSN[] ssns = this.getSsns();
        ArrayList<ISSN> activeSSNsList = new ArrayList<ISSN>();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        int i = 0;
        while (i < ssns.length) {
            if (ssns[i] != null && ssns[i].getSsnType() != null && ssns[i].isActive(now)) {
                activeSSNsList.add(ssns[i]);
            }
            ++i;
        }
        return activeSSNsList.toArray(new ISSN[activeSSNsList.size()]);
    }

    @Override
    public String getEventPersonID() {
        return this.getEventPersonID(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public String getEventPersonID(Timestamp when) {
        try {
            return this.getActiveHistory(when).getEventPersonID();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Timestamp getEventTimestamp() {
        return this.getEventTimestamp(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public Timestamp getEventTimestamp(Timestamp when) {
        try {
            return this.getActiveHistory(when).getEventTimestamp();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Set<PersonAddress> getAddressStore() {
        return this.addressStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddressStore(Set<PersonAddress> addressStore) {
        Set<PersonAddress> set = this.addressStore;
        synchronized (set) {
            this.addressStore = addressStore;
            this.addresses = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAddress(PersonAddress value) {
        Set<PersonAddress> set = this.addressStore;
        synchronized (set) {
            this.addressStore.add(value);
            this.addresses = null;
        }
    }

    @Override
    public IPersonAddress[] getAddresses() {
        return (IPersonAddress[])this.addresses().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPersonAddress[] addresses() {
        if (this.addressStore != null) {
            Set<PersonAddress> set = this.addressStore;
            synchronized (set) {
                try {
                    if (this.addresses == null) {
                        IPersonAddress[] temp = this.addressStore.toArray(ADDRESS_TEMPLATE);
                        this.addresses = temp;
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            return this.addresses;
        }
        return ADDRESS_TEMPLATE;
    }

    @Override
    public Set<PersonPhone> getPhoneStore() {
        return this.phoneStore;
    }

    public void setPhoneStore(Set<PersonPhone> phoneStore) {
        this.phoneStore = phoneStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhone(PersonPhone value) {
        Set<PersonPhone> set = this.phoneStore;
        synchronized (set) {
            this.phoneStore.add(value);
            this.phones = null;
        }
    }

    @Override
    public IPersonPhone[] getPhones() {
        return (IPersonPhone[])this.phones().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPersonPhone[] phones() {
        if (this.phoneStore != null) {
            Set<PersonPhone> set = this.phoneStore;
            synchronized (set) {
                if (this.phones == null) {
                    IPersonPhone[] temp = this.phoneStore.toArray(PHONES_TEMPLATE);
                    this.phones = temp;
                }
            }
            return this.phones;
        }
        return PHONES_TEMPLATE;
    }

    @Override
    public MultipleBirthIndicator getMultiBirth() {
        return new MultipleBirthIndicator(this.getMultiBirthInd());
    }

    public MultipleBirthIndicator getMultiBirth(Timestamp when) {
        return new MultipleBirthIndicator(this.getMultiBirthInd(when));
    }
}

