/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.FilterCriteria;
import gov.va.med.person.idmgmt.common.IPersonPhoneHistory;
import gov.va.med.person.idmgmt.db.hb.PersonPhoneHistory;
import java.sql.Timestamp;

public class PersonPhoneHistoryFilterFactory {
    public static FilterCriteria createFilterActiveHistory() {
        return new ActivePhoneHistoryFilter(new Timestamp(System.currentTimeMillis()));
    }

    public static FilterCriteria createFilterTypeId(Long phoneTypeId) {
        return new TypeIdFilter(phoneTypeId);
    }

    private static class ActivePhoneHistoryFilter
    implements FilterCriteria {
        private Timestamp timestamp;
        private boolean inverse;

        public ActivePhoneHistoryFilter(Timestamp timestamp, boolean inverse) {
            this.inverse = inverse;
            this.timestamp = timestamp;
        }

        public ActivePhoneHistoryFilter(Timestamp timestamp) {
            this(timestamp, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof IPersonPhoneHistory) {
                boolean isMatch;
                IPersonPhoneHistory history = (IPersonPhoneHistory)obj;
                boolean bl = isMatch = (history.getEffectiveDate().before(this.timestamp) || history.getEffectiveDate().equals(this.timestamp)) && this.timestamp.before(history.getExpirationDate());
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class TypeIdFilter
    implements FilterCriteria {
        private Long typeId;
        private boolean inverse;

        TypeIdFilter(Long typeId, boolean inverse) {
            this.typeId = typeId;
            this.inverse = inverse;
        }

        TypeIdFilter(Long typeId) {
            this(typeId, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonPhoneHistory) {
                boolean isMatch;
                PersonPhoneHistory history = (PersonPhoneHistory)obj;
                boolean bl = isMatch = this.typeId.longValue() == history.getPhoneTypeId().longValue();
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }
}

