/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.FilterCriteria;
import gov.va.med.person.idmgmt.db.hb.PersonPhone;
import gov.va.med.person.idmgmt.db.hb.PersonPhoneHistory;

public class PersonPhoneFilterFactory {
    public static FilterCriteria createFilterActive() {
        return new ActiveFilter();
    }

    public static FilterCriteria createFilterExpired() {
        return new ActiveFilter(true);
    }

    public static FilterCriteria createFilterTypeId(Long phoneTypeId) {
        return new TypeIdFilter(phoneTypeId);
    }

    public static FilterCriteria createFilterNumber(String number) {
        return new NumberFilter(number);
    }

    public static FilterCriteria createFilterArea(String area) {
        return new AreaFilter(area);
    }

    public static FilterCriteria createFilterExtension(String extension) {
        return new ExtensionFilter(extension);
    }

    public static FilterCriteria createFilterCountryCode(String countryCode) {
        return new CountryCodeFilter(countryCode);
    }

    private static class ActiveFilter
    implements FilterCriteria {
        private boolean inverse;

        ActiveFilter(boolean inverse) {
            this.inverse = inverse;
        }

        ActiveFilter() {
            this(false);
        }

        @Override
        public boolean passes(Object obj) {
            boolean isMatch = false;
            if (obj != null && obj instanceof PersonPhone) {
                PersonPhone phone = (PersonPhone)obj;
                PersonPhoneHistory history = (PersonPhoneHistory)phone.getActiveHistory();
                isMatch = history == null ? false : history.isActive();
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class AreaFilter
    implements FilterCriteria {
        private String area;
        private boolean inverse;

        AreaFilter(String area, boolean inverse) {
            this.area = area;
            this.inverse = inverse;
        }

        AreaFilter(String area) {
            this(area, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonPhone) {
                PersonPhone phone = (PersonPhone)obj;
                boolean isMatch = this.area.equalsIgnoreCase(phone.getArea());
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class CountryCodeFilter
    implements FilterCriteria {
        private String countryCode;
        private boolean inverse;

        CountryCodeFilter(String countryCode, boolean inverse) {
            this.countryCode = countryCode;
            this.inverse = inverse;
        }

        CountryCodeFilter(String area) {
            this(area, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonPhone) {
                PersonPhone phone = (PersonPhone)obj;
                boolean isMatch = this.countryCode.equalsIgnoreCase(phone.getCountryCode());
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class ExtensionFilter
    implements FilterCriteria {
        private String extension;
        private boolean inverse;

        ExtensionFilter(String area, boolean inverse) {
            this.extension = area;
            this.inverse = inverse;
        }

        ExtensionFilter(String area) {
            this(area, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonPhone) {
                PersonPhone phone = (PersonPhone)obj;
                boolean isMatch = this.extension.equalsIgnoreCase(phone.getExtension());
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class NumberFilter
    implements FilterCriteria {
        private String number;
        private boolean inverse;

        NumberFilter(String number, boolean inverse) {
            this.number = number;
            this.inverse = inverse;
        }

        NumberFilter(String number) {
            this(number, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonPhone) {
                PersonPhone phone = (PersonPhone)obj;
                boolean isMatch = this.number.equalsIgnoreCase(phone.getNumber());
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class TypeIdFilter
    implements FilterCriteria {
        private Long typeId;
        private boolean inverse;

        TypeIdFilter(Long typeId, boolean inverse) {
            this.typeId = typeId;
            this.inverse = inverse;
        }

        TypeIdFilter(Long typeId) {
            this(typeId, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonPhone) {
                boolean isMatch;
                PersonPhone phone = (PersonPhone)obj;
                boolean bl = isMatch = this.typeId.longValue() == phone.getPhoneTypeId().longValue();
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }
}

