/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.CollectionFilter;
import gov.va.med.person.idmgmt.common.IPersonPhone;
import gov.va.med.person.idmgmt.common.IPersonPhoneHistory;
import gov.va.med.person.idmgmt.db.hb.AbstractEntity;
import gov.va.med.person.idmgmt.db.hb.Equivalent;
import gov.va.med.person.idmgmt.db.hb.PersonPhoneHistory;
import gov.va.med.person.idmgmt.db.hb.PersonPhoneHistoryFilterFactory;
import gov.va.med.person.idmgmt.db.hb.PersonTrait;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonPhone
extends AbstractEntity
implements IPersonPhone {
    static final long serialVersionUID = 7616733403091469458L;
    private PersonTrait personTrait;
    private Set historyStore = new HashSet();
    private IPersonPhoneHistory activeHistory;
    private transient IPersonPhoneHistory[] history;
    private static final IPersonPhoneHistory[] HISTORY_TEMPLATE = new IPersonPhoneHistory[0];

    public PersonTrait getPersonTrait() {
        return this.personTrait;
    }

    public void setPersonTrait(PersonTrait personTrait) {
        this.personTrait = personTrait;
    }

    @Override
    public Set getHistoryStore() {
        return this.historyStore;
    }

    @Override
    public void setHistoryStore(Set historyStore) {
        this.historyStore = historyStore;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("personTraitId", (Object)this.personTrait).append("version", (Object)this.getVersion()).append("AuditInfo", (Object)this.getAuditInfo()).toString();
    }

    public void onSave() {
        this.personTrait.addPhone(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistory(PersonPhoneHistory value) {
        Set set = this.historyStore;
        synchronized (set) {
            this.historyStore.add(value);
            this.history = null;
            this.activeHistory = null;
        }
    }

    public IPersonPhoneHistory[] getHistory() {
        return (IPersonPhoneHistory[])this.history().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPersonPhoneHistory[] history() {
        if (this.historyStore != null) {
            Set set = this.historyStore;
            synchronized (set) {
                if (this.history == null) {
                    IPersonPhoneHistory[] temp = this.historyStore.toArray(HISTORY_TEMPLATE);
                    this.history = temp;
                }
            }
            return this.history;
        }
        return HISTORY_TEMPLATE;
    }

    public IPersonPhoneHistory getPhone() {
        return this.getPhone(PersonPhone.getToday());
    }

    public IPersonPhoneHistory getPhone(Timestamp when) {
        IPersonPhoneHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i];
            }
            ++i;
        }
        return null;
    }

    public IPersonPhoneHistory getActiveHistory() {
        if (this.activeHistory == null) {
            CollectionFilter cf = new CollectionFilter();
            cf.addFilterCriteria(PersonPhoneHistoryFilterFactory.createFilterActiveHistory());
            Iterator itr = cf.filterCopy(this.historyStore).iterator();
            if (itr.hasNext()) {
                this.activeHistory = (IPersonPhoneHistory)itr.next();
            }
        }
        return this.activeHistory;
    }

    public String getArea() {
        try {
            return this.getActiveHistory().getArea();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getPhoneTypeId() {
        try {
            return this.getActiveHistory().getPhoneTypeId();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getExtension() {
        try {
            return this.getActiveHistory().getExtension();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getNumber() {
        try {
            return this.getActiveHistory().getNumber();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCountryCode() {
        try {
            return this.getActiveHistory().getCountryCode();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        boolean isEqual = true;
        isEqual = obj == null || !(obj instanceof PersonPhone) ? false : (((PersonPhone)obj).getActiveHistory() == null || this.getActiveHistory() == null ? super.equals(obj) : this.isEquivalent((PersonPhone)obj));
        return isEqual;
    }

    public int hashCode() {
        PersonPhoneHistory history = (PersonPhoneHistory)this.getActiveHistory();
        if (history == null) {
            return super.hashCode();
        }
        return new HashCodeBuilder(19, 39).appendSuper(135).append((Object)this.getArea()).append((Object)this.getCountryCode()).append((Object)this.getNumber()).append((Object)this.getExtension()).append((Object)this.getPhoneTypeId()).toHashCode();
    }

    private boolean isEquivalent(PersonPhone phone) {
        return Equivalent.isEquivalent(this.getArea(), phone.getArea()) && Equivalent.isEquivalent(this.getCountryCode(), phone.getCountryCode()) && Equivalent.isEquivalent(this.getNumber(), phone.getNumber()) && Equivalent.isEquivalent(this.getExtension(), phone.getExtension()) && Equivalent.isEquivalent(this.getPhoneTypeId(), phone.getPhoneTypeId());
    }
}

