/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.FilterCriteria;
import gov.va.med.person.idmgmt.common.IPersonNameHistory;
import gov.va.med.person.idmgmt.db.hb.PersonNameHistory;
import gov.va.med.term.access.NameType;
import java.sql.Timestamp;

public class PersonNameHistoryFilterFactory {
    public static FilterCriteria createFilterActiveHistory() {
        return new TimeStampHistoryFilter(new Timestamp(System.currentTimeMillis()));
    }

    public static FilterCriteria createFilterTimeStampedHistory(Timestamp timeStamp) {
        return new TimeStampHistoryFilter(timeStamp);
    }

    public static FilterCriteria createFilterNameTypeHistory(Long nameTypeId) {
        return new NameTypeHistoryFilter(nameTypeId);
    }

    private static class EffectiveDateFilter
    implements FilterCriteria {
        private Timestamp timestamp;
        private boolean inverse;

        EffectiveDateFilter(Timestamp timestamp, boolean inverse) {
            this.inverse = inverse;
            this.timestamp = timestamp;
        }

        EffectiveDateFilter(Timestamp timestamp) {
            this(timestamp, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof IPersonNameHistory) {
                boolean isMatch;
                IPersonNameHistory history = (IPersonNameHistory)obj;
                boolean bl = isMatch = (history.getEffectiveDate().before(this.timestamp) || history.getEffectiveDate().equals(this.timestamp)) && this.timestamp.before(history.getExpirationDate());
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class NameTypeHistoryFilter
    implements FilterCriteria {
        private Long typeId;
        private boolean inverse;

        NameTypeHistoryFilter(Long typeId, boolean inverse) {
            this.typeId = typeId;
            this.inverse = inverse;
        }

        NameTypeHistoryFilter(Long typeId) {
            this(typeId, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonNameHistory) {
                boolean isMatch = false;
                PersonNameHistory history = (PersonNameHistory)obj;
                NameType type = history.getNameType();
                if (type == null) {
                    isMatch = false;
                } else {
                    boolean bl = isMatch = this.typeId.longValue() == type.getId().longValue();
                }
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class TimeStampHistoryFilter
    implements FilterCriteria {
        private Timestamp timestamp;
        private boolean inverse;

        TimeStampHistoryFilter(Timestamp timestamp, boolean inverse) {
            this.inverse = inverse;
            this.timestamp = timestamp;
        }

        TimeStampHistoryFilter(Timestamp timestamp) {
            this(timestamp, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof IPersonNameHistory) {
                boolean isMatch;
                IPersonNameHistory history = (IPersonNameHistory)obj;
                boolean bl = isMatch = (history.getEffectiveDate().before(this.timestamp) || history.getEffectiveDate().equals(this.timestamp)) && this.timestamp.before(history.getExpirationDate());
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }
}

