/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.FilterCriteria;
import gov.va.med.person.idmgmt.db.hb.PersonName;
import gov.va.med.person.idmgmt.db.hb.PersonNameHistory;
import gov.va.med.term.access.NameType;

public class PersonNameFilterFactory {
    public static FilterCriteria createFilterActive() {
        return new ActiveFilter();
    }

    public static FilterCriteria createFilterExpired() {
        return new ActiveFilter(true);
    }

    public static FilterCriteria createFilterNameTypeId(Long nameTypeId) {
        return new NameTypeIdFilter(nameTypeId);
    }

    public static FilterCriteria createFilterFirstName(String firstName) {
        return new FirstNameFilter(firstName);
    }

    public static FilterCriteria createFilterLastName(String lastName) {
        return new LastNameFilter(lastName);
    }

    public static FilterCriteria createFilterMiddleName(String middleName) {
        return new MiddleNameFilter(middleName);
    }

    public static FilterCriteria createFilterSuffixName(String suffix) {
        return new SuffixNameFilter(suffix);
    }

    private static class ActiveFilter
    implements FilterCriteria {
        private boolean inverse;

        ActiveFilter(boolean inverse) {
            this.inverse = inverse;
        }

        ActiveFilter() {
            this(false);
        }

        @Override
        public boolean passes(Object obj) {
            boolean isMatch = false;
            if (obj != null && obj instanceof PersonName) {
                PersonName name = (PersonName)obj;
                PersonNameHistory history = (PersonNameHistory)name.getActiveHistory();
                isMatch = history == null ? false : history.isActive();
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class FirstNameFilter
    implements FilterCriteria {
        private String firstName;
        private boolean inverse;

        FirstNameFilter(String firstName, boolean inverse) {
            this.firstName = firstName;
            this.inverse = inverse;
        }

        FirstNameFilter(String firstName) {
            this(firstName, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonName) {
                PersonName name = (PersonName)obj;
                String dbValue = name.getFirstName();
                if (dbValue == null) {
                    dbValue = "";
                }
                boolean isMatch = this.firstName.equalsIgnoreCase(dbValue);
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class LastNameFilter
    implements FilterCriteria {
        private String lastName;
        private boolean inverse;

        LastNameFilter(String lastName, boolean inverse) {
            this.lastName = lastName;
            this.inverse = inverse;
        }

        LastNameFilter(String lastName) {
            this(lastName, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonName) {
                PersonName name = (PersonName)obj;
                String dbValue = name.getLastName();
                if (dbValue == null) {
                    dbValue = "";
                }
                boolean isMatch = this.lastName.equalsIgnoreCase(dbValue);
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class MiddleNameFilter
    implements FilterCriteria {
        private String middleName;
        private boolean inverse;

        MiddleNameFilter(String middleName, boolean inverse) {
            this.middleName = middleName;
            this.inverse = inverse;
        }

        MiddleNameFilter(String middleName) {
            this(middleName, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonName) {
                PersonName name = (PersonName)obj;
                String dbValue = name.getMiddleName();
                if (dbValue == null) {
                    dbValue = "";
                }
                boolean isMatch = this.middleName.equalsIgnoreCase(dbValue);
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class NameTypeIdFilter
    implements FilterCriteria {
        private Long typeId;
        private boolean inverse;

        NameTypeIdFilter(Long typeId, boolean inverse) {
            this.typeId = typeId;
            this.inverse = inverse;
        }

        NameTypeIdFilter(Long typeId) {
            this(typeId, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonName) {
                boolean isMatch = false;
                PersonName name = (PersonName)obj;
                NameType type = name.getNameType();
                if (type == null) {
                    isMatch = false;
                } else {
                    boolean bl = isMatch = this.typeId.longValue() == name.getNameType().getId().longValue();
                }
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }

    private static class SuffixNameFilter
    implements FilterCriteria {
        private String suffixName;
        private boolean inverse;

        SuffixNameFilter(String sufixName, boolean inverse) {
            this.suffixName = sufixName;
            this.inverse = inverse;
        }

        SuffixNameFilter(String suffixName) {
            this(suffixName, false);
        }

        @Override
        public boolean passes(Object obj) {
            if (obj != null && obj instanceof PersonName) {
                PersonName name = (PersonName)obj;
                String dbValue = name.getNameSuffix();
                if (dbValue == null) {
                    dbValue = "";
                }
                boolean isMatch = this.suffixName.equalsIgnoreCase(dbValue);
                if (this.inverse) {
                    return !isMatch;
                }
                return isMatch;
            }
            return false;
        }
    }
}

