/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.CollectionFilter;
import gov.va.med.person.idmgmt.common.IPersonName;
import gov.va.med.person.idmgmt.common.IPersonNameHistory;
import gov.va.med.person.idmgmt.common.IPersonTrait;
import gov.va.med.person.idmgmt.db.hb.AbstractEntity;
import gov.va.med.person.idmgmt.db.hb.PersonNameHistory;
import gov.va.med.person.idmgmt.db.hb.PersonNameHistoryFilterFactory;
import gov.va.med.person.idmgmt.db.hb.PersonTrait;
import gov.va.med.term.access.NameType;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonName
extends AbstractEntity
implements IPersonName {
    private static final long serialVersionUID = 1L;
    private PersonTrait personTrait;
    private Set historyStore = new HashSet();
    private static final IPersonNameHistory[] HISTORY_TEMPLATE = new IPersonNameHistory[0];
    private transient IPersonNameHistory[] history;
    private IPersonNameHistory activeHistory = null;

    @Override
    public IPersonTrait getPersonTrait() {
        return this.personTrait;
    }

    public void setPersonTrait(IPersonTrait personTrait) {
        this.personTrait = (PersonTrait)personTrait;
    }

    @Override
    public Set getHistoryStore() {
        return this.historyStore;
    }

    @Override
    public void setHistoryStore(Set historyStore) {
        this.historyStore = historyStore;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).toString();
    }

    @Override
    public String getFirstName() {
        return this.getFirstName(PersonName.getToday());
    }

    @Override
    public String getFirstName(Timestamp when) {
        IPersonNameHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].getFirstName();
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getLastName() {
        return this.getLastName(PersonName.getToday());
    }

    @Override
    public String getLastName(Timestamp when) {
        IPersonNameHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].getLastName();
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getMiddleName() {
        return this.getMiddleName(PersonName.getToday());
    }

    @Override
    public String getMiddleName(Timestamp when) {
        IPersonNameHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].getMiddleName();
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getNamePrefix() {
        return this.getNamePrefix(PersonName.getToday());
    }

    public String getNamePrefix(Timestamp when) {
        IPersonNameHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].getNamePrefix();
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getNameSuffix() {
        return this.getNameSuffix(PersonName.getToday());
    }

    public String getNameSuffix(Timestamp when) {
        IPersonNameHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].getNameSuffix();
            }
            ++i;
        }
        return null;
    }

    @Override
    public IPersonNameHistory[] getHistory() {
        return (IPersonNameHistory[])this.history().clone();
    }

    @Override
    public IPersonNameHistory getHistory(Timestamp when) {
        IPersonNameHistory[] nameHistory = this.getHistory();
        int historyLength = nameHistory.length;
        IPersonNameHistory foundHistory = null;
        int i = 0;
        while (i < historyLength) {
            if ((nameHistory[i].getEffectiveDate().before(when) || nameHistory[i].getEffectiveDate().equals(when)) && when.before(nameHistory[i].getExpirationDate())) {
                foundHistory = nameHistory[i];
                break;
            }
            ++i;
        }
        return foundHistory;
    }

    public IPersonNameHistory getActiveHistory() {
        if (this.activeHistory == null) {
            CollectionFilter cf = new CollectionFilter();
            cf.addFilterCriteria(PersonNameHistoryFilterFactory.createFilterActiveHistory());
            Iterator itr = cf.filterCopy(this.historyStore).iterator();
            if (itr.hasNext()) {
                this.activeHistory = (IPersonNameHistory)itr.next();
            }
        }
        return this.activeHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPersonNameHistory[] history() {
        if (this.historyStore != null) {
            Set set = this.historyStore;
            synchronized (set) {
                if (this.history == null) {
                    Object[] temp = this.historyStore.toArray(HISTORY_TEMPLATE);
                    Arrays.sort(temp);
                    this.history = temp;
                }
            }
            return this.history;
        }
        return HISTORY_TEMPLATE;
    }

    @Override
    public NameType getNameType() {
        NameType nameType = null;
        IPersonNameHistory activeHistory = this.getActiveHistory();
        if (activeHistory != null) {
            nameType = activeHistory.getNameType();
        }
        return nameType;
    }

    @Override
    public Set getAliasSSNLinks() {
        IPersonNameHistory[] history = this.getHistory();
        Timestamp when = PersonName.getToday();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].getAliasSSNLinks();
            }
            ++i;
        }
        return null;
    }

    public int compareTo(Object o) {
        int result = 0;
        if (!(o instanceof PersonName)) {
            return -1;
        }
        PersonName other = (PersonName)o;
        Long value = this.getId();
        Long otherValue = other.getId();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public boolean equals(Object o) {
        int x = this.compareTo(o);
        return x == 0;
    }

    public void onSave() {
        this.personTrait.addPersonName(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistory(PersonNameHistory value) {
        Set set = this.historyStore;
        synchronized (set) {
            this.historyStore.add(value);
            this.history = null;
        }
    }

    @Override
    public boolean isActive(Timestamp when) {
        IPersonNameHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].isActive();
            }
            ++i;
        }
        return false;
    }
}

