/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.common.IPersonNPI;
import gov.va.med.person.idmgmt.common.IPersonNPIHistory;
import gov.va.med.person.idmgmt.db.hb.AbstractEntity;
import gov.va.med.person.idmgmt.db.hb.PersonNPI;
import gov.va.med.person.idmgmt.util.IConstants;
import java.sql.Timestamp;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonNPIHistory
extends AbstractEntity
implements IPersonNPIHistory {
    private static final long serialVersionUID = 1L;
    private String npi;
    private Byte active;
    private Timestamp effectiveDate;
    private Timestamp expirationDate;
    private PersonNPI owner;

    @Override
    public String getNpi() {
        return this.npi;
    }

    @Override
    public void setNpi(String npi) {
        this.npi = npi;
    }

    public Byte getActive() {
        return this.active;
    }

    public void setActive(Byte active) {
        this.active = active;
    }

    @Override
    public Timestamp getEffectiveDate() {
        return this.effectiveDate;
    }

    @Override
    public void setEffectiveDate(Timestamp effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Override
    public Timestamp getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public void setExpirationDate(Timestamp expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Override
    public IPersonNPI getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(IPersonNPI owner) {
        this.owner = (PersonNPI)owner;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).toString();
    }

    @Override
    public boolean isActive() {
        return IConstants.ONE.equals(this.active);
    }

    public void setActive(boolean b) {
        this.active = b ? IConstants.ONE : IConstants.ZERO;
    }

    public void onSave() {
        this.owner.addHistory(this);
    }

    public int compareTo(Object o) {
        int result = 0;
        if (!(o instanceof PersonNPIHistory)) {
            return -1;
        }
        PersonNPIHistory other = (PersonNPIHistory)o;
        IPersonNPI value = this.getOwner();
        IPersonNPI otherValue = other.getOwner();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        if (result != 0) {
            return result;
        }
        Timestamp dateValue = this.getEffectiveDate();
        Timestamp otherDateValue = other.getEffectiveDate();
        if (dateValue == null) {
            return otherDateValue == null ? 0 : -1;
        }
        if (otherDateValue == null) {
            return 1;
        }
        result = dateValue.compareTo(otherDateValue);
        return result;
    }

    public boolean equals(Object o) {
        int x = this.compareTo(o);
        return x == 0;
    }
}

