/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.idmgmt.db.hb;

import gov.va.med.person.idmgmt.common.IPersonNPI;
import gov.va.med.person.idmgmt.common.IPersonNPIHistory;
import gov.va.med.person.idmgmt.common.IPersonTrait;
import gov.va.med.person.idmgmt.db.hb.AbstractEntity;
import gov.va.med.person.idmgmt.db.hb.PersonNPIHistory;
import gov.va.med.person.idmgmt.db.hb.PersonTrait;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonNPI
extends AbstractEntity
implements IPersonNPI {
    private static final long serialVersionUID = 1L;
    private PersonTrait personTrait;
    private Set historyStore = new HashSet();
    private transient IPersonNPIHistory[] history;
    private static final IPersonNPIHistory[] HISTORY_TEMPLATE = new IPersonNPIHistory[0];

    @Override
    public IPersonTrait getPersonTrait() {
        return this.personTrait;
    }

    public void setPersonTrait(PersonTrait personTrait) {
        this.personTrait = personTrait;
    }

    @Override
    public Set getHistoryStore() {
        return this.historyStore;
    }

    @Override
    public void setHistoryStore(Set historyStore) {
        this.historyStore = historyStore;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).toString();
    }

    @Override
    public String getNpi() {
        return this.getNpi(new Timestamp(System.currentTimeMillis()));
    }

    public String getNpi(Timestamp when) {
        IPersonNPIHistory[] npiHist = this.getHistory();
        int i = 0;
        while (i < npiHist.length) {
            if ((this.history[i].getEffectiveDate().before(when) || this.history[i].getEffectiveDate().equals(when)) && when.before(this.history[i].getExpirationDate())) {
                return this.history[i].getNpi();
            }
            ++i;
        }
        return null;
    }

    @Override
    public IPersonNPIHistory[] getHistory() {
        return (IPersonNPIHistory[])this.history().clone();
    }

    @Override
    public void setPersonTrait(IPersonTrait personTrait) {
        this.personTrait = (PersonTrait)personTrait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPersonNPIHistory[] history() {
        if (this.historyStore != null) {
            Set set = this.historyStore;
            synchronized (set) {
                if (this.history == null) {
                    Object[] temp = this.historyStore.toArray(HISTORY_TEMPLATE);
                    Arrays.sort(temp);
                    this.history = temp;
                }
            }
            return this.history;
        }
        return HISTORY_TEMPLATE;
    }

    @Override
    public boolean isActive() {
        return this.isActive(new Timestamp(System.currentTimeMillis()));
    }

    public boolean isActive(Timestamp when) {
        IPersonNPIHistory[] history = this.getHistory();
        int i = 0;
        while (i < history.length) {
            if ((history[i].getEffectiveDate().before(when) || history[i].getEffectiveDate().equals(when)) && when.before(history[i].getExpirationDate())) {
                return history[i].isActive();
            }
            ++i;
        }
        return false;
    }

    public int compareTo(Object o) {
        int result = 0;
        if (!(o instanceof PersonNPI)) {
            return -1;
        }
        PersonNPI other = (PersonNPI)o;
        Long value = this.getId();
        Long otherValue = other.getId();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public boolean equals(Object o) {
        int x = this.compareTo(o);
        return x == 0;
    }

    public void onSave() {
        this.personTrait.addNpi(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistory(PersonNPIHistory value) {
        Set set = this.historyStore;
        synchronized (set) {
            this.historyStore.add(value);
            this.history = null;
        }
    }
}

